<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('SD2ND_SKILL_SORT_KEY_SKILL_ID', 1);
define('SD2ND_SKILL_SORT_KEY_SKILL_NAME', 2);
define('SD2ND_SKILL_SORT_KEY_DESCRIPTION', 3);
define('SD2ND_SKILL_SORT_KEY_RANGE', 4);
define('SD2ND_SKILL_SORT_KEY_TARGET', 5);
define('SD2ND_SKILL_SORT_KEY_KIND', 6);
define('SD2ND_SKILL_SORT_KEY_TP', 7);
define('SD2ND_SKILL_SORT_KEY_REGIST_TIME', 8);
define('SD2ND_SKILL_SORT_KEY_DEFAULT', SD2ND_SKILL_SORT_KEY_SKILL_ID);

/**
 * Sd2nd_SkillFilterForm
**/
class Sd2nd_SkillFilterForm extends Sd2nd_AbstractFilterForm
{
    /**
     * @var  string[]
     * 
     * @public
    **/
    var $mSortKeys = array(
        SD2ND_SKILL_SORT_KEY_SKILL_ID => 'skill_id',
        SD2ND_SKILL_SORT_KEY_SKILL_NAME => 'skill_name',
        SD2ND_SKILL_SORT_KEY_DESCRIPTION => 'description',
        SD2ND_SKILL_SORT_KEY_RANGE => 'range',
        SD2ND_SKILL_SORT_KEY_TARGET => 'target',
        SD2ND_SKILL_SORT_KEY_KIND => 'kind',
        SD2ND_SKILL_SORT_KEY_TP => 'tp',
        SD2ND_SKILL_SORT_KEY_REGIST_TIME => 'regist_time'
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return SD2ND_SKILL_SORT_KEY_DEFAULT;
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
    
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
    
        if (($value = $request->getRequest('regist_time')) != null) {
            $this->_mCriteria->add(new Criteria('regist_time', $value));
        }
        $this->mNavi->addExtra('regist_time', $value);
    
        if (ctype_digit($value = $request->getRequest('range'))) {
            $this->_mCriteria->add(new Criteria('range', $value));
        }
        else
        {
            $value = null;
        }
        $this->mNavi->addExtra('range', $value);
    
        if (($value = $request->getRequest('target')) != null) {
            $this->_mCriteria->add(new Criteria('target', $value));
        }
        $this->mNavi->addExtra('target', $value);
    
        if (($value = $request->getRequest('kind')) != null) {
            $this->_mCriteria->add(new Criteria('kind', $value));
        }
        $this->mNavi->addExtra('kind', $value);
    
        $this->_mCriteria->addSort($this->getSort(), $this->getOrder());
    }
}

?>
