<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

if(!defined('SD2ND_TRUST_PATH'))
{
    define('SD2ND_TRUST_PATH',XOOPS_TRUST_PATH . '/modules/sd2nd');
}

require_once SD2ND_TRUST_PATH . '/class/Sd2ndUtils.class.php';

//
// Define a basic manifesto.
//
$modversion['name'] = _MI_SD2ND_LANG_SD2ND;
$modversion['version'] = 0.01;
$modversion['description'] = _MI_SD2ND_DESC_SD2ND;
$modversion['author'] = _MI_SD2ND_LANG_AUTHOR;
$modversion['credits'] = _MI_SD2ND_LANG_CREDITS;
$modversion['help'] = 'help.html';
$modversion['license'] = 'GPL';
$modversion['official'] = 0;
$modversion['image'] = 'images/sd2nd.png';
$modversion['dirname'] = $myDirName;
$modversion['trust_dirname'] = 'sd2nd';

$modversion['cube_style'] = true;
$modversion['legacy_installer'] = array(
    'installer'   => array(
        'class'     => 'Installer',
        'namespace' => 'Sd2nd',
        'filepath'  => SD2ND_TRUST_PATH . '/admin/class/installer/Sd2ndInstaller.class.php'
    ),
    'uninstaller' => array(
        'class'     => 'Uninstaller',
        'namespace' => 'Sd2nd',
        'filepath'  => SD2ND_TRUST_PATH . '/admin/class/installer/Sd2ndUninstaller.class.php'
    ),
    'updater' => array(
        'class'     => 'Updater',
        'namespace' => 'Sd2nd',
        'filepath'  => SD2ND_TRUST_PATH . '/admin/class/installer/Sd2ndUpdater.class.php'
    )
);
$modversion['disable_legacy_2nd_installer'] = false;

$modversion['sqlfile']['mysql'] = 'sql/mysql.sql';
$modversion['tables'] = array(
//    '{prefix}_{dirname}_xxxx',
   '{prefix}_{dirname}_ability',
   '{prefix}_{dirname}_active_ability',
   '{prefix}_{dirname}_char',
   '{prefix}_{dirname}_costume',
   '{prefix}_{dirname}_eno_pno_link',
   '{prefix}_{dirname}_icon',
   '{prefix}_{dirname}_image',
   '{prefix}_{dirname}_kind',
   '{prefix}_{dirname}_learned_ability',
   '{prefix}_{dirname}_learned_costume',
   '{prefix}_{dirname}_learned_skill',
   '{prefix}_{dirname}_map',
   '{prefix}_{dirname}_map_cache',
   '{prefix}_{dirname}_map_name',
   '{prefix}_{dirname}_map_spot',
   '{prefix}_{dirname}_race',
   '{prefix}_{dirname}_skill',
   '{prefix}_{dirname}_skill_element_link',
   '{prefix}_{dirname}_status',
   '{prefix}_{dirname}_target',
   '{prefix}_{dirname}_update',
##[cubson:tables]
##[/cubson:tables]
);

//
// Templates. You must never change [cubson] chunk to get the help of cubson.
//
$modversion['templates'] = array(
/*
    array(
        'file'        => '{dirname}_xxx.html',
        'description' => _MI_SD2ND_TPL_XXX
    ),
*/
##[cubson:templates]
    array('file' => '{dirname}_index.html','description' => _MI_SD2ND_TPL_INDEX),
    array('file' => '{dirname}_map_view.html','description' => _MI_SD2ND_TPL_MAP_VIEW),
    array('file' => '{dirname}_active_ability_list.html','description' => _MI_SD2ND_TPL_ACTIVE_ABILITY_LIST),
    array('file' => '{dirname}_learned_ability_list.html','description' => _MI_SD2ND_TPL_LEARNED_ABILITY_LIST),
    array('file' => '{dirname}_learned_skill_list.html','description' => _MI_SD2ND_TPL_LEARNED_SKILL_LIST),
    array('file' => '{dirname}_learned_costume_list.html','description' => _MI_SD2ND_TPL_LEARNED_COSTUME_LIST),
    array('file' => '{dirname}_ability_list.html','description' => _MI_SD2ND_TPL_ABILITY_LIST),
    array('file' => '{dirname}_costume_list.html','description' => _MI_SD2ND_TPL_COSTUME_LIST),
    array('file' => '{dirname}_skill_list.html','description' => _MI_SD2ND_TPL_SKILL_LIST),
##[/cubson:templates]
);

//
// Admin panel setting
//
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = 'admin/index.php';
$modversion['adminmenu'] = array(
/*
    array(
        'title'    => _MI_SD2ND_LANG_XXXX,
        'link'     => 'admin/index.php?action=xxx',
        'keywords' => _MI_SD2ND_KEYWORD_XXX,
        'show'     => true,
        'absolute' => false
    ),
*/
##[cubson:adminmenu]
##[/cubson:adminmenu]
);

//
// Public side control setting
//
$modversion['hasMain'] = 1;
$modversion['hasSearch'] = 0;
$modversion['sub'] = array(
/*
    array(
        'name' => _MI_SD2ND_LANG_SUB_XXX,
        'url'  => 'index.php?action=XXX'
    ),
*/
##[cubson:submenu]
##[/cubson:submenu]
);

//
// Config setting
//
$modversion['config'] = array(
/*
    array(
        'name'          => 'xxxx',
        'title'         => '_MI_SD2ND_TITLE_XXXX',
        'description'   => '_MI_SD2ND_DESC_XXXX',
        'formtype'      => 'xxxx',
        'valuetype'     => 'xxx',
        'options'       => array(xxx => xxx,xxx => xxx),
        'default'       => 0
    ),
*/
##[cubson:config]
##[/cubson:config]
);

//
// Block setting
//
$modversion['blocks'] = array(
/*
    x => array(
        'func_num'          => x,
        'file'              => 'xxxBlock.class.php',
        'class'             => 'xxx',
        'name'              => _MI_SD2ND_BLOCK_NAME_xxx,
        'description'       => _MI_SD2ND_BLOCK_DESC_xxx,
        'options'           => '',
        'template'          => '{dirname}_block_xxx.html',
        'show_all_module'   => true,
        'visible_any'       => true
    ),
*/
##[cubson:block]
##[/cubson:block]
);

?>
