/*********************************************************
 * record.c
 * vnc2swf recording function
 *********************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include "vncviewer.h"


pid_t vnc2swf_pid;
extern int record_tag;
extern char *vncdisplay;
extern size_t get_file_size(char *file);
extern void SendFileMsg (char flag, int sock, size_t fsize, char *fname, char *data);

char *get_stamp(char *stamp);

char file_name[STRLENGTH];


void start_record(int fps, char *geometry, char *path)
{
  if (GETREC_C) return;

  char swf_file[STRLENGTH];
  char dsp_no[4];
  char frame[4];

  sprintf(dsp_no, ":%s", vncdisplay);
  sprintf(frame, "%d", fps);
  sprintf(file_name, "%s%s.swf", client_CB.client_ID, get_stamp(swf_file));
  sprintf(swf_file, "%s%s", path, file_name);


  sigignore(SIGCLD);
  if ((vnc2swf_pid = fork()) == -1) {
    perror("fork: vnc2swf");
    return;
  }
  // to do child process
  else if (vnc2swf_pid == 0) {
    // set process group id
    setpgrp();

    sigignore(SIGCLD);
    switch (fork())
    {
      case -1:
        perror("fork: vnc4config");
	break;
      case 0:
        // execute vnc2swf
        fprintf(stderr, "##### record start #####\n");

        if (execlp("vnc2swf", "vnc2swf", "-shared", "-nowindow", "-framerate", frame, swf_file, "-listen", dsp_no, NULL) == -1){
          perror("vnc2swf");
        }
        // wait for childe process
        wait((int*)0);
        exit(0);
	break;
      default:
	sleep(SLEEP);
        // execute vnc4config
        if (execlp("vnc4config", "vnc4config", "-display", dsp_no, "-connect", "localhost", NULL) == -1){
          perror("vnc4config");
        }
	exit(0);
	break;
    }
    wait((int *)0);
  }
  // parent process
  else {
    SETREC_C(1);
  }
}

void
stop_record(void)
{
  if (!GETREC_C) return;
  gtk_timeout_remove(record_tag);

  if (kill(-vnc2swf_pid, SIGTERM) == -1) {
    perror("kill: vnc2swf");
    return;
  }
//  waitpid(-vnc2swf_pid, (int *)0, 0);
  sleep(SLEEP);

  SETREC_C(0);
  printf("##### record stop #####\n");

  printf("##### file send #####\n");
  // File send Adv
  FILE *fp;
  size_t fsize, psize;
  char flag, data[SWF_DATA +1];

  // get File size
  char swf_file[STRLENGTH];
  sprintf(swf_file, "%s%s", REC_PATH, file_name);
  fsize = get_file_size(swf_file);

  if((fp = fopen(swf_file, "rb")) == NULL) {
    fprintf(stderr, "Can't open swf_file\n");
    return;
  }

  // send file
  flag = START;

  fprintf(stderr, "%s file send start.\n", file_name);
  while(fsize > ftell(fp)) {
    (fsize - ftell(fp) < SWF_DATA) ? (psize = fsize - ftell(fp)) : (psize = SWF_DATA);
    fread(data, psize, 1, fp);
    SendFileMsg (flag, client_CB.ctldsp, psize, file_name, data);
    flag = CONTINUE;
  }

  /*
  while(fp == EOF) {
    psize = read(fp, data, SWF_DATA);
    SendFileMsg (flag, client_CB.ctldsp, psize, file_name, data);
    flag = CONTINUE;
  }
  */

  SendFileMsg (STOP, client_CB.ctldsp, fsize, file_name, NULL);
  fclose(fp);
  fprintf(stderr, "%s file send done.\n", file_name);

  sprintf(data, "rm -f %s", swf_file);
//  system(data);
}
