/*
 * fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef fs_h
#define fs_h


#include"types.h"
#include"proc.h"


#ifndef ASM_FILE


enum{
	/* File type */
	NORMAL_FILE=1,
	DIRECTORY=2,
	SYMBOL_LINK=3,
	DEVICE_FILE=4,
};


/* ե륷ƥ।ե᡼¤ */
typedef struct{
	const char *name;
	uint (*mount)(int);						/* prm:device inode  rtr:root directory block or error=0 */
	uint (*umount)(int);					/* prm:device inode  rtr:0 or error=-1 */
	uint (*open)(const char*,void*,int);	/* prm:path,directory block  rtr:inode block or error=0 */
	int (*read)(uint,void*,size_t,size_t);	/* prm:inode block,bffer,read blocks,offset rtr:read blocks or error=-1 */
	int (*write)(uint,void*,size_t,size_t);	/* prm:inode block,bffer,write blocks,offset rtr:write blocks or error=-1 */
	int (*ioctr)(uint,int,void*);
	int (*rename)(uint,const char*);
	int (*creat)(const char*,void*,int);
	uint (*opendir)(const char*,int,uint);	/* prm:path,device inode,parent directory block  rtr:directory block or error=0 */
	int (*mkdir)(const char*,void*,int);
	int (*close)(uint);
}FS;


extern FS *fs_info[];


extern void init_fs();
extern int regist_fs(FS*);
extern int cpy_file_struct(PROC*,PROC*);
extern int mount_root_fs(const char*,const char*);
extern int sys_open();
extern int sys_read();
extern int sys_write();
extern int sys_ioctr();
extern int sys_lseek();
extern int sys_rename();
extern int sys_creat();
extern int sys_unlink();
extern int sys_lock();
extern int sys_mount();
extern int sys_umount();
extern int chdir();


/*
 * ѥʸϤ롣
 * parmeters :
 */
extern inline size_t path_len(const char *s)
{
	const char *p=s;


	while(*p++!='/')
		if(*p=='\0')break;

	return (size_t)(p-s-1);
}


#endif


#endif
