/*
 * orig_fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef orig_fs_h
#define orig_fs_h


#include"types.h"
#include"mm.h"


#ifndef ASM_FILE


enum{
	SBLOCK_MAGIC=0xdddddddd,		/* superblock magic numberʲˡ */
	SBLOCK_SECTER=2,				/* ѡ֥åϥ */
	BLOCK_SIZE=1024,				/* ֥å */
	MAX_NAME_SIZE=128,				/* ե̾ */
	DIR_SIZE=4096,					/* ǥ쥯ȥꥵ */
	EMPTY_BLOCK_NUM=1022,			/* ץƥ֥åΥ֥å */
	INODE_BLOCK_NUM=(BLOCK_SIZE-40)/sizeof(uint),		/* inode֥å */
};


/* Super block entry */
typedef struct{
	size_t all_blk;			/* All blocks */
	size_t useable_blk;		/* Useable blocks */
	uint begin_blk;			/* Begin block number */
	uint empty_blk;			/* Begin of empty link secter number(Хɥ쥹) */
	uint magic_number;		/* ޥȻγǧѥޥåʥС */
}SUPER_BLOCK;

/* Inode */
typedef struct{
	int file_type;				/* File type */
	ushort owner_id;			/* Owner UID */
	ushort group_id;			/* Group ID */
	size_t size;				/* File size by byte */
	uint64 access_time;			/* Last access time */
	uint64 create_time;			/* Create time */
	uint64 modificat_time;		/* Last modification time */
	uint my_secter;				/* my block number */
	uint secter[INODE_BLOCK_NUM];	/* file secter number */
}INODE;

/* first directory top */
typedef struct{
	ushort owner_id;		/* Owner UID */
	ushort group_id;		/* Group ID */
	uint64 access_time;		/* Last access time */
	uint64 create_time;		/* Create time */
	uint64 modificat_time;	/* Last modification time */
	uint my_secter;			/* my block number */
	uint next_sect;			/* Next directory block */
	ushort entry_top;		/* Top direcctory entry offset */
	ushort empty_top;		/* Top empty entry offset */
}DIR;

/* next directory top */
typedef struct{
	uint next_sect;			/* Next directory block */
	uint my_secter;			/* my block number */
	ushort entry_top;		/* Top direcctory entry offset */
	ushort empty_top;		/* Top empty entry offset */
}DIR_NEXT;

/* Directory entry */
typedef struct{
	uchar type;					/* File or directory */
	uchar size;					/* entry size */
	uchar low_num;				/* low tree conect entries */
	uchar high_num;				/* high tree conect entries */
	ushort parent;				/* parent entry offset */
	ushort low;					/* low entry offset */
	ushort high;				/* high entry offset */
	uint secter;				/* secter number */
	char name[MAX_NAME_SIZE];	/* Name string */
}DIR_ENT;

/* Directory empty entry */
typedef struct{
	ushort prev;		/* prev empty entry */
	ushort next;		/* next empty entry */
	ushort size;		/* entry size */
}EMPTY_ENT;

/* Empty block description block struct */
typedef struct{
	uint next;
	int current;
	uint secter[EMPTY_BLOCK_NUM];
}EMPTY;


#endif


#endif
