/*
 * proc.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץط
 */


#include"types.h"
#include"mm.h"
#include"fs.h"
#include"errno.h"
#include"interrupt.h"
#include"lock.h"
#include"segment.h"
#include"time.h"
#include"proc.h"
/******************************/
#include"lib.h"
#include"test.h"
/*******************************/


/* tssǼ¤(104Х) */
typedef struct{
	uint link,esp0,ss0,esp1,ss1,esp2,ss2,cr3,eip,eflags,eax,ecx,
		edx,ebx,esp,ebp,esi,edi,es,cs,ss,ds,fs,gs,ldts,tflag_iomap;
}TSS;

/* sys_forkregister¤ */
typedef struct{
	uint ebx;
	uint ebp;
	uint esi;
	uint edi;
}SAVE_REG;

/* sys_forkѥƥ¸å¤ */
typedef struct{
	uint before_esp;		/* ͥȳγ߻esp */
	uint ds;
	uint es;
	uint edi;
	uint esi;
	uint ebp;
	uint esp;
	uint ebx;
	uint edx;
	uint ecx;
	uint eax;
	uint eip;
	uint cs;
	uint eflags;
}INTR_FRAME;


CPU cputask[MAX_CPU];		/* Task infomations for each cpu */

/* TSS󥰻Υååɬ */
static TSS kernel_tss={
	0,
	KERNEL_ESP_BEG,	/* esp0 */
	KERNEL_DATA_DES,	/* ss0 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
static PROC *idle_proc[MAX_CPU];	/* Idle process */
static CPU guard[2]={				/* Guard for link */
	{0,NULL,0,NULL,NULL},
	{0,NULL,~0,NULL,NULL}
};
static int cputask_gate=0;			/* Lock gate for cputask[] */
static int few_task_cpu=0;			/* ΰ־ʤcpu */
static int page_table_gate=0;		/* Lock gate for page table */


static void add_proc(PROC*);
static int change_cpu_link(int);


/******************************************************************************************************
 *
 * 塼ط
 *
 *******************************************************************************************************/


/*
 * Add task to shedule
 * parameters : Process
 */
void add_to_schedule(PROC *proc)
{
	int cpu;


	cpu=proc->cpu;

	cli();
	enter_spinlock(&cputask[cpu].gate);
	{
		if(cputask[cpu].current_task==idle_proc[cpu])
		{
			proc->next=proc;
			proc->prev=proc;
			idle_proc[cpu]->next=proc;
		}
		else
		{
			/*ߥ󥯤ƤȤ롣 */
			proc->prev->next=proc->next;
			proc->next->prev=proc->prev;

			/* ȥץμ˲ä */
			proc->prev=cputask[cpu].current_task;
			proc->next=cputask[cpu].current_task->next;
			cputask[cpu].current_task->next=proc;
			proc->next->prev=proc;
		}
	}
	exit_spinlock(&cputask[cpu].gate);
	sti();
}


/*
 * Delete process
 * parameters : process
 */
void del_from_schedule(PROC *proc)
{
	int cpu;


	cpu=proc->cpu;

	/* Delete current task */
	cli();
	enter_spinlock(&cputask[cpu].gate);
	{
		if(proc->next==proc)
		{
			idle_proc[cpu]->next=idle_proc[cpu];
			idle_proc[cpu]->prev=idle_proc[cpu];
			proc->next=idle_proc[cpu];
		}
		else
		{
			proc->prev->next=proc->next;
			proc->next->prev=proc->prev;
		}
	}
	exit_spinlock(&cputask[cpu].gate);
	sti();
}


/*
 * Process switch
 * parameters : γ߻Υ֥åȥåesp,γ߻espͤ¸륹å
 * returns : Page directory
 */
uint *switch_task(volatile uint esp,volatile uint before_esp)
{
	int cpu;
	PROC *current;


	cpu=get_current_cpu();
	current=cputask[cpu].current_task;
	before_esp=current->esp;
	current->esp=esp;

	current=current->next;
	esp=(uint)&current->esp;
	cputask[cpu].current_task=current;

	return current->pagedir;
}


/******************************************************************************************************
 *
 * ץ
 *
 *******************************************************************************************************/


/*
 * ץ¹Բǽˤ
 * parameters : process
 */
void add_proc(PROC *proc)
{
	int cpu;


	if(proc==NULL)return;

	cpu=few_task_cpu;
	proc->cpu=cpu;
	add_to_schedule(proc);
	++cputask[cpu].proc_num;

	/* Change cpu in which minimum numbers of task */
	few_task_cpu=change_cpu_link(cpu);
}


/*
 * Change cpu struct link to previous
 * parameters : cpu number
 * retuuns : Top link cpu number
 */
int change_cpu_link(int cpu)
{
	CPU *p;


	enter_spinlock(&cputask_gate);
	{
		/* to previous */
		if(cputask[cpu].proc_num<cputask[cpu].prev->proc_num)
		{
			for(p=cputask[cpu].prev->prev;cputask[cpu].proc_num<p->proc_num;p=p->prev);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p;
			cputask[cpu].next=p->next;
			p->next->prev=&cputask[cpu];
			p->next=&cputask[cpu];
		}
		/* to next */
		else if(cputask[cpu].proc_num>cputask[cpu].next->proc_num)
		{
			for(p=cputask[cpu].next->next;cputask[cpu].proc_num>p->proc_num;p=p->next);
			cputask[cpu].prev->next=cputask[cpu].next;
			cputask[cpu].next->prev=cputask[cpu].prev;
			cputask[cpu].prev=p->prev;
			cputask[cpu].next=p;
			p->prev->next=&cputask[cpu];
			p->prev=&cputask[cpu];
		}
	}
	exit_spinlock(&cputask_gate);

	return guard[0].next->cpu;
}


/******************************************************************************************************
 *
 * 
 *
 *******************************************************************************************************/


/*
 * Init taskcpu
 * cpu˥ꥢꤹɬפ
 * parameters : number of cpu
 * returns : NOERROR
 */
int init_cputask(int cpu)
{
	cputask[cpu].cpu=cpu;
	cputask[cpu].current_task=NULL;
	cputask[cpu].proc_num=0;
	cputask[cpu].gate=0;
	cputask[cpu].next=&guard[1];
	guard[1].prev=&cputask[cpu];
	if(cpu==0)
	{
		cputask[cpu].prev=&guard[0];
		guard[0].next=&cputask[cpu];
	}
	else
	{
		cputask[cpu].prev=&cputask[cpu-1];
		cputask[cpu-1].next=&cputask[cpu];
	}

	return 0;
}


/*
 * TSSǥץꤹ
 *  : ǥץ͡TSSɥ쥹
 */
void set_tss(int des)
{
	set_gdt(des,&kernel_tss,104,TYPE_TSS);

	asm volatile(
		"movl	%0,%%eax\n"
		"ltr	%%ax"
		::"m"(des)
	);
}


/*
 * Set idle process table
 * parameters : Page directory
 * returns : 0 or Error number
 */
int set_idle_proc(int cpu,uint *pagedir)
{
	/* Set process table */
	if((idle_proc[cpu]=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	idle_proc[cpu]->next=idle_proc[cpu];
	idle_proc[cpu]->prev=idle_proc[cpu];
	idle_proc[cpu]->pagedir=pagedir;
	idle_proc[cpu]->pagedir_gate=0;
	idle_proc[cpu]->cpu=cpu;

	/* add to schedule queue */
	cputask[cpu].current_task=idle_proc[cpu];

	return 0;
}


/******************************************************************************************************
 *
 * Task wait
 *
 *******************************************************************************************************/


/*
 * Wait process
 * ñ
 * parameters : Wait queue
 */
void wait_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	enter_spinlock(&queue->gate);
	{
		if(queue->flag==0)
		{
			queue->flag=1;
			exit_spinlock(&queue->gate);
			return;
		}
		else
		{
			proc=cputask[get_current_cpu()].current_task;

			/* Add process to wait queue */
			queue->wait_prev->wait_next=proc;
			proc->wait_next=(PROC*)queue;
			queue->wait_prev=proc;

			del_from_schedule(proc);
		}
	}
	exit_spinlock(&queue->gate);

	wait_task();
}


/*
 * Wake up process
 * parameters : Wait queue
 */
void wake_proc(WAIT_QUEUE *queue)
{
	PROC *proc;


	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if(queue->wait_prev==(PROC*)queue)queue->flag=0;
		else
		{
			proc=queue->wait_next;
			queue->wait_next=proc->wait_next;
			if(queue->wait_prev==proc)queue->wait_prev=(PROC*)queue;

			/* Add process to schedule */
			add_to_schedule(proc);
		}
	}
	exit_spinlock(&queue->gate);
}


/*
 * ޡԤ
 * parameters : ޡ߹¤,(ms)
 * return : 0,ॢ-1
 */
int wait_intr(WAIT_INTR *queue,int time)
{
	queue->proc=cputask[get_current_cpu()].current_task;

	cli();
	{
		if(queue->flag==1)
		{
			queue->flag=0;
			sti();
			return 0;
		}
		del_from_schedule(queue->proc);
		queue->flag=-1;
	}
	sti();

	sleep_task(time);

	if(queue->flag==1)queue->flag=0;

	return queue->flag;
}


/*
 * ޡԤ롣
 * parameters : ޡ߹¤
 * return : åɬ1,åʤ0
 */
int wake_intr(WAIT_INTR *queue)
{
	if(queue->flag==-1)
	{
		add_to_schedule(queue->proc);
		del_timer(queue->proc);
	}
	queue->flag=1;

	return 1;
}


/******************************************************************************************************
 *
 * System call interface
 *
 *******************************************************************************************************/


/*
 * ҥץư
 * return : Parent process return process ID,Child process return 0
 */
int sys_fork(SYSCALL0_FRAME frame)
{
	void *stack;
	uint *preturn=&frame.ds-1;
	PROC *parent,*child;
	INTR_FRAME *context_frame;
	SAVE_REG reg;


	/* ҥץΥƥȺѤ¸ɬפʥ쥸򤹤 */
	asm volatile(
		"movl	%%ebp,%3"
		:"=b"(reg.ebx),"=S"(reg.esi),"=D"(reg.edi):"g"(reg.ebp)
	);

	/* PROC¤ΤƤ */
	if((child=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	parent=cputask[get_current_cpu()].current_task;
	child->timer_count=0;
	child->parent=parent;
	child->child=NULL;
	if(cpy_file_struct(parent,child)==-1)
		{kfree(child);return -ENOMEM;}
	enter_spinlock(&page_table_gate);
	{
		child->brother=parent->child;
		parent->child=child;
	}
	exit_spinlock(&page_table_gate);
	child->pagedir_gate=0;

	/* Page tableƤ */
	if((child->pagedir=fork_page(parent,child,&stack))==NULL)
		{kfree(child);return -ENOMEM;}

	/* ҥץstack˥ƥȤꤹ */
	context_frame=(INTR_FRAME*)(((uint)stack&PAGE_ROUNDDOWN)|(((uint)preturn&(PAGE_SIZE-1))-sizeof(INTR_FRAME)+sizeof(uint)));
	context_frame->before_esp=0;
	context_frame->ds=KERNEL_DATA_DES;
	context_frame->es=KERNEL_DATA_DES;
	context_frame->edi=reg.edi;
	context_frame->esi=reg.esi;
	context_frame->ebp=reg.ebp;
	context_frame->ebx=reg.ebx;
	context_frame->edx=0;
	context_frame->ecx=0;
	context_frame->eax=0;				/* Return 0 from sys_fork in child process */
	context_frame->eip=*preturn;
	context_frame->cs=KERNEL_CODE_DES;
	context_frame->eflags=0x202;
	child->esp=(uint)preturn-sizeof(INTR_FRAME)+sizeof(uint);

	/* Add child process to schedule queue */
	add_proc(child);

	return (int)child;
}


/*
 * ץλ
 *
 */
int sys_exit()
{
	return 0;
}


/***********************************************************************/
/*
 * ƥȥץΥ
 */
int sys_exec(char *path,char *argv[],SYSCALL2_FRAME frame)
{
	PROC *proc;


	/* Get current process */
	proc=cputask[get_current_cpu()].current_task;

	/* pathեõإå */

	/* User page table */
	free_user_page(proc);

	/* ץɤ */
	if(test_load(proc)==-1)return -1;

	return 0;
}
/************************************************************************/
