 package jp.ac.musashiasp.action;
 
 import java.io.BufferedReader;
 import java.io.File;
 import java.io.FileInputStream;
 import java.io.FileNotFoundException;
 import java.io.IOException;
 import java.io.InputStreamReader;
 import java.io.FileOutputStream;
 import java.nio.channels.FileChannel;
 import java.nio.channels.FileLock;
 import java.io.Reader;
 import java.text.Format;
 import java.text.SimpleDateFormat;
 import java.util.ArrayList;
 import java.util.Date;
 import java.util.List;
 import java.util.Random;
 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;
 import javax.servlet.http.HttpSession;
 import jp.ac.musashiasp.dto.JobDto;
 import jp.ac.musashiasp.dto.QstatParam;
 import jp.ac.musashiasp.form.WelcomeForm;
 import jp.ac.musashiasp.util.Common;
 import jp.ac.musashiasp.util.DataAccess;
 import jp.ac.musashiasp.dto.UserInfo;
 import org.apache.struts.action.Action;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
 import org.apache.struts.action.ActionMapping;
 import javax.xml.parsers.DocumentBuilder;
 import javax.xml.parsers.DocumentBuilderFactory;
 import javax.xml.transform.Transformer;
 import javax.xml.transform.TransformerFactory;
 import javax.xml.transform.dom.DOMSource;
 import javax.xml.transform.stream.StreamResult;
 import java.io.PrintWriter;
 import java.io.FileNotFoundException;
 import org.w3c.dom.Document;
 import org.w3c.dom.Element;
 import javax.xml.parsers.ParserConfigurationException;
 import javax.xml.transform.TransformerConfigurationException;
 import javax.xml.transform.TransformerException;
 public final class DisplayJobListAction extends Action
 {
   static String err_Msg = "";
   final long TIMEOUT = 3000L;  // timeout = 3sec
   final long WAIT = 100L;
   
   public ActionForward execute(ActionMapping mapping, ActionForm arg1, HttpServletRequest req, HttpServletResponse res)
   {
     HttpSession ses = req.getSession();
     UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
     
     
     if(userinfo == null){
     	 //error
     	return null;
     }
	 PrintWriter out = null;
	 FileOutputStream fs = null;
     try
     {
         //文字コードとMIMEタイプを指定する
         res.setContentType("text/xml; charset=UTF-8");
         //出力ストリームを取得する
         out = res.getWriter();
         
         //DOM Documentのインスタンスを生成するBuilderクラスの
         //インスタンスを取得する
         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
         DocumentBuilder builder = factory.newDocumentBuilder();
         //ビルダーからDOMを取得する
         Document document = builder.newDocument();
         
           synchronized (DataAccess.lock_job) {//20130903 add 排他制御-><-
	         //JOBの情報を取得する。
	         List jobList = DataAccess.getJobFromMaster(userinfo.getRole());
	      	 Element joblist = document.createElement("joblist");
	         document.appendChild(joblist);
	         
		     jobList = chkQstat(jobList,userinfo.getRole());
			 if (!err_Msg.equals(""))
	         {
	         	//XMLのルート要素(errorタグ)を追加する
	         	Element error = document.createElement("error");
	         	joblist.appendChild(error);
	         	//firstnameタグにテキストを追加する
		        error.appendChild(document.createTextNode(err_Msg));
	         }
	          //XMLのルート要素(currenttimeタグ)を追加する
	         Element time = document.createElement("currenttime");
	         joblist.appendChild(time);
	         //lastnameタグのテキストを追加する
	         time.appendChild(document.createTextNode(Common.getCurrentTime()));
	         
	         //JOBLISTをチェック
	         jobList = chkJob(jobList,userinfo.getRole());
	 
	         DataAccess.setJobList(jobList,userinfo.getRole());
 
	         for (int i = 0; i < jobList.size(); i++) {
	   			JobDto job = new JobDto();
	      	    if (((JobDto)jobList.get(i)).getDelete_flg() == 0) {
	      	    	//XMLのルート要素(userタグ)を追加する
	        		Element job_element = document.createElement("job");
	        		joblist.appendChild(job_element);
	        		//ルート要素に子ノード(jobidタグ)を追加する
	         		Element name = document.createElement("jobid");
	         		job_element.appendChild(name);
	        		//jobidタグにテキストを追加する
	         		name.appendChild(document.createTextNode(String.valueOf(((JobDto)jobList.get(i)).getJobid())));
	         		//ルート要素に子ノード(jobnameタグ)を追加する
	        		name = document.createElement("jobname");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	        		name.appendChild(document.createTextNode(((JobDto)jobList.get(i)).getName()));
	         		//ルート要素に子ノード(registtimeタグ)を追加する
	        		name = document.createElement("registtime");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	        		name.appendChild(document.createTextNode(((JobDto)jobList.get(i)).getRegist_time()));
	         		//ルート要素に子ノード(starttimeタグ)を追加する
	        		name = document.createElement("starttime");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	         		if(((JobDto)jobList.get(i)).getStart_time() != "" && ((JobDto)jobList.get(i)).getStart_time() != null){
		        		name.appendChild(document.createTextNode(((JobDto)jobList.get(i)).getStart_time()));
	    			}else{
	    				name.appendChild(document.createTextNode(""));
	    			}
	         		//ルート要素に子ノード(endtimeタグ)を追加する
	        		name = document.createElement("endtime");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	         		if(((JobDto)jobList.get(i)).getEnd_time() != "" && ((JobDto)jobList.get(i)).getEnd_time() != null){
		        		name.appendChild(document.createTextNode(((JobDto)jobList.get(i)).getEnd_time()));
	    			}else{
	    				name.appendChild(document.createTextNode(""));
	    			}
	         		//ルート要素に子ノード(deleteflgタグ)を追加する
	        		name = document.createElement("deleteflg");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	        		name.appendChild(document.createTextNode(String.valueOf(((JobDto)jobList.get(i)).getDelete_flg())));
	        		//ルート要素に子ノード(errflgタグ)を追加する
	        		name = document.createElement("errflg");
	         		job_element.appendChild(name);
	         		//jobnameタグにテキストを追加する
	        		name.appendChild(document.createTextNode(String.valueOf(((JobDto)jobList.get(i)).getErr_flg())));
	        	 }
	   
	   
	         }
	         
	         //DOMの内容をクライアントに出力する
	         TransformerFactory tfactory = TransformerFactory.newInstance();
	         Transformer transformer = tfactory.newTransformer();
	         transformer.transform(new DOMSource(document), new StreamResult(out));
	       }//20130903 add 排他制御-><-
	     }catch (Exception e) {

	     }
     return null;
   }
 
   private List<JobDto> chkJob(List<JobDto> chkList,String groupid)
     throws IOException
   {
     List jobList = new ArrayList();
 
     String path = Common.getTempDir(groupid) + "/";
     File dir = new File(path);
     File[] files = dir.listFiles();
 
     String cmdStr = "";
     String cmdStrsh = "";
     boolean chkFlg = false;
     sleep(1000L);
     for (int i = 0; i < chkList.size(); i++) {
       JobDto job = new JobDto();
       job.setJobid(((JobDto)chkList.get(i)).getJobid());
       job.setUsrId(((JobDto)chkList.get(i)).getUsrId());
       job.setName(((JobDto)chkList.get(i)).getName());
       job.setRegist_time(((JobDto)chkList.get(i)).getRegist_time());
       job.setStart_time(((JobDto)chkList.get(i)).getStart_time());
       job.setErr_flg(((JobDto)chkList.get(i)).getErr_flg());
       if (((JobDto)chkList.get(i)).getEnd_time().equals(""))
       {
         for (int j = 0; j < files.length; j++)
         {
           chkFlg = false;
 
 			//shitamoto change->
 		   if(((JobDto)chkList.get(i)).getStart_time().equals("")){
           	if (files[j].getName().equals(((JobDto)chkList.get(i)).getJobid() + ".sta"))
           	{
            	Date timestamp = new Date(files[j].lastModified());
             	Format fmt = new SimpleDateFormat("yyyy/M/d HH:mm");
             	job.setStart_time(fmt.format(timestamp));
           	}
           }
 
           if (files[j].getName().equals(((JobDto)chkList.get(i)).getJobid() + ".end"))
           {
             Date timestamp = new Date(files[j].lastModified());
             Format fmt = new SimpleDateFormat("yyyy/M/d HH:mm");
             job.setEnd_time(fmt.format(timestamp));
             job.setErr_flg(0);
             chkFlg = true;
           }
 
           if (!chkFlg){
             continue;
           }else{
           	 //shitamoto delete
	         //  cmdStr = cmdStr + " rm " + ((JobDto)chkList.get(i)).getJobid() + ".sta;" + 
	         //    " rm " + ((JobDto)chkList.get(i)).getJobid() + ".end;";
	 
	           cmdStrsh = cmdStrsh + " cd " + Common.getExecuteDir(String.valueOf(((JobDto)chkList.get(i)).getJobid()),groupid) + "/;" + 
	             " rm " + Common.getProperty("jobName") + ((JobDto)chkList.get(i)).getJobid() + ".sh;";
           }
 			//shitamoto change<-
         }
 
       }
       else
       {
         job.setEnd_time(((JobDto)chkList.get(i)).getEnd_time());
         if (((JobDto)chkList.get(i)).getErr_flg() != Integer.valueOf("3").intValue()) {
           job.setErr_flg(0);
         }
      	 //shitamoto add
	     cmdStr = cmdStr + " rm " + ((JobDto)chkList.get(i)).getJobid() + ".sta;" + 
	       " rm " + ((JobDto)chkList.get(i)).getJobid() + ".end;";

       }
       job.setDelete_flg(((JobDto)chkList.get(i)).getDelete_flg());
 
       jobList.add(job);
     }
 
     if (!cmdStr.equals("")) {
       try
       {
         String[] cmds = { "bash", "-c", "cd " + Common.getTempDir(groupid) + "/;" + cmdStr + cmdStrsh };
         Runtime.getRuntime().exec(cmds);
       }
       catch (IOException e) {
         throw e;
       }
     }
 
     return jobList;
   }
 
   private List<JobDto> chkQstat(List<JobDto> jobList,String groupid)
   {
     err_Msg = "";
 
     Random rnd = new Random();
     int ransu = rnd.nextInt(99999);
 
     String fileNm = Common.getTempDir(groupid) + "/" + ransu + ".qst";
     try
     {
       String[] cmd = { "bash", "-c", "qstat > " + fileNm + ";" };
 
       Process qstap = Runtime.getRuntime().exec(cmd);
       qstap.waitFor();
     }
     catch (Exception e) {
       err_Msg = "Qstat結果取得エラー";
       return jobList;
     }
 
     sleep(1000L);
 
     boolean waitFig = true;
     int retryCnt = 0;
 
     List readData = new ArrayList();
 
     while (waitFig) {
       try
       {
         Reader in = new InputStreamReader(new FileInputStream(fileNm), "UTF-8");
 
         BufferedReader br = new BufferedReader(in);
         String line;
         while ((line = br.readLine()) != null)
         {
           //shitamoto String line;
           readData.add(line);
         }
         br.close();
         in.close();
 
         waitFig = false;
 
         if (readData.size() != 0) {
           continue;
         }
         try
         {
           String[] cmd = { "bash", "-c", "rm " + fileNm + ";" };
 
           Process delzp = Runtime.getRuntime().exec(cmd);
           delzp.waitFor();
         }
         catch (Exception e) {
           err_Msg = "Qstat結果削除エラー";
         }
         return jobList;
       }
       catch (FileNotFoundException e) {
         retryCnt++;
         if (retryCnt > 3)
         {
           err_Msg = "ファイルなしエラー";
           return jobList;
         }
 
         sleep(1000L);
       }
       catch (IOException e) {
         waitFig = false;
 
         err_Msg = "ファイル読込エラー";
         return jobList;
       }
 
     }
 
     List qList = new ArrayList();
 
     for (int i = 2; i < readData.size(); i++)
     {
       String[] qstatData = ((String)readData.get(i)).split(" ");
 
       int cnt = 1;
       if (qstatData.length < 5)
       {
         err_Msg = "パラメータ不足エラー";
         return jobList;
       }
 
       QstatParam param = new QstatParam();
       for (int j = 0; j < qstatData.length; j++)
       {
         if (cnt > 5)
         {
           continue;
         }
         if (qstatData[j].trim().length() <= 0)
           continue;
         switch (cnt)
         {
         case 1:
           param.setJobID(qstatData[j]);
           break;
         case 2:
           param.setPrior(qstatData[j]);
           break;
         case 3:
           int len = Common.getProperty("jobName").length();
           String jNm = qstatData[j];
           if (jNm.length() < len)
           {
             err_Msg = "パラメータ不正エラー";
             return jobList;
           }
           jNm = jNm.substring(len);
           param.setJobNm(jNm);
           break;
         case 4:
           param.setUserNm(qstatData[j]);
           break;
         case 5:
           param.setStatus(qstatData[j]);
         }
 
         cnt++;
       }
 
       qList.add(param);
     }
 
     for (int i = 0; i < qList.size(); i++) {
       for (int j = 0; j < jobList.size(); j++) {
         if (!((QstatParam)qList.get(i)).getJobNm().equals(String.valueOf(((JobDto)jobList.get(j)).getJobid())))
         {
           continue;
         }
 
         String chkStatus = ((QstatParam)qList.get(i)).getStatus();
 
         if (chkStatus.indexOf("E") > -1)
         {
           ((JobDto)jobList.get(j)).setErr_flg(Integer.valueOf("3").intValue());
         }
         else if (chkStatus.indexOf("r") > -1)
         {
           ((JobDto)jobList.get(j)).setErr_flg(Integer.valueOf("2").intValue()); } else {
           if (chkStatus.indexOf("w") <= -1)
             continue;
           ((JobDto)jobList.get(j)).setErr_flg(Integer.valueOf("1").intValue());
         }
 
       }
 
     }
 
     try
     {
       String[] cmd = { "bash", "-c", "rm " + fileNm + ";" };
 
       Process delp = Runtime.getRuntime().exec(cmd);
       delp.waitFor();
     }
     catch (Exception e) {
       err_Msg = "Qstat結果削除エラー";
       return jobList;
     }
 
     return jobList;
   }
 
   public synchronized void sleep(long msec)
   {
     try
     {
       wait(msec);
     }
     catch (InterruptedException localInterruptedException)
     {
     }
   }
 }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.WelcomeAction
 * JD-Core Version:    0.6.0
 */