/*    */ package jp.ac.musashiasp.action;
/*    */ 
/*    */ import java.io.FileNotFoundException;
/*    */ import java.io.IOException;
/*    */ import java.util.List;
/*    */ import javax.servlet.http.HttpServletRequest;
/*    */ import javax.servlet.http.HttpServletResponse;
/*    */ import javax.servlet.http.HttpSession;
/*    */ import jp.ac.musashiasp.form.DisplayLogForm;
/*    */ import jp.ac.musashiasp.util.FileAccess;
		 import jp.ac.musashiasp.dto.UserInfo;

/*    */ import org.apache.struts.action.Action;
/*    */ import org.apache.struts.action.ActionForm;
/*    */ import org.apache.struts.action.ActionForward;
/*    */ import org.apache.struts.action.ActionMapping;
/*    */ import org.apache.struts.action.ActionMessage;
/*    */ import org.apache.struts.action.ActionMessages;
/*    */ 
/*    */ public final class DisplayLogAction extends Action
/*    */ {
/*    */   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
/*    */   {
/* 43 */     String logFileName = request.getParameter("logFileName");
/*  54 */    HttpSession ses = request.getSession();
/* 46 */     DisplayLogForm form = (DisplayLogForm)actionForm;

			 UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     if(userinfo == null){
		    	 //error
		    	 ActionMessages messages = new ActionMessages();
		    	 messages.add("org.apache.struts.action.GLOBAL_MESSAGE",  new ActionMessage("ユーザ情報がありません。再度、ログインして処理して下さい。"));
		       	saveErrors(request, messages);
		       	return mapping.findForward("success");
		     }
/*    */     try
/*    */     {
/* 49 */       List logContentsList = FileAccess.readLogFile(logFileName,userinfo.getRole());
/* 50 */       form.setMessageList(logContentsList);
/*    */     }
/*    */     catch (FileNotFoundException e) {
/* 53 */       ActionMessages messages = new ActionMessages();
/* 54 */       messages.add(
/* 55 */         "org.apache.struts.action.GLOBAL_MESSAGE", 
/* 56 */         new ActionMessage("errors.logfile.notfound"));
/* 57 */       saveErrors(request, messages);
/*    */     } catch (IOException e) {
/* 59 */       ActionMessages messages = new ActionMessages();
/* 60 */       messages.add(
/* 61 */         "org.apache.struts.action.GLOBAL_MESSAGE", 
/* 62 */         new ActionMessage("errors.logfile.readerror"));
/* 63 */       saveErrors(request, messages);
/*    */     }
/*    */ 
/* 66 */     return mapping.findForward("success");
/*    */   }
/*    */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.DisplayLogAction
 * JD-Core Version:    0.6.0
 */