 package jp.ac.musashiasp.action;
 import au.com.bytecode.opencsv.CSVReader;
 import java.io.File;
 import java.io.FileNotFoundException;
 import java.io.IOException;

 import java.util.List;
 import java.util.Iterator;
 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;
 import javax.servlet.http.HttpSession;

 import jp.ac.musashiasp.form.EditScriptForm;
 import jp.ac.musashiasp.util.FileAccess;
 import jp.ac.musashiasp.util.DataAccess;
 import jp.ac.musashiasp.util.Common;
 import jp.ac.musashiasp.dto.ScriptDto;
 import jp.ac.musashiasp.dto.UserInfo;
 import org.apache.struts.action.Action;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
 import org.apache.struts.action.ActionMapping;
 import org.apache.struts.action.ActionMessage;
 import org.apache.struts.action.ActionMessages;
 
 public final class EditScriptAction extends Action
 {
   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
   {
     int scriptFileID = Integer.parseInt(request.getParameter("scriptFileId"));
 
     EditScriptForm form = (EditScriptForm)actionForm;
	 form.setMessage("");
	 HttpSession ses = request.getSession();
	 UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
	   
	 if(userinfo == null){
	    //error
		form.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
		return mapping.findForward("success");
	 }
     try
     {
      ScriptDto script = DataAccess.getScriptDataByScriptId(scriptFileID,userinfo.getRole());

      form.setScriptId(script.getScriptId());
      form.setUsrId(script.getUsrId());
      form.setGroupName(script.getGroupName());
      form.setScriptName(script.getScriptName());
      form.setScriptFileName(script.getScriptFileName());
      form.setDelete_flg(script.getDelete_flg());

	  //ユーザ制御
	  //保存ボタン
	  boolean rank2 = Common.isRank("script_edit",userinfo.getRank());
	  if(rank2) ses.setAttribute("edit","true");
	  else  ses.setAttribute("edit","false");
	  //ファイルが書き込み付加の場合は、editさせない。
	  if (!chkWriteFile(Common.getScriptDir(userinfo.getRole()) + "/" + script.getScriptFileName())) {
      	ses.setAttribute("edit","false");
      }
      if (!chkFile(Common.getScriptDir(userinfo.getRole()) + "/" + script.getScriptFileName())) {
		//エラー
		form.setMessage("該当スクリプトファイルがありません。[" + script.getScriptFileName()+"]");
		return mapping.findForward("success");
      }
      if (script.getDelete_flg() == 1){
      	form.setMessage("このスクリプトは削除されています。[" + script.getScriptFileName()+"]");
		return mapping.findForward("success");
      }
 	  StringBuffer scriptData = FileAccess.getScriptData(script.getScriptFileName(),userinfo.getRole());
 	
 	  form.setScriptData(scriptData.toString());
     }
     catch (FileNotFoundException e) {
      form.setMessage(Common.getMessage("errors.jobfile.notfound"));
     } catch (IOException e) {
      form.setMessage(Common.getMessage("errors.jobfile.readerror"));
     }
     return mapping.findForward("success");
	
   }
  private boolean chkFile(String filePath)
  {
    File objFile = new File(filePath);

    return objFile.exists();
  }
  private boolean chkWriteFile(String filePath)
  {
    File objFile = new File(filePath);

    return objFile.canWrite();
  }
 }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.EditScriptAction
 * JD-Core Version:    0.6.0
 */