 package jp.ac.musashiasp.action;
 import au.com.bytecode.opencsv.CSVReader;
 import java.io.File;
 import java.io.FileNotFoundException;
 import java.io.IOException;
 import java.nio.channels.FileChannel;
 import java.nio.channels.FileLock;
 import java.io.FileOutputStream;
 import java.util.List;
 import java.util.Iterator;
 import javax.servlet.http.HttpServletRequest;
 import javax.servlet.http.HttpServletResponse;
 import javax.servlet.http.HttpSession;

 import jp.ac.musashiasp.form.EditScriptForm;
 import jp.ac.musashiasp.util.FileAccess;
 import jp.ac.musashiasp.util.DataAccess;
 import jp.ac.musashiasp.util.Common;
 import jp.ac.musashiasp.dto.UserInfo;
 import jp.ac.musashiasp.dto.ScriptDto;
 import org.apache.struts.action.Action;
 import org.apache.struts.action.ActionForm;
 import org.apache.struts.action.ActionForward;
 import org.apache.struts.action.ActionMapping;
 import org.apache.struts.action.ActionMessage;
 import org.apache.struts.action.ActionMessages;
 
 public final class SaveScriptAction extends Action
 {

   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
   {
     
 
     EditScriptForm form = (EditScriptForm)actionForm;
     int scriptFileID = form.getScriptId();
	 form.setMessage("");
	 String fileName ="";
     HttpSession ses = request.getSession();
     UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
	 if(userinfo == null){
	    //error
		form.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
		return mapping.findForward("success");
	 }
		try
		{
           synchronized (this) {//20130903 add 排他制御-><-
			ScriptDto script = DataAccess.getScriptDataByScriptId(scriptFileID,userinfo.getRole());
			fileName = script.getScriptFileName();
      
      		form.setUsrId(script.getUsrId());
      		form.setGroupName(script.getGroupName());
      		form.setScriptName(script.getScriptName());
      		form.setScriptFileName(script.getScriptFileName());
      		form.setDelete_flg(script.getDelete_flg());

			//ユーザ制御
	  		if(!Common.isRank("script_edit",userinfo.getRank())){
				//エラー
				form.setMessage("このユーザはスクリプト保存できません。");
				return mapping.findForward("success");
	  		}
      		if (!chkFile(Common.getScriptDir(userinfo.getRole()) + "/" + script.getScriptFileName())) {
				//エラー
				form.setMessage("該当スクリプトファイルがありません。[" + script.getScriptFileName()+"]");
				return mapping.findForward("success");
      		}
     		if (script.getDelete_flg() == 1){
      			form.setMessage("このスクリプトは削除されています。[" + script.getScriptFileName()+"]");
				return mapping.findForward("success");
      		}
      		if (!chkWriteFile(Common.getScriptDir(userinfo.getRole()) + "/" + script.getScriptFileName())) {
      			form.setMessage("このスクリプトは書き込みできません。[" + script.getScriptFileName()+"]");
				return mapping.findForward("success");
      		}
      		String scriptdata = form.getScriptData().replaceAll("\r\n","\n");
      		StringBuffer sbuf = new StringBuffer(scriptdata);
 	  		FileAccess.saveScriptData(form.getScriptFileName(),sbuf,userinfo.getRole());
 	       }//20130903 add 排他制御-><-
     	}catch (IOException e) {
      		form.setMessage(Common.getMessage("errors.jobfile.readerror"));
     	}
     
     form.setMessage("[" + fileName + "] ファイルを保存しました。");
     return mapping.findForward("success");
	
   }
  private boolean chkFile(String filePath)
  {
    File objFile = new File(filePath);

    return objFile.exists();
  }
  private boolean chkWriteFile(String filePath)
  {
    File objFile = new File(filePath);

    return objFile.canWrite();
  }
 }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.SaveScriptAction
 * JD-Core Version:    0.6.0
 */