/*     */ package jp.ac.musashiasp.action;
/*     */ 
/*     */ import au.com.bytecode.opencsv.CSVWriter;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.BufferedWriter;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.File;
		  import java.nio.channels.FileChannel;
		  import java.nio.channels.FileLock;
		  import java.io.FileNotFoundException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.servlet.http.HttpSession;
/*     */ import jp.ac.musashiasp.dto.ScriptDto;
/*     */ import jp.ac.musashiasp.form.UploadScriptForm;
/*     */ import jp.ac.musashiasp.util.Common;
/*     */ import jp.ac.musashiasp.util.DataAccess;
/*     */ import jp.ac.musashiasp.dto.UserInfo;
/*     */ import org.apache.struts.action.Action;
/*     */ import org.apache.struts.action.ActionForm;
/*     */ import org.apache.struts.action.ActionForward;
/*     */ import org.apache.struts.action.ActionMapping;
/*     */ import org.apache.struts.upload.FormFile;
/*     */ 
/*     */ public final class UploadScriptAction extends Action
/*     */ {
/*     */   public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
/*     */   {
/*  59 */     UploadScriptForm form = (UploadScriptForm)actionForm;
		      HttpSession ses = request.getSession();
		      UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     
		      if(userinfo == null){
		      	 //error
				form.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
		       	return mapping.findForward("success");
		      }
/*  63 */     String scriptMstPath = Common.getMasterDir(userinfo.getRole()) + "/" + "script.csv";
			  //ユーザ制御
			  //スクリプトのアップロード・削除
			  boolean rank = Common.isRank("script_upload",userinfo.getRank());
			  if(rank) ses.setAttribute("upload","true");
			  else  ses.setAttribute("upload","false");
			  if(!rank){
				//エラー
					form.setMessage("このユーザはスクリプトアップロードできません。");
					return mapping.findForward("success");
			  }
			  //編集ボタン
			  boolean rank2 = Common.isRank("script_edit",userinfo.getRank());
			  if(rank2) ses.setAttribute("edit","true");
			  else  ses.setAttribute("edit","false");

/*  66 */     List list = new ArrayList();
/*     */     try
/*     */     {
/*  70 */       list = DataAccess.getScriptData(userinfo.getRole());
/*     */     } catch (FileNotFoundException e) {
/*  72 */       form.setMessage(Common.getMessage("errors.scriptfile.notfound"));
/*  73 */       return mapping.findForward("success");
/*     */     } catch (IOException e) {
/*  75 */       form.setMessage(Common.getMessage("errors.scriptfile.readerror"));
/*  76 */       return mapping.findForward("success");
/*     */     }
/*     */ 
/*  79 */     if (list.size() == 0)
/*     */     {
/*  81 */       form.setMessage(Common.getMessage("errors.scriptfile.nodata"));
/*     */     }
/*     */ 
/*  84 */     ses.setAttribute("ScriptList", list);
/*     */ 
/*  88 */     FormFile upFile = form.getUpFile();
/*     */ 
/*  90 */     if (upFile != null)
/*     */     {
/*  93 */       if (upFile.getFileName().trim().length() == 0) {
/*  94 */         form.setMessage("登録ファイルを選択してください。");
/*  95 */         return mapping.findForward("success");
/*  96 */       }if (upFile.getFileSize() == 0) {
/*  97 */         form.setMessage("指定したファイルは存在しないか、空のファイルです。 Invalid File : " + upFile.getFileName());
/*  98 */         return mapping.findForward("success");
/*     */       }
/*     */ 
/* 102 */     	String upFilePath = Common.getScriptDir(userinfo.getRole()) + "/" + upFile.getFileName();
/*     */       try
/*     */       {
/* 107 */       	InputStream is = upFile.getInputStream();
/*     */ 
/* 109 */        	InputStreamReader upData = new InputStreamReader(is, "UTF-8");
/*     */ 
/* 111 */        	BufferedReader inBuffer = new BufferedReader(upData);
/*     */ 
/* 113 */         	FileOutputStream fos = new FileOutputStream(upFilePath);
/*     */ 
/* 115 */         	OutputStreamWriter outFile = new OutputStreamWriter(fos, "UTF-8");
/*     */ 
/* 117 */         	BufferedWriter outBuffer = new BufferedWriter(outFile);
/*     */ 
/* 119 */         	int contents = 0;
/*     */ 
/* 122 */         	while ((contents = inBuffer.read()) != -1) {
/* 123 */           	outBuffer.write(contents);
/*     */         	}
/*     */ 
/* 126 */         	outBuffer.flush();
/* 127 */         	inBuffer.close();
/* 128 */         	outBuffer.close();
/*     */ 
/* 131 */         	upFile.destroy();
/*     */ 
/* 133 */         	form.setMessage("データを登録しました。");
/*     */       }
/*     */       catch (Exception e)
/*     */      	{
/* 137 */        	form.setMessage("アップロードエラー : " + e.toString());
/* 138 */         	return mapping.findForward("success");
/*     */       }
/*     */ 
/* 142 */       ScriptDto newScript = new ScriptDto();
/*     */ 
/* 144 */       newScript.setUsrId(userinfo.getUserId());//shitamoto change　ユーザ情報を入れる
/* 145 */       newScript.setScriptId(list.size() + 1);
/* 146 */       newScript.setGroupName(form.getGroupNm());
/* 147 */       newScript.setScriptName(form.getAnalyzeNm());
/* 148 */       newScript.setScriptFileName(upFile.getFileName());
/* 149 */      	newScript.setDelete_flg(0);
/*     */ 
/* 151 */       list.add(newScript);
/*     */       try
/*     */       {
           		  synchronized (DataAccess.lock_script) {//20130903 add 排他制御-><-
/* 156 */        		writeScriptFile(list, scriptMstPath);
				  }
/*     */       }
/*     */       catch (Exception e) {
/* 159 */        	form.setMessage("スクリプトファイル更新エラー : " + e.toString());
/* 160 */       	return mapping.findForward("success");
/*     */       }
/*     */ 	  }
/*     */  
/*     */ 
/* 166 */  	  form.setGroupNm("");
/* 167 */     form.setAnalyzeNm("");
/*     */ 
/* 170 */     return mapping.findForward("success");
/*     */   }
/*     */ 
/*     */   private void writeScriptFile(List<ScriptDto> list, String wFilePath)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*     */     try
/*     */     {
/* 185 */       CSVWriter writer = new CSVWriter(new OutputStreamWriter(new FileOutputStream(wFilePath), "UTF-8"));
/* 186 */       Iterator iter = list.iterator();
/*     */ 
/* 188 */       int scriptId = 1;
/*     */ 
/* 190 */       while (iter.hasNext()) {
/* 191 */         ScriptDto scrData = (ScriptDto)iter.next();
/* 192 */         String[] outData = { 
/* 194 */           Integer.toString(scriptId), 
/* 195 */           scrData.getUsrId(), 
/* 196 */           scrData.getGroupName(), 
/* 197 */           scrData.getScriptName(), 
/* 198 */           scrData.getScriptFileName(), 
/* 199 */           Integer.toString(scrData.getDelete_flg()) };
/* 200 */         writer.writeNext(outData);
/*     */ 
/* 202 */         scriptId++;
/*     */       }
/* 204 */       writer.close();
/*     */     } catch (IOException e) {
/* 206 */       throw e;
/*     */     }
/*     */   }

/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.UploadScriptAction
 * JD-Core Version:    0.6.0
 */