/*     */ package jp.ac.musashiasp.action;
/*     */ 
/*     */ import au.com.bytecode.opencsv.CSVReader;
/*     */ import au.com.bytecode.opencsv.CSVWriter;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
		  import java.nio.channels.FileChannel;
		  import java.nio.channels.FileLock;
		  import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.servlet.http.HttpSession;
/*     */ import jp.ac.musashiasp.dto.JobDto;
/*     */ import jp.ac.musashiasp.form.WelcomeForm;
/*     */ import jp.ac.musashiasp.util.Common;
/*     */ import jp.ac.musashiasp.dto.UserInfo;
/*     */ import jp.ac.musashiasp.util.DataAccess;
/*     */ import org.apache.struts.action.ActionForm;
/*     */ import org.apache.struts.action.ActionForward;
/*     */ import org.apache.struts.action.ActionMapping;
/*     */ import org.apache.struts.actions.LookupDispatchAction;
/*     */ 
/*     */ public final class WelcomeViewAction extends LookupDispatchAction
/*     */ {
/*     */   protected Map getKeyMethodMap()
/*     */   {
/*  28 */     Map map = new HashMap();
/*  29 */     map.put("common.download", "downloadFwd");
/*  30 */     map.put("common.delete.label", "deleteFwd");
/*  31 */     return map;
/*     */   }
/*     */ 
/*     */   public ActionForward deleteFwd(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
/*     */     throws Exception
/*     */   {
/*  42 */     WelcomeForm frm = (WelcomeForm)form;
/*  43 */     String[] delArr = frm.getDelArray();
/*  44 */     List jobList = new ArrayList();
/*  45 */     frm.setMessage("");
		      HttpSession ses = request.getSession();
		      UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     
		      if(userinfo == null){
		      	 //error
				frm.setMessage("ユーザ情報がありません。再度、ログインして処理して下さい。");
				ses.setAttribute("jobList", ses.getAttribute("jobList"));
				frm.setUpdatetime(Common.getCurrentTime());
		       	return mapping.findForward("success");

		      }
/*  49 */     if (delArr == null)
/*     */     {
/*  51 */       frm.setMessage("削除する項目を選択してください。");
/*     */ 
/*  53 */       ses.setAttribute("jobList", ses.getAttribute("jobList"));
/*     */ 
/*  55 */       frm.setUpdatetime(Common.getCurrentTime());
/*     */ 
/*  57 */       return mapping.findForward("success");
/*     */     }
/*     */     	try
/*     */     	{
           		  synchronized (DataAccess.lock_job) {//20130903 add 排他制御-><-
/*  62 */      	 	CSVReader reader = new CSVReader(
/*  63 */         		new InputStreamReader(new FileInputStream(Common.getMasterDir(userinfo.getRole()) + "/" + "job.csv"), "UTF-8"));
/*     */       	String[] nextLine;
/*  65 */       	while ((nextLine = reader.readNext()) != null)
/*     */       	{
/*     */        	 //shitamoto String[] nextLine;
/*  66 */         		if (nextLine[0].length() == 0)
/*     */         		{
/*     */           		break;
/*     */         		}
/*     */ 
/*  71 */       	  	JobDto fromFile = new JobDto();
/*  72 */      	  		fromFile.setJobid(Integer.parseInt(nextLine[0]));
/*  73 */         		fromFile.setUsrId(nextLine[1]);
/*  74 */        		fromFile.setName(nextLine[2]);
/*  75 */         		fromFile.setRegist_time(nextLine[3]);
/*  76 */         		fromFile.setStart_time(nextLine[4]);
/*  77 */         		fromFile.setEnd_time(nextLine[5]);
/*  78 */         		fromFile.setDelete_flg(Integer.parseInt(nextLine[6]));
/*  79 */         		fromFile.setErr_flg(Integer.parseInt(nextLine[7]));
/*     */ 
/*  81 */         		if (delArr != null) {
/*  82 */          		 	for (int i = 0; i < delArr.length; i++) {
/*  83 */             			if (delArr[i].equals(nextLine[0])) {
/*  84 */               			fromFile.setDelete_flg(Integer.parseInt("1"));
/*  85 */               			break;
/*     */             			}
/*     */           		}
/*     */         		}
/*  89 */         		jobList.add(fromFile);
/*     */       	}
/*     */ 
/*  92 */       	reader.close();
/*     */ 
/*  95 */       	CSVWriter writer = new CSVWriter(
/*  96 */         		new OutputStreamWriter(new FileOutputStream(Common.getMasterDir(userinfo.getRole()) + "/" + "job.csv"), "UTF-8"));
/*  97 */       	Iterator iter = jobList.iterator();
/*  98 */       	while (iter.hasNext()) {
/*  99 */       	  	JobDto job = (JobDto)iter.next();
/* 100 */        		String[] outData = { 
/* 101 */        	   		Integer.toString(job.getJobid()), 
/* 102 */           		job.getUsrId(), 
/* 103 */           		job.getName(), 
/* 104 */           		job.getRegist_time(), 
/* 105 */           		job.getStart_time(), 
/* 106 */           		job.getEnd_time(), 
/* 107 */           		Integer.toString(job.getDelete_flg()), 
/* 108 */           		Integer.toString(job.getErr_flg()) };
/* 109 */         		writer.writeNext(outData);
/*     */       	}
/* 111 */       	writer.close();
				  }//20130903 add 排他制御-><-
/*     */     	}catch (Exception e) {
/* 114 */       	e.printStackTrace();
/*     */     	}
/*     */ 
/* 118 */     Iterator iter = jobList.iterator();
/* 119 */     while (iter.hasNext()) {
/* 120 */       JobDto job = (JobDto)iter.next();
/* 121 */       if (job.getDelete_flg() == 1) {
/* 122 */         iter.remove();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 127 */     frm.setMessage(delArr.length + " 件削除しました。");
/*     */ 
/* 130 */     ses.setAttribute("jobList", jobList);
/*     */ 
/* 133 */     frm.setUpdatetime(Common.getCurrentTime());
/*     */ 
/* 135 */     return mapping.findForward("success");
/*     */   }
/*     */ 
/*     */   public ActionForward downloadFwd(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
/*     */     throws Exception
/*     */   {
/* 147 */     WelcomeForm frm = (WelcomeForm)form;
/* 148 */     frm.setMessage("");
		      HttpSession ses = request.getSession();
		      UserInfo userinfo = (UserInfo)ses.getAttribute("userInfo");
		     
		      if(userinfo == null){
		      	 //error
		      }
/*     */     try
/*     */     {
/* 151 */       String strJobID = frm.getDlNo();
/* 152 */       String fName = strJobID + ".csv";
/* 153 */       String filename = Common.getExecuteDir(strJobID,userinfo.getRole()) + "/" + fName;
/*     */ 
/* 155 */       File fileExist = new File(filename);
/* 156 */       if ((!fileExist.exists()) || (!fileExist.isFile()))
/*     */       {
/* 158 */         frm.setMessage("結果ファイルがありません。ログを確認してください。");
/* 159 */         return mapping.findForward("success");
/*     */       }
/*     */ 
/* 162 */       response.setContentType("APPLICATION/OCTET-STREAM");
/* 163 */       OutputStream out = response.getOutputStream();
/*     */ 
/* 165 */       OutputStreamWriter outFile = new OutputStreamWriter(out, "Shift_JIS");
/*     */ 
/* 167 */       String disHeader = "Attachment;Filename=" + fName;
/* 168 */       response.setHeader("Content-Disposition", disHeader);
/*     */ 
/* 170 */       File fileToDownload = new File(filename);
/* 171 */       FileInputStream in = new FileInputStream(fileToDownload);
/*     */ 
/* 173 */       InputStreamReader dlFile = new InputStreamReader(in, "UTF-8");
/*     */       int i;
/* 176 */       while ((i = dlFile.read()) != -1)
/*     */       {
/*     */         //shitamoto int i;
/* 178 */         outFile.write(i);
/*     */       }
/*     */ 
/* 181 */       dlFile.close();
/* 182 */       outFile.close();
/* 183 */       in.close();
/* 184 */       out.close();
				return null;
/*     */     } catch (Exception e) {
/* 186 */       e.printStackTrace();
/*     */ 
/* 188 */       frm.setMessage("結果ファイルのダウンロードに失敗しました。");
				return mapping.findForward("success");
/*     */     }
/*     */ 
/* 191 */     
/*     */   }
/*     */ 
/*     */   public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
/*     */     throws Exception
/*     */   {
/* 204 */     WelcomeForm frm = (WelcomeForm)form;
/* 205 */     frm.setMessage("");
/*     */ 
/* 208 */     frm.setMessage("許可されていないアクセスが行われました。");
/*     */ 
/* 211 */     return mapping.findForward("success");
/*     */   }
/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.action.WelcomeViewAction
 * JD-Core Version:    0.6.0
 */