/*     */ package jp.ac.musashiasp.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.servlet.Filter;
/*     */ import javax.servlet.FilterChain;
/*     */ import javax.servlet.FilterConfig;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.ServletRequest;
/*     */ import javax.servlet.ServletResponse;
/*     */ 
/*     */ public class SetCharacterEncodingFilter
/*     */   implements Filter
/*     */ {
/* 117 */   protected String encoding = null;
/*     */ 
/* 124 */   protected FilterConfig filterConfig = null;
/*     */ 
/* 130 */   protected boolean ignore = true;
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 141 */     this.encoding = null;
/* 142 */     this.filterConfig = null;
/*     */   }
/*     */ 
/*     */   public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
/*     */     throws IOException, ServletException
/*     */   {
/* 163 */     if ((this.ignore) || (request.getCharacterEncoding() == null)) {
/* 164 */       String encoding = selectEncoding(request);
/* 165 */       if (encoding != null) {
/* 166 */         request.setCharacterEncoding(encoding);
/*     */       }
/*     */     }
/*     */ 
/* 170 */     chain.doFilter(request, response);
/*     */   }
/*     */ 
/*     */   public void init(FilterConfig filterConfig)
/*     */     throws ServletException
/*     */   {
/* 182 */     this.filterConfig = filterConfig;
/* 183 */     this.encoding = filterConfig.getInitParameter("encoding");
/* 184 */     String value = filterConfig.getInitParameter("ignore");
/* 185 */     if (value == null)
/* 186 */       this.ignore = true;
/* 187 */     else if (value.equalsIgnoreCase("true"))
/* 188 */       this.ignore = true;
/* 189 */     else if (value.equalsIgnoreCase("yes"))
/* 190 */       this.ignore = true;
/*     */     else
/* 192 */       this.ignore = false;
/*     */   }
/*     */ 
/*     */   protected String selectEncoding(ServletRequest request)
/*     */   {
/* 214 */     return this.encoding;
/*     */   }
/*     */ }

/* Location:           D:\shitamoto\musashi-asp\musashiasp3\WEB-INF\classes\
 * Qualified Name:     jp.ac.musashiasp.util.SetCharacterEncodingFilter
 * JD-Core Version:    0.6.0
 */