/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0   : 新しいAPIに対応(2003/06)                                           */
/* 1.1   : ダブルクオーツのエスケープ(““)に対応&ロジック見直し(2004/03/03)  */
/* 1.2   : NULL項目の出力バグ修正,項目名チェック追加(2004/04/26)              */
/* 1.3   : 項目数が異っていても強制出力オプション(-f)追加(2004/07/30)         */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <csv2xtHelp.h>
struct mssComHelp comHelp={
  "csv2xt",       /* コマンド名       */
  "1.3",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

void errUnmatch(void){
  mssShowErrMsg("unmatched quotation detected in line %d",mssGV.inCnt);
  mssEnd(mssErrorNoDefault);
}

void setCSVfields(char **fldLst, char *string, int *cnt, char spcChr){
  char *str;
  char *pos;
  int  quote;

  (*cnt)=0;
  str=string;
  quote=-1;/*1:クオート内,-1:クオート外(クオートはカンマのエスケープ)*/

  pos=*(fldLst+*cnt);
  while(1){

    /*項目終端チェック*/
    if( (quote==-1 && *str=='\0') || (quote==-1 && *str==',') ){
      *pos='\0';
      (*cnt)++;
      if(*str=='\0') break;
      pos=*(fldLst+*cnt);
      str++;
      continue;
    }

    /*クオート内での行末はエラー*/
    if( (quote==1 && *str=='\0') ) errUnmatch();

    /*開始クオート処理*/
    if( quote==-1 && *str=='"') {
      quote*=(-1);
      str++;
      continue;
    }

    /*クオートのエスケープ(““)処理*/
    if(*str=='"'){
      if(*(str+1)=='"'){
        str+=2;
        *pos++='"';
        continue;
      }
    }

    /*終了クオート処理*/
    if(quote==1 && *str=='"'){
      quote*=(-1);
      str++;
      continue;
    }

    if(*str==MssFieldDelim){
      *pos++=spcChr;
      str++;
      continue;
    }

   /*一文字コピー*/
   *pos++=*str++;
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 一行目を項目名とみなすフラグ                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLG optHFD={
    OFLG,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    HFDT,   /* このオプションのタイトル(Helpで表示)                         */
    HFDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    MssFieldMaxCnt, /* カンマで区切られる要素数の最大値                     */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldNameMaxLen,/* 各要素の文字列長の最大値                          */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  }; 

/*----------------------------------------------------------------------------*/
/* タイトル                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTIT={
    OSTR,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    MssTitleMaxLen,    /* 文字列の最大長                                    */
    TITT,   /* このオプションのタイトル(Helpで表示)                         */
    TITC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* コメント                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCOM={
    OSTR,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    MssCommentMaxLen,/* 文字列の最大長                                      */
    COMT,   /* このオプションのタイトル(Helpで表示)                         */
    COMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* spaceを何に変換するか                                                      */
/*----------------------------------------------------------------------------*/
  MssOptSTR optSPC={ 
    OSTR,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "_",    /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    1,      /* 文字列の最大長                                               */
    SPCT,   /* このオプションのタイトル(Helpで表示)                         */
    SPCC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 項目数が異っていてもヘッダーにあわせて出力                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optFRC={
    OFLG,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    FRCT,   /* このオプションのタイトル(Helpで表示)                         */
    FRCC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* インポートファイル                                                         */
/*----------------------------------------------------------------------------*/
  MssOptINF optIMP={
    OINF,   /* オプションタイプ                                             */
    "I",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    IMPT,   /* このオプションのタイトル(Helpで表示)                         */
    IMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optHFD,&optFNM,&optTIT,&optCOM,&optSPC,&optIMP,&optFRC,
               &optINF,&optOTF,&optZIP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*テキストファイル用<head>タグ格納構造体*/
  struct mssHeader *hdI; /*-I入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPR    *fpr2;/*インポートファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRec *fr;  /*項目-行バッファ構造体*/
  struct mssRec    *rec; /*行バッファ構造体*/

  char         **fldLst;
  int            fldCnt;
  int            i,j;
  int            overFlow;
  int            underFlow;
/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */
  fpr=mssOpenFPR(optINF.str,4);       /* 入力ファイルオープン         */

/*prnOption(opt);*/
/*prnHeader(hdi);*/

  /*-I,-F,-a,いずれも指定されなかったとき*/
  if(!optIMP.set && !optHFD.set && !optFNM.set){
    mssShowErrMsg("choose one option in -a,-F,-I");
    mssEnd(mssErrorNoDefault);
  }

  /*-I,-F,-a,の中で２つ以上指定された*/
  if(optIMP.set+optHFD.set+optFNM.set > 1){
    mssShowErrMsg("choose one option in -a,-F,-I");
    mssEnd(mssErrorNoDefault);
  }
    
  mssGV.txtFlg=1;            /* 強制的にon*/
  hdi=mssReadHeader(fpr);    /* ヘッダの読み込み             */
  mssGV.txtFlg=0;            /* そしてoff*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  fr=mssInitFldRec(hdi->flds->cnt);
  rec=mssInitRec();

  fldLst=mssMalloc(sizeof(char *)*MssFieldMaxCnt,"csv2xt");
  for(i=0; i<MssFieldMaxCnt; i++){
    *(fldLst+i)=mssMalloc(sizeof(char *)*MssFieldMaxLen,"csv2xt");
  }

  if(optIMP.set){ /*-Iフラグon (ヘッダーのインポート)*/
    fpr2=mssOpenFPR(optIMP.str,4);             /*インポートファイルオープン*/
    hdI=mssReadHeader(fpr2);                   /*項目名情報の読み込み*/
    hdo=mssInitCpyHeader(hdI);                 /*出力ヘッダー初期化*/
    mssAddFieldsByFields(hdo->flds,hdI->flds); /*hdIヘッダーの項目情報をコピー*/
    mssCloseFPR(fpr2);                         /*インポートファイルクローズ*/
  }else{
    /*出力ヘッダー初期化*/
    hdo=mssInitHeader(optTIT.str,optCOM.str);

    /*項目情報の設定*/

    /*-Fフラグon*/
    if(optHFD.set){
      if( EOF == mssReadRec(fpr,rec) ){
        mssShowErrMsg("can not read input file");
        mssEnd(mssErrorNoDefault);
      }
      setCSVfields(fldLst,rec->pnt,&fldCnt,*optSPC.str);

      mssAddFieldsByStrList(hdo->flds, fldLst, fldCnt);
    }

    /*-aが指定されたとき*/
    if(optFNM.set){
      mssAddFieldsByStrList(hdo->flds, optFNM.strList, optFNM.cnt);
    }
  }

  /* 項目名のNULLチェック */
  for(i=0; i<hdo->flds->cnt; i++){
    if( *(*(hdo->flds->fi+i))->name == '\0' ){
        mssShowErrMsg("detected NULL field name (%dth field)",i+1);
        mssEnd(mssErrorNoDefault);
    }
  }

  /* 同一項目名のチェック */
  for(i=0; i<hdo->flds->cnt-1; i++){
    for(j=i+1; j<hdo->flds->cnt; j++){
      if(0==strcmp( (*(hdo->flds->fi+i))->name,(*(hdo->flds->fi+j))->name)){
        mssShowErrMsg("detected same field name (%dth and %dth fields)",i+1,j+1);
        mssEnd(mssErrorNoDefault);
      }
    }
  }

  /* 標準出力オープン+ヘッダーの出力 */
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  mssWriteHeader(hdo,fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  while( EOF != mssReadRec(fpr,rec)){
    mssGV.inCnt++;

    setCSVfields(fldLst,rec->pnt,&fldCnt,*optSPC.str);

    overFlow=0;
    underFlow=0;
    if(fldCnt!=hdo->flds->cnt) {
      if(optFRC.set){ /*項目数が異っていてもWARNING出力のみ*/
        mssShowMsg("detected different number of fields in line %d(header has %d, but the record has %d), adjusted",mssGV.inCnt,hdo->flds->cnt,fldCnt);

        if(fldCnt>hdo->flds->cnt) {
          overFlow=1;
          fldCnt=hdo->flds->cnt;
        }else{
          underFlow=hdo->flds->cnt - fldCnt;
        }
      }else{         /*強制終了*/
        mssShowErrMsg("detected different number of fields in line %d(header has %d, but the record has %d)",mssGV.inCnt,hdo->flds->cnt,fldCnt);
        mssEnd(mssErrorNoDefault);
      }
    }

    if(underFlow==0){
      for(i=0; i<fldCnt; i++){
        if(i!=0) mssWriteDlm(fpw);
        if(**(fldLst+i)=='\0'){
          mssWriteStr("*",fpw);
        }else{
          mssWriteStr(*(fldLst+i),fpw);
        }
      }

    }else{ /*ヘッダーより項目数が少ない場合*/
      for(i=0; i<fldCnt; i++){
        if(i!=0) mssWriteDlm(fpw);
        if(**(fldLst+i)=='\0'){
          mssWriteStr("*",fpw);
        }else{
          mssWriteStr(*(fldLst+i),fpw);
        }
      }
      for(i=0; i<underFlow; i++){
        mssWriteDlm(fpw);
        mssWriteStr("*",fpw);
      }
    }

    mssWriteRet(fpw);
    mssGV.outCnt++;
  }

  mssFreeRec(rec);
  mssFreeFldRec(fr);

  for(i=0; i<MssFieldMaxCnt; i++){
    mssFree(*(fldLst+i));
  }
  mssFree(fldLst);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力*/
  mssCloseFPR(fpr);       /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ*/
  mssFreeHeader(hdi);     /*入力ヘッダ領域開放*/
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放*/
  mssFreeOption(opt);     /*オプション領域開放*/
  mssShowEndMsg();        /*完了メッセージ*/
  mssEnd(mssExitSuccess); /*終了*/
  return(0); /* to avoid warning message*/
}
