/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 新規作成 2004/06/08                                                        */
/* mssInitXmlTag(rTag)のメモリリーク解決 2004/10/27                           */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include "mssSVG.h"

double LineUnit=1;
iconv_t *icid;   /*iconv用 変換ハンドラ*/

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * SVG要素関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 *SVG開始タグの出力
 */
void writeSVGstartTag(double pwd, double pht,double wd, double ht, struct mssFPW *fpw){
  struct mssXmlTag *svgTag;
  svgTag=mssInitXmlTag("svg",NULL);

  mssAddXmlTagAttributeDbl(svgTag,"width", pwd, NULL);
  mssAddXmlTagAttributeDbl(svgTag,"height", pht, NULL);
  mssAddXmlTagAttributeFmt(svgTag,"viewBox",NULL,"0 0 %g %g", wd, ht);
  //mssAddXmlTagAttributeStr(svgTag,"preserveAspectRatio","none", NULL);
  mssAddXmlTagAttributeStr(svgTag,"xmlns","http://www.w3.org/2000/svg", NULL);
  mssAddXmlTagAttributeStr(svgTag,"xmlns:xlink","http://www.w3.org/1999/xlink", NULL);
  mssWriteXmlStartTag(svgTag,NULL,fpw);
  mssWriteRet(fpw);

  mssFreeXmlTag(svgTag);
}

/**
 * # FUNCTION #
 *SVG終了タグの出力
 */
void writeSVGendTag(struct mssFPW *fpw){
  mssWriteStr("</svg>\n",fpw);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 座標(x,y,w,h)関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 座標構造体の設定
 */
struct SVGcoord *initSVGcoord(double x, double y, double w, double h){

  struct SVGcoord *c;

  c=mssCalloc(sizeof(struct SVGcoord),"initSVGcoord");
  c->x    = x;
  c->y    = y;
  c->w    = w;
  c->h    = h;

  return(c);
}

/**
 * # FUNCTION #
 * 座標構造体の領域解放
 */
void freeSVGcoord(struct SVGcoord *c){
  mssFree(c);
}

/**
 * # FUNCTION #
 * 座標構造体の表示(for debug)
 */
void showSVGcoord(struct SVGcoord *c){
  printf("SVGcoord x:%g, y:%g, w:%g, h:%g\n",c->x,c->y,c->w,c->h);
  mssFree(c);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 開始終了座標(x1,y1,x2,y2)関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 開始終了座標構造体の設定
 */
struct SVGcoord2 *initSVGcoord2(double x1, double y1, double x2, double y2){

  struct SVGcoord2 *c;

  c=mssCalloc(sizeof(struct SVGcoord2),"initSVGcoord");
  c->x1    = x1;
  c->y1    = y1;
  c->x2    = x2;
  c->y2    = y2;

  return(c);
}

/**
 * # FUNCTION #
 * 開始終了座標構造体の領域解放
 */
void freeSVGcoord2(struct SVGcoord2 *c){
  mssFree(c);
}

/**
 * # FUNCTION #
 * 開始終了座標構造体の表示(for debug)
 */
void showSVGcoord2(struct SVGcoord2 *c){
  printf("SVGcoord x1:%g, y1:%g, x2:%g, y2:%g\n",c->x1,c->y1,c->x2,c->y2);
  mssFree(c);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 矩形領域関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGrect *initSVGrect(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGrect *rect;

  rect=mssCalloc(sizeof(struct SVGrect),"initSVGrect");
  rect->c.x   = x;
  rect->c.y   = y;
  rect->c.w   = w;
  rect->c.h   = h;
  rect->swidth = swidth;
  rect->color  = mssStrdup(color);
  rect->id     = mssStrdup(id);

  return(rect);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGrect(struct SVGrect *rect){
  if(rect!=NULL){
    mssFree(rect->color);
    mssFree(rect->id);
  }
  mssFree(rect);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGrect(struct SVGrect *rect, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*rectタグ*/

  if(rect==NULL) return;

  rTag=mssInitXmlTag("rect",NULL);

  /*rect終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"x", rect->c.x, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", rect->c.y, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", rect->c.w, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", rect->c.h, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", rect->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", rect->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGrect(struct SVGrect *r){
  printf("SVGrect: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 線領域関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 線領域構造体の設定
 */
struct SVGline *initSVGline(
  double x1,
  double y1,
  double x2,
  double y2,
  double swidth,
  char *color,
  char *dash,
  char *id){

  struct SVGline *line;

  line=mssCalloc(sizeof(struct SVGline),"initSVGline");
  line->c2.x1   = x1;
  line->c2.y1   = y1;
  line->c2.x2   = x2;
  line->c2.y2   = y2;
  line->swidth = swidth;
  line->color  = mssStrdup(color);
  line->dash   = mssStrdup(dash);
  line->id     = mssStrdup(id);

  return(line);
}

/**
 * # FUNCTION #
 * 線領域構造体の領域解放
 */
void freeSVGline(struct SVGline *line){
  if(line!=NULL){
    mssFree(line->color);
    mssFree(line->dash);
    mssFree(line->id);
  }
  mssFree(line);
}

/**
 * 線領域構造体のXML出力
 */
void writeSVGline(struct SVGline *line, struct mssFPW *fpw){
  struct mssXmlTag *tag; /*lineタグ*/

  if(line==NULL) return;

  tag=mssInitXmlTag("line",NULL);

  mssAddXmlTagAttributeDbl(tag,"x1", line->c2.x1, NULL);
  mssAddXmlTagAttributeDbl(tag,"y1", line->c2.y1, NULL);
  mssAddXmlTagAttributeDbl(tag,"x2", line->c2.x2, NULL);
  mssAddXmlTagAttributeDbl(tag,"y2", line->c2.y2, NULL);

  mssAddXmlTagAttributeStr(tag,"stroke", line->color, NULL);
  mssAddXmlTagAttributeDbl(tag,"stroke-width", line->swidth, NULL);
  mssAddXmlTagAttributeStr(tag,"stroke-dasharray", line->dash, NULL);
  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(tag);
}

/**
 * 線領域構造体の表示(for debug)
 */
void showSVGline(struct SVGline *l){
  printf("SVGline: id=%s\n  ",l->id);
  showSVGcoord2(&l->c2);
  printf("  dflg=%d, swidth=%g, color=%s dash=%s\n",l->dflg,l->swidth,l->color,l->dash);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 文字列領域関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 文字列領域構造体の設定
 */
struct SVGstring *initSVGstring(
  double x,
  double y,
  double w,
  double h,
  int vflg,
  double swidth,
  char *anchor,
  char *id,
  char *s){

  struct SVGstring *str;

  str=mssCalloc(sizeof(struct SVGstring),"initSVGstring");

  str->c.x    = x;
  str->c.y    = y;
  str->c.w    = w;
  str->c.h    = h;
  str->vflg   = vflg;
  str->swidth = swidth;
  str->anchor = mssStrdup(anchor);
  str->id     = mssStrdup(id);
  str->s      = mssStrdup(s);

  return(str);
}

/**
 * # FUNCTION #
 * 文字列領域構造体の領域解放
 */
void freeSVGstring(struct SVGstring *str){
  if(str!=NULL){
    mssFree(str->anchor);
    mssFree(str->id);
    mssFree(str->s);
  }
  mssFree(str);
}

/**
 * 文字列領域構造体のXML出力
 * <symbol id="xxx">
 *   <symbol id="xxx-str">
 *     <rect x="0" y="0" w="WWW" h="HHH" />
 *     <test x="0" y="HHH*0.8" font-size="HHH*0.8"/>   </text>
 *   </symbol>
 *   <use xlink:href="xxx-str" transform="translate(0,WWW) rotate(270)"/>
 * </symbol>
 * <use x="" y="" xlink:href="xxx">
 */
void writeSVGstring( struct SVGstring *str, struct mssFPW *fpw){

  struct mssXmlTag *s1Tag; /*symbolタグ*/
  struct mssXmlTag *s2Tag; /*symbolタグ*/
  struct mssXmlTag *tTag; /*textタグ*/
  struct mssXmlTag *rTag; /*rectタグ*/
  struct mssXmlTag *u1Tag; /*useタグ*/
  struct mssXmlTag *u2Tag; /*useタグ*/
  char strID[20];

  if(str==NULL) return;

  s1Tag=mssInitXmlTag("symbol",NULL);
  s2Tag=mssInitXmlTag("symbol",NULL);
  tTag=mssInitXmlTag("text",NULL);
  rTag=mssInitXmlTag("rect",NULL);
  u1Tag=mssInitXmlTag("use",NULL);
  u2Tag=mssInitXmlTag("use",NULL);

  /*symbol開始タグの設定&出力*/
  mssAddXmlTagAttributeStr(s1Tag,"id", str->id, NULL);
  mssWriteXmlStartTag(s1Tag,NULL,fpw);
  mssWriteRet(fpw);

  /*symbol開始タグの設定&出力*/
  sprintf(strID,"%s-str",str->id);
  mssAddXmlTagAttributeStr(s2Tag,"id", strID, NULL);
  mssWriteXmlStartTag(s2Tag,NULL,fpw);
  mssWriteRet(fpw);

  /*text開始タグの設定&出力*/
        if(str->anchor==NULL){
    mssAddXmlTagAttributeDbl(tTag,"x"          , str->c.w/2  , NULL);
  }else if(0==strcmp(str->anchor,"middle")){
    mssAddXmlTagAttributeDbl(tTag,"x"          , str->c.w/2  , NULL);
  }else if(0==strcmp(str->anchor,"start" )){
    mssAddXmlTagAttributeDbl(tTag,"x"          , 0           , NULL);
  }else if(0==strcmp(str->anchor,"end"   )){
    mssAddXmlTagAttributeDbl(tTag,"x"          , str->c.w    , NULL);
  }else{
    mssAddXmlTagAttributeDbl(tTag,"x"          , str->c.w/2  , NULL);
  }
  mssAddXmlTagAttributeDbl(tTag,"y"          , str->c.h*0.8, NULL);
  mssAddXmlTagAttributeDbl(tTag,"font-size"  , str->c.h*0.8, NULL);
  mssAddXmlTagAttributeStr(tTag,"text-anchor", str->anchor , NULL);
  mssWriteXmlStartTag(tTag,NULL,fpw);

  /*textの内容の出力(+encoding)*/
  mssWriteXmlContent( str->s, icid, fpw );

  /*text終了タグの出力*/
  mssWriteXmlEndTag(tTag,NULL,fpw);
  mssWriteRet(fpw);

  /*rectタグの出力*/
  if(str->swidth>0){
    mssAddXmlTagAttributeDbl(rTag,"x"           , 0                   , NULL);
    mssAddXmlTagAttributeDbl(rTag,"y"           , 0                   , NULL);
    mssAddXmlTagAttributeDbl(rTag,"width"       , str->c.w            , NULL);
    mssAddXmlTagAttributeDbl(rTag,"height"      , str->c.h            , NULL);
    mssAddXmlTagAttributeStr(rTag,"fill"        , "none"              , NULL);
    mssAddXmlTagAttributeStr(rTag,"stroke"      , "black"             , NULL);
    mssAddXmlTagAttributeDbl(rTag,"stroke-width", str->swidth*LineUnit, NULL);
    mssWriteXmlEmptyTag(rTag,NULL,fpw);
    mssWriteRet(fpw);
  }

  /*symbol終了タグの出力*/
  mssWriteXmlEndTag(s1Tag,NULL,fpw);
  mssWriteRet(fpw);

  /*use開始タグの設定&出力*/
  if(str->vflg){ /*270度回転*/
    mssAddXmlTagAttributeFmt(u1Tag,"xlink:href",NULL,"#%s", strID);
    mssAddXmlTagAttributeFmt(u1Tag,"transform" ,NULL,"translate(0,%g) rotate(270)",str->c.w);
  }else{
    mssAddXmlTagAttributeFmt(u1Tag,"xlink:href",NULL,"#%s", strID);
  }
  mssWriteXmlEmptyTag(u1Tag,NULL,fpw);
  mssWriteRet(fpw);

  /*symbol終了タグの出力*/
  mssWriteXmlEndTag(s2Tag,NULL,fpw);
  mssWriteRet(fpw);

  /*use開始タグの設定&出力*/
  mssAddXmlTagAttributeDbl(u2Tag,"x", str->c.x, NULL);
  mssAddXmlTagAttributeDbl(u2Tag,"y", str->c.y, NULL);
  mssAddXmlTagAttributeFmt(u2Tag,"xlink:href",NULL,"#%s", str->id);
  mssWriteXmlEmptyTag(u2Tag,NULL,fpw);
  mssWriteRet(fpw);

  mssFreeXmlTag(s1Tag);
  mssFreeXmlTag(s2Tag);
  mssFreeXmlTag(tTag);
  mssFreeXmlTag(rTag);
  mssFreeXmlTag(u1Tag);
  mssFreeXmlTag(u2Tag);
}

/**
 * 文字列領域構造体の表示(for debug)
 */
void showSVGstring(struct SVGstring *s){
  printf("SVGstring: id=%s\n str=%s ",s->id,s->s);
  showSVGcoord(&s->c);
  printf("  vflg=%d, swidth=%g, anchor=%s\n",s->vflg,s->swidth,s->anchor);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * symbol要素関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * symbol構造体の設定
 */
struct SVGsymbol *initSVGsymbol(double x,double y, double w, double h, char *id, char *par){
  struct SVGsymbol *sym;

  sym=mssCalloc(sizeof(struct SVGsymbol),"initSVsymbol");
  sym->c.x    = x;
  sym->c.y    = y;
  sym->c.w    = w;
  sym->c.h    = h;
  sym->id     = mssStrdup(id);
  sym->par    = mssStrdup(par);
  return(sym);
}

/**
 * # FUNCTION #
 * symbol構造体の設定
 */
void freeSVGsymbol(struct SVGsymbol *sym){

  if(sym==NULL) return;

  mssFree(sym->id);
  mssFree(sym->par);
  mssFree(sym);
}

/**
 * symbol要素の開始タグの出力
 */
void writeSVGsymbolStartTag(struct SVGsymbol *s, struct mssFPW *fpw){
  struct mssXmlTag *tag; /*symbolタグ*/

  tag=mssInitXmlTag("symbol",NULL);

  /*symbol開始タグの設定&出力*/
  mssAddXmlTagAttributeStr(tag,"id", s->id, NULL);
//  mssAddXmlTagAttributeFmt(tag,"viewBox",NULL,"%g %g %g %g", s->c.x,
//                                                             s->c.y,
//                                                             s->c.w,
//                                                             s->c.h);
//  mssAddXmlTagAttributeStr(tag,"preserveAspectRatio",s->par, NULL);
  mssWriteXmlStartTag(tag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(tag);
}

/**
 * symbol要素の終了タグの出力
 */
void writeSVGsymbolEndTag(struct mssFPW *fpw){
  mssWriteStr("</symbol>\n",fpw);
}

/*
 * # SECTION #
 * ----------------------------------------------------------------------------
 * use要素関連
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * use構造体の設定
 */
struct SVGuse *initSVGuse(
  double x,double y, double w, double h,
  void *add,
  enum SVGelementType et){

  struct SVGuse *use;

  use=mssCalloc(sizeof(struct SVGuse),"initSVuse");
  use->c.x    = x;
  use->c.y    = y;
  use->c.w    = w;
  use->c.h    = h;
  use->add    = add;
  use->et     = et;
  return(use);
}

/**
 * # FUNCTION #
 * use構造体の設定
 */
void freeSVGuse(struct SVGuse *use){

  if(use==NULL) return;

  mssFree(use);
}


/**
 * use要素のタグの出力
 */
void writeSVGuse(struct SVGuse *use, struct mssFPW *fpw){

  struct mssXmlTag *tag;

  if(use==NULL) return;

  tag=mssInitXmlTag("use",NULL);

  mssAddXmlTagAttributeDbl(tag,"x",      use->c.x, NULL);
  mssAddXmlTagAttributeDbl(tag,"y",      use->c.y, NULL);
  mssAddXmlTagAttributeDbl(tag,"width",  use->c.w, NULL);
  mssAddXmlTagAttributeDbl(tag,"height", use->c.h, NULL);
  switch(use->et){
  case SVG_SYMBOL:
    mssAddXmlTagAttributeFmt(tag,"xlink:href",NULL,"#%s",
         ((struct SVGsymbol *)use->add)->id);             break;
  case SVG_RECT:
    mssAddXmlTagAttributeFmt(tag,"xlink:href",NULL,"#%s",
         ((struct SVGrect   *)use->add)->id);             break;
  case SVG_LINE:
    mssAddXmlTagAttributeFmt(tag,"xlink:href",NULL,"#%s",
         ((struct SVGline   *)use->add)->id);             break;
  }

  mssWriteXmlEmptyTag(tag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(tag);
}

/********** 20 Shapes **********/
/***** Shape 0 -- square *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGsq *initSVGsq(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGsq *sq;

  sq=mssCalloc(sizeof(struct SVGsq),"initSVGsq");
  sq->c.x   = x;
  sq->c.y   = y;
  sq->c.w   = w;
  sq->c.h   = h;
  sq->swidth = swidth;
  sq->color  = mssStrdup(color);
  sq->id     = mssStrdup(id);

  return(sq);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGsq(struct SVGsq *sq){
  if(sq!=NULL){
    mssFree(sq->color);
    mssFree(sq->id);
  }
  mssFree(sq);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGsq(struct SVGsq *sq, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*sqタグ*/

  if(sq==NULL) return;

  rTag=mssInitXmlTag("rect",NULL);

  /*rect終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"x", sq->c.x, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", sq->c.y, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", sq->c.w, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", sq->c.h, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", sq->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", sq->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGsq(struct SVGsq *r){
  printf("SVGsq: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 1 -- circle *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGcircle *initSVGcircle(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGcircle *circle;

  circle=mssCalloc(sizeof(struct SVGcircle),"initSVGcircle");
  circle->c.x   = x;
  circle->c.y   = y;
  circle->c.w   = w;
  circle->c.h   = h;
  circle->swidth = swidth;
  circle->color  = mssStrdup(color);
  circle->id     = mssStrdup(id);

  return(circle);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGcircle(struct SVGcircle *circle){
  if(circle!=NULL){
    mssFree(circle->color);
    mssFree(circle->id);
  }
  mssFree(circle);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGcircle(struct SVGcircle *circle, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*circleタグ*/

  if(circle==NULL) return;

  rTag=mssInitXmlTag("circle",NULL);

  /*rect終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", circle->c.x + circle->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", circle->c.y + circle->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r",circle->c.w*0.5,NULL);

  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", circle->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", circle->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGcircle(struct SVGcircle *r){
  printf("SVGcircle: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 2 -- rectangle *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGv_rect *initSVGv_rect(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGv_rect *v_rect;

  v_rect=mssCalloc(sizeof(struct SVGv_rect),"initSVGv_rect");
  v_rect->c.x   = x;
  v_rect->c.y   = y;
  v_rect->c.w   = w;
  v_rect->c.h   = h;
  v_rect->swidth = swidth;
  v_rect->color  = mssStrdup(color);
  v_rect->id     = mssStrdup(id);

  return(v_rect);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGv_rect(struct SVGv_rect *v_rect){
  if(v_rect!=NULL){
    mssFree(v_rect->color);
    mssFree(v_rect->id);
  }
  mssFree(v_rect);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGv_rect(struct SVGv_rect *v_rect, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*v_rectタグ*/

  if(v_rect==NULL) return;

  rTag=mssInitXmlTag("rect",NULL);

  /*rect終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"x", v_rect->c.x + v_rect->c.w*0.2, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", v_rect->c.y - v_rect->c.w*0.1, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", v_rect->c.w*0.6, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", v_rect->c.h*1.2, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", v_rect->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", v_rect->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGv_rect(struct SVGv_rect *r){
  printf("SVGv_rect: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 3 -- funnel *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGfun *initSVGfun(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGfun *fun;

  fun=mssCalloc(sizeof(struct SVGfun),"initSVGfun");
  fun->c.x   = x;
  fun->c.y   = y;
  fun->c.w   = w;
  fun->c.h   = h;
  fun->swidth = swidth;
  fun->color  = mssStrdup(color);
  fun->id     = mssStrdup(id);

  return(fun);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGfun(struct SVGfun *fun){
  if(fun!=NULL){
    mssFree(fun->color);
    mssFree(fun->id);
  }
  mssFree(fun);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGfun(struct SVGfun *fun, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*funタグ*/
  char buf[1024];

  if(fun==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          fun->c.x,
          fun->c.y,

          fun->c.x + fun->c.w*0.5,
          fun->c.y + fun->c.w*0.5,

          fun->c.x,
          fun->c.y + fun->c.w,

          fun->c.x + fun->c.w,
          fun->c.y + fun->c.w,

          fun->c.x + fun->c.w*0.5,
          fun->c.y + fun->c.w*0.5,

          fun->c.x + fun->c.w,  
          fun->c.y);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", fun->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", fun->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGfun(struct SVGfun *r){
  printf("SVGfun: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 4 -- ellipse *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGell *initSVGell(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGell *ell;

  ell=mssCalloc(sizeof(struct SVGell),"initSVGell");
  ell->c.x   = x;
  ell->c.y   = y;
  ell->c.w   = w;
  ell->c.h   = h;
  ell->swidth = swidth;
  ell->color  = mssStrdup(color);
  ell->id     = mssStrdup(id);

  return(ell);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGell(struct SVGell *ell){
  if(ell!=NULL){
    mssFree(ell->color);
    mssFree(ell->id);
  }
  mssFree(ell);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGell(struct SVGell *ell, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*ellタグ*/

  if(ell==NULL) return;

  rTag=mssInitXmlTag("ellipse",NULL);

  /*rect終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", ell->c.x + ell->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", ell->c.y + ell->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"rx", ell->c.w*0.4, NULL);
  mssAddXmlTagAttributeDbl(rTag,"ry", ell->c.h*0.6, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", ell->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", ell->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGell(struct SVGell *r){
  printf("SVGell: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 5 -- i *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGi *initSVGi(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGi *i;

  i=mssCalloc(sizeof(struct SVGi),"initSVGi");
  i->c.x   = x;
  i->c.y   = y;
  i->c.w   = w;
  i->c.h   = h;
  i->swidth = swidth;
  i->color  = mssStrdup(color);
  i->id     = mssStrdup(id);

  return(i);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGi(struct SVGi *i){
  if(i!=NULL){
    mssFree(i->color);
    mssFree(i->id);
  }
  mssFree(i);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGi(struct SVGi *i, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*iタグ*/
  char buf[1024];

  if(i==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          i->c.x,
          i->c.y,

          i->c.x,
          i->c.y + i->c.w*0.25,

          i->c.x + i->c.w*0.4,
          i->c.y + i->c.w*0.25,

          i->c.x + i->c.w*0.4,
          i->c.y + i->c.w*0.75,

          i->c.x,
          i->c.y + i->c.w*0.75,

          i->c.x,
          i->c.y + i->c.w,

          i->c.x + i->c.w,
          i->c.y + i->c.w,

          i->c.x + i->c.w,
          i->c.y + i->c.w*0.75,

          i->c.x + i->c.w*0.6,
          i->c.y + i->c.w*0.75,
 
          i->c.x + i->c.w*0.6,
          i->c.y + i->c.w*0.25,

          i->c.x + i->c.w,
          i->c.y + i->c.w*0.25,

          i->c.x+i->c.w,
          i->c.y);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", i->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", i->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGi(struct SVGi *r){
  printf("SVGi: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 6 -- diamond *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGdia *initSVGdia(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGdia *dia;

  dia=mssCalloc(sizeof(struct SVGdia),"initSVGdia");
  dia->c.x   = x;
  dia->c.y   = y;
  dia->c.w   = w;
  dia->c.h   = h;
  dia->swidth = swidth;
  dia->color  = mssStrdup(color);
  dia->id     = mssStrdup(id);

  return(dia);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGdia(struct SVGdia *dia){
  if(dia!=NULL){
    mssFree(dia->color);
    mssFree(dia->id);
  }
  mssFree(dia);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGdia(struct SVGdia *dia, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*diaタグ*/
  char buf[1024];

  if(dia==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g",
          dia->c.x+dia->c.w,
          dia->c.y+dia->c.w*0.5,
  
          dia->c.x+dia->c.w*0.5,
          dia->c.y,

          dia->c.x,
          dia->c.y+dia->c.w*0.5,

          dia->c.x+dia->c.w*0.5,
          dia->c.y+dia->c.w);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", dia->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", dia->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGdia(struct SVGdia *r){
  printf("SVGdia: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 7 -- triangle *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGtri *initSVGtri(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGtri *tri;

  tri=mssCalloc(sizeof(struct SVGtri),"initSVGtri");
  tri->c.x   = x;
  tri->c.y   = y;
  tri->c.w   = w;
  tri->c.h   = h;
  tri->swidth = swidth;
  tri->color  = mssStrdup(color);
  tri->id     = mssStrdup(id);

  return(tri);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGtri(struct SVGtri *tri){
  if(tri!=NULL){
    mssFree(tri->color);
    mssFree(tri->id);
  }
  mssFree(tri);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGtri(struct SVGtri *tri, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*triタグ*/
  char buf[1024];

  if(tri==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);

  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g",
          tri->c.x + tri->c.w,
          tri->c.y + tri->c.w,

          tri->c.x + tri->c.w*0.5,
          tri->c.y,

          tri->c.x,
          tri->c.y + tri->c.w);
  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", tri->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", tri->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGtri(struct SVGtri *r){
  printf("SVGtri: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 8 -- cross *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGcross *initSVGcross(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGcross *cross;

  cross=mssCalloc(sizeof(struct SVGcross),"initSVGcross");
  cross->c.x   = x;
  cross->c.y   = y;
  cross->c.w   = w;
  cross->c.h   = h;
  cross->swidth = swidth;
  cross->color  = mssStrdup(color);
  cross->id     = mssStrdup(id);

  return(cross);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGcross(struct SVGcross *cross){
  if(cross!=NULL){
    mssFree(cross->color);
    mssFree(cross->id);
  }
  mssFree(cross);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGcross(struct SVGcross *cross, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*triタグ*/

  if(cross==NULL) return;

  rTag=mssInitXmlTag("rect",NULL);


  /*rect終了タグの出力*/
  /* Draw horizontal rectangle */ 
  rTag=mssInitXmlTag("rect",NULL);
  mssAddXmlTagAttributeDbl(rTag,"x", cross->c.x, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", cross->c.y + cross->c.h*0.4, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", cross->c.w, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", cross->c.h*0.2, NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", cross->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", cross->swidth*LineUnit, NULL);  
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  
  /* Draw vertical rectangle */ 
  rTag=mssInitXmlTag("rect",NULL);
  mssAddXmlTagAttributeDbl(rTag,"x", cross->c.x + cross->c.w*0.4, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", cross->c.y, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", cross->c.w*0.2, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", cross->c.h, NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", cross->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", cross->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGcross(struct SVGcross *r){
  printf("SVGcross: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 9 -- hexagon *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGhex *initSVGhex(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGhex *hex;

  hex=mssCalloc(sizeof(struct SVGhex),"initSVGhex");
  hex->c.x   = x;
  hex->c.y   = y;
  hex->c.w   = w;
  hex->c.h   = h;
  hex->swidth = swidth;
  hex->color  = mssStrdup(color);
  hex->id     = mssStrdup(id);

  return(hex);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGhex(struct SVGhex *hex){
  if(hex!=NULL){
    mssFree(hex->color);
    mssFree(hex->id);
  }
  mssFree(hex);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGhex(struct SVGhex *hex, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*hexタグ*/
  char buf[1024];

  if(hex==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          hex->c.x + hex->c.w*1,
          hex->c.y + hex->c.w*0.5,

          hex->c.x + hex->c.w*0.7,
          hex->c.y,

          hex->c.x + hex->c.w*0.3,
          hex->c.y,

          hex->c.x,
          hex->c.y + hex->c.w*0.5,

          hex->c.x + hex->c.w*0.3,
          hex->c.y + hex->c.w*1,

          hex->c.x + hex->c.w*0.7,
          hex->c.y + hex->c.w*1);
  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", hex->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", hex->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGhex(struct SVGhex *r){
  printf("SVGhex: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 10 -- crown *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGcrown *initSVGcrown(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGcrown *crown;

  crown=mssCalloc(sizeof(struct SVGcrown),"initSVGcrown");
  crown->c.x   = x;
  crown->c.y   = y;
  crown->c.w   = w;
  crown->c.h   = h;
  crown->swidth = swidth;
  crown->color  = mssStrdup(color);
  crown->id     = mssStrdup(id);

  return(crown);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGcrown(struct SVGcrown *crown){
  if(crown!=NULL){
    mssFree(crown->color);
    mssFree(crown->id);
  }
  mssFree(crown);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGcrown(struct SVGcrown *crown, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*crownタグ*/
  char buf[1024];

  if(crown==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g",
          crown->c.x + crown->c.w*0.5,
          crown->c.y + crown->c.w*0.5,

          crown->c.x,
          crown->c.y,

          crown->c.x,
          crown->c.y + crown->c.w,

          crown->c.x + crown->c.w,
          crown->c.y + crown->c.w,

          crown->c.x + crown->c.w,
          crown->c.y);
  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", crown->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", crown->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGcrown(struct SVGcrown *r){
  printf("SVGcrown: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 11 -- u *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGu *initSVGu(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGu *u;

  u=mssCalloc(sizeof(struct SVGu),"initSVGu");
  u->c.x   = x;
  u->c.y   = y;
  u->c.w   = w;
  u->c.h   = h;
  u->swidth = swidth;
  u->color  = mssStrdup(color);
  u->id     = mssStrdup(id);

  return(u);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGu(struct SVGu *u){
  if(u!=NULL){
    mssFree(u->color);
    mssFree(u->id);
  }
  mssFree(u);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGu(struct SVGu *u, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*uタグ*/
  char buf[1024];

  if(u==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          u->c.x + u->c.w*0.7,
          u->c.y + u->c.w*0.45,

          u->c.x + u->c.w*0.3,
          u->c.y + u->c.w*0.45,

          u->c.x + u->c.w*0.3,
          u->c.y - u->c.w*0.05,

          u->c.x,
          u->c.y - u->c.w*0.05,

          u->c.x,
          u->c.y + u->c.w*0.95,

          u->c.x + u->c.w,
          u->c.y + u->c.w*0.95,

          u->c.x + u->c.w,
          u->c.y - u->c.w*0.05,

          u->c.x + u->c.w*0.7,  
          u->c.y - u->c.w*0.05);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", u->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", u->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGu(struct SVGu *r){
  printf("SVGu: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 12 -- star *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGstar *initSVGstar(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGstar *star;

  star=mssCalloc(sizeof(struct SVGstar),"initSVGstar");
  star->c.x   = x;
  star->c.y   = y;
  star->c.w   = w;
  star->c.h   = h;
  star->swidth = swidth;
  star->color  = mssStrdup(color);
  star->id     = mssStrdup(id);

  return(star);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGstar(struct SVGstar *star){
  if(star!=NULL){
    mssFree(star->color);
    mssFree(star->id);
  }
  mssFree(star);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGstar(struct SVGstar *star, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*starタグ*/
  char buf[1024];

  if(star==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          star->c.x + star->c.w,
          star->c.y,

          star->c.x + star->c.w*0.5,
          star->c.y + star->c.w*0.3,

          star->c.x,
          star->c.y,

          star->c.x + star->c.w*0.3,
          star->c.y + star->c.w*0.5,

          star->c.x,
          star->c.y + star->c.w,

          star->c.x + star->c.w*0.5,
          star->c.y + star->c.w*0.7,

          star->c.x + star->c.w,
          star->c.y + star->c.w,

          star->c.x + star->c.w*0.7,  
          star->c.y + star->c.w*0.5);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", star->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", star->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGstar(struct SVGstar *r){
  printf("SVGstar: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 13 -- arrow *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGarrow *initSVGarrow(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGarrow *arrow;

  arrow=mssCalloc(sizeof(struct SVGarrow),"initSVGarrow");
  arrow->c.x   = x;
  arrow->c.y   = y;
  arrow->c.w   = w;
  arrow->c.h   = h;
  arrow->swidth = swidth;
  arrow->color  = mssStrdup(color);
  arrow->id     = mssStrdup(id);

  return(arrow);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGarrow(struct SVGarrow *arrow){
  if(arrow!=NULL){
    mssFree(arrow->color);
    mssFree(arrow->id);
  }
  mssFree(arrow);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGarrow(struct SVGarrow *arrow, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*arrowタグ*/
  char buf[1024];

  if(arrow==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          arrow->c.x + arrow->c.w*0.6,
          arrow->c.y + arrow->c.w*0.25,

          arrow->c.x,
          arrow->c.y + arrow->c.w*0.25,

          arrow->c.x,
          arrow->c.y + arrow->c.w*0.75,

          arrow->c.x + arrow->c.w*0.6,
          arrow->c.y + arrow->c.w*0.75,

          arrow->c.x + arrow->c.w*0.6,
          arrow->c.y + arrow->c.w,

          arrow->c.x + arrow->c.w,
          arrow->c.y + arrow->c.w*0.5,

          arrow->c.x + arrow->c.w*0.6,  
          arrow->c.y);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", arrow->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", arrow->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGarrow(struct SVGarrow *r){
  printf("SVGarrow: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 14 -- fugo *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGfugo *initSVGfugo(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGfugo *fugo;

  fugo=mssCalloc(sizeof(struct SVGfugo),"initSVGfugo");
  fugo->c.x   = x;
  fugo->c.y   = y;
  fugo->c.w   = w;
  fugo->c.h   = h;
  fugo->swidth = swidth;
  fugo->color  = mssStrdup(color);
  fugo->id     = mssStrdup(id);

  return(fugo);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGfugo(struct SVGfugo *fugo){
  if(fugo!=NULL){
    mssFree(fugo->color);
    mssFree(fugo->id);
  }
  mssFree(fugo);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGfugo(struct SVGfugo *fugo, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*fugoタグ*/
  char buf[1024];

  if(fugo==NULL) return;

  /* Draw head (circle) */
  rTag=mssInitXmlTag("circle",NULL);

  /*fugo head終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", fugo->c.x + fugo->c.w*0.6, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", fugo->c.y + fugo->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", fugo->c.w*0.4, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", fugo->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", fugo->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw tail (triangle) */
  rTag=mssInitXmlTag("polygon",NULL);

  /*fugo tail終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g",
          fugo->c.x,
          fugo->c.y + fugo->c.w*0.2,

          fugo->c.x + fugo->c.w*0.4,
          fugo->c.y + fugo->c.w*0.5,

          fugo->c.x,
          fugo->c.y + fugo->c.w*0.8);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", fugo->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", fugo->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGfugo(struct SVGfugo *r){
  printf("SVGfugo: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 15 -- tree *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGtree *initSVGtree(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGtree *tree;

  tree=mssCalloc(sizeof(struct SVGtree),"initSVGtree");
  tree->c.x   = x;
  tree->c.y   = y;
  tree->c.w   = w;
  tree->c.h   = h;
  tree->swidth = swidth;
  tree->color  = mssStrdup(color);
  tree->id     = mssStrdup(id);

  return(tree);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGtree(struct SVGtree *tree){
  if(tree!=NULL){
    mssFree(tree->color);
    mssFree(tree->id);
  }
  mssFree(tree);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGtree(struct SVGtree *tree, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*treeタグ*/
  char buf[1024];

  if(tree==NULL) return;

  /* Draw top (circle top) */
  rTag=mssInitXmlTag("circle",NULL);
  
  /*top 終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", tree->c.x + tree->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", tree->c.y + tree->c.w*0.2, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", tree->c.w*0.3, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", tree->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", tree->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw top (circle left) */
  rTag=mssInitXmlTag("circle",NULL);

  /*top 終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", tree->c.x + tree->c.w*0.2, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", tree->c.y + tree->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", tree->c.w*0.25, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", tree->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", tree->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);


  /* Draw top (circle right) */
  rTag=mssInitXmlTag("circle",NULL);

  /*top 終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", tree->c.x + tree->c.w*0.8, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", tree->c.y + tree->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", tree->c.w*0.25, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", tree->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", tree->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw bottom (triangle) */
  rTag=mssInitXmlTag("polygon",NULL);

  /*bottom終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g",
          tree->c.x + tree->c.w*0.3,
          tree->c.y + tree->c.w,

          tree->c.x + tree->c.w*0.7,
          tree->c.y + tree->c.w,

          tree->c.x + tree->c.w*0.5,
          tree->c.y + tree->c.w*0.4);

  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", tree->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", tree->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGtree(struct SVGtree *r){
  printf("SVGtree: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 16 -- house *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGhouse *initSVGhouse(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGhouse *house;

  house=mssCalloc(sizeof(struct SVGhouse),"initSVGhouse");
  house->c.x   = x;
  house->c.y   = y;
  house->c.w   = w;
  house->c.h   = h;
  house->swidth = swidth;
  house->color  = mssStrdup(color);
  house->id     = mssStrdup(id);

  return(house);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGhouse(struct SVGhouse *house){
  if(house!=NULL){
    mssFree(house->color);
    mssFree(house->id);
  }
  mssFree(house);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGhouse(struct SVGhouse *house, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*houseタグ*/
  char buf[1024];

  if(house==NULL) return;

  rTag=mssInitXmlTag("polygon",NULL);


  /*rect終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g, %g %g",
          house->c.x,
          house->c.y + house->c.w*0.5,

          house->c.x,
          house->c.y + house->c.w,

          house->c.x + house->c.w*0.25,
          house->c.y + house->c.w,

          house->c.x + house->c.w*0.25,
          house->c.y + house->c.w*0.75,

          house->c.x + house->c.w*0.75,
          house->c.y + house->c.w*0.75,

          house->c.x + house->c.w*0.75,
          house->c.y + house->c.w,

          house->c.x + house->c.w,  
          house->c.y + house->c.w,

          house->c.x + house->c.w,  
          house->c.y + house->c.w*0.5,
          
          house->c.x + house->c.w*0.5,  
          house->c.y);
  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", house->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", house->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGhouse(struct SVGhouse *r){
  printf("SVGhouse: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 17 -- male *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGmale *initSVGmale(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGmale *male;

  male=mssCalloc(sizeof(struct SVGmale),"initSVGmale");
  male->c.x   = x;
  male->c.y   = y;
  male->c.w   = w;
  male->c.h   = h;
  male->swidth = swidth;
  male->color  = mssStrdup(color);
  male->id     = mssStrdup(id);

  return(male);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGmale(struct SVGmale *male){
  if(male!=NULL){
    mssFree(male->color);
    mssFree(male->id);
  }
  mssFree(male);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGmale(struct SVGmale *male, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*maleタグ*/

  if(male==NULL) return;

  /* Draw head (circle) */
  rTag=mssInitXmlTag("circle",NULL);

  /*male head終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", male->c.x + male->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", male->c.y + male->c.w*0.3, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", male->c.w*0.3, NULL);

  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", male->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", male->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw body (rectangle) */
  rTag=mssInitXmlTag("rect",NULL);

  /*male body終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"x", male->c.x + male->c.w*0.35, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", male->c.y + male->c.w*0.55, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", male->c.w*0.3, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", male->c.h*0.5, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", male->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", male->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGmale(struct SVGmale *r){
  printf("SVGmale: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 18 -- cone *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGcone *initSVGcone(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGcone *cone;

  cone=mssCalloc(sizeof(struct SVGcone),"initSVGcone");
  cone->c.x   = x;
  cone->c.y   = y;
  cone->c.w   = w;
  cone->c.h   = h;
  cone->swidth = swidth;
  cone->color  = mssStrdup(color);
  cone->id     = mssStrdup(id);

  return(cone);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGcone(struct SVGcone *cone){
  if(cone!=NULL){
    mssFree(cone->color);
    mssFree(cone->id);
  }
  mssFree(cone);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGcone(struct SVGcone *cone, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*coneタグ*/
  char buf[1024];

  if(cone==NULL) return;

  /* Draw head (circle) */
  rTag=mssInitXmlTag("circle",NULL);

  /*cone head終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", cone->c.x + cone->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", cone->c.y + cone->c.w*0.35, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", cone->c.w*0.35, NULL);

  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", cone->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", cone->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw body (rectangle) */
  rTag=mssInitXmlTag("polygon",NULL);

  /*female body終了タグの出力*/
  sprintf(buf,"%g %g, %g %g, %g %g",
          cone->c.x + cone->c.w*0.5,
          cone->c.y + cone->c.w,

          cone->c.x + cone->c.w*0,
          cone->c.y + cone->c.w*0.4,

          cone->c.x + cone->c.w,
          cone->c.y + cone->c.w*0.4);
  mssAddXmlTagAttributeStr(rTag,"points", buf,NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", cone->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", cone->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGcone(struct SVGcone *r){
  printf("SVGcone: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

/***** Shape 19 -- watch *****/
/**
 * # FUNCTION #
 * 矩形領域構造体の設定
 */
struct SVGwatch *initSVGwatch(
 double x,
 double y,
 double w,
 double h,
 double swidth,
 char *color,
 char *id){

  struct SVGwatch *watch;

  watch=mssCalloc(sizeof(struct SVGwatch),"initSVGwatch");
  watch->c.x   = x;
  watch->c.y   = y;
  watch->c.w   = w;
  watch->c.h   = h;
  watch->swidth = swidth;
  watch->color  = mssStrdup(color);
  watch->id     = mssStrdup(id);

  return(watch);
}

/**
 * # FUNCTION #
 * 矩形領域構造体の領域解放
 */
void freeSVGwatch(struct SVGwatch *watch){
  if(watch!=NULL){
    mssFree(watch->color);
    mssFree(watch->id);
  }
  mssFree(watch);
}

/**
 * 矩形領域構造体のXML出力
 */
void writeSVGwatch(struct SVGwatch *watch, struct mssFPW *fpw){

  struct mssXmlTag *rTag; /*watchタグ*/

  if(watch==NULL) return;

  /* Draw head (circle) */
  rTag=mssInitXmlTag("circle",NULL);

  /*circle終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"cx", watch->c.x + watch->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"cy", watch->c.y + watch->c.w*0.5, NULL);
  mssAddXmlTagAttributeDbl(rTag,"r", watch->c.w*0.4, NULL);

  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeStr(rTag,"fill", watch->color, NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", watch->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);

  /* Draw body (rectangle) */
  rTag=mssInitXmlTag("rect",NULL);

  /*male body終了タグの出力*/
  mssAddXmlTagAttributeDbl(rTag,"x", watch->c.x, NULL);
  mssAddXmlTagAttributeDbl(rTag,"y", watch->c.y + watch->c.w*0.35, NULL);
  mssAddXmlTagAttributeDbl(rTag,"width", watch->c.w, NULL);
  mssAddXmlTagAttributeDbl(rTag,"height", watch->c.h*0.3, NULL);

  mssAddXmlTagAttributeStr(rTag,"fill", watch->color, NULL);
  mssAddXmlTagAttributeStr(rTag,"stroke", "black", NULL);
  mssAddXmlTagAttributeDbl(rTag,"stroke-width", watch->swidth*LineUnit, NULL);
  mssWriteXmlEmptyTag(rTag,NULL,fpw);
  mssWriteRet(fpw);
  mssFreeXmlTag(rTag);
}

/**
 * 矩形領域構造体の表示(for debug)
 */
void showSVGwatch(struct SVGwatch *r){
  printf("SVGwatch: id=%s\n  ",r->id);
  showSVGcoord(&r->c);
  printf("  dflg=%d, swidth=%g, color=%s\n",r->dflg,r->swidth,r->color);
}

