/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成(2003/08/07)                                                 */
/*============================================================================*/

#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ppm2xtHelp.h>
struct mssComHelp comHelp={
  "ppm2xt",       /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

/*次の改行まで読み込み、その次の文字を返す*/
int skipComment(FILE *fpr){
  int c;

  while(1){
    c=fgetc(fpr);
    if(c==EOF) break;

    if(c=='\n'){
      break;
    }
  }
  return(c); /*to avoid warning message*/
}

/*
 * PPMファイルから、一つの値をbufにセットする。
 * 一つの値とはデリミタ(' ','\t','\n'で区切られた文字列のこと
 */
int readOneValuePPM(char *buf, FILE *fpr ){
  int c;
  int cnt=0;

  while(1){
    c=fgetc(fpr);
    if(c==EOF) break;

    /*コメント処理*/
    if(cnt==0 && c=='#') {
      c=skipComment(fpr);
      if(c==EOF) break;
    }

    /*複数のデリミタはスキップする*/
    if( cnt==0 && (c==' ' || c=='\t' || c=='\n') ){
      if(c=='\n') mssGV.inCnt++;
      continue;
    }

    /*デリミタのチェック*/
    if(c==' ' || c=='\t' || c=='\n'){
      if(c=='\n') mssGV.inCnt++;
      *(buf+cnt)='\0';
      break;
    }

    /*８桁を超えることはないはず*/
    if(cnt>=8){
      mssShowErrMsg("detected the too large number of a pixel element");
      mssEnd(mssErrorNoDefault);
    }

    *(buf+cnt++)=(unsigned char)c;
  }
  return(c);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optINF={
    OSTR,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen, /* 文字列の最大長                                    */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optINF,&optOTF,NULL};

  FILE *fpr;
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  char buf[20];
  char bufr[20];
  char bufg[20];
  char bufb[20];
  int magicNo;
  int xlen,ylen,depth;

  int x,y;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */

  if (optINF.set) {
    fpr=fopen(optINF.str,"r");
    if(fpr==NULL){
      mssShowErrMsg("cannot open file: %s",optINF.str);
      mssEnd(mssErrorNoDefault);
    }
  } else {
    fpr=stdin;
  }

/*prnOption(opt);*/
/*prnHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  hdo=mssInitHeader(NULL,NULL);
  mssAddFieldsByStr( hdo->flds, "X");
  mssAddFieldsByStr( hdo->flds, "Y");
  mssAddFieldsByStr( hdo->flds, "Red");
  mssAddFieldsByStr( hdo->flds, "Green");
  mssAddFieldsByStr( hdo->flds, "Blue");
  mssSetFldInfoSort(*(hdo->flds->fi+1),1,0,1);
  mssSetFldInfoSort(*(hdo->flds->fi+0),2,0,1);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,0,0);
  mssWriteHeader(hdo,fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*----- PPMヘッダー部読み込み*/
  /*マジックナンバー*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  if( strlen(buf)!=2 ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  if( *buf!='P' ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  magicNo=atoi(buf+1);
  if( magicNo!=3 ){
    mssShowErrMsg("this command can handle only an ascii format of PPM");
    mssEnd(mssErrorNoDefault);
  }

  /*X長*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  xlen=atoi(buf);

  /*Y長*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  ylen=atoi(buf);

  /*画素値の最大値*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  depth=atoi(buf);
 
  /*----- データ部読み込み*/
  for(y=0; y<ylen; y++){
    for(x=0; x<xlen; x++){
      /*red*/
      if(EOF == readOneValuePPM(bufr,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }

      /*green*/
      if(EOF == readOneValuePPM(bufg,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }

      /*blue*/
      if(EOF == readOneValuePPM(bufb,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }
      mssWriteInt(x,fpw);
      mssWriteDlm(fpw);
      mssWriteInt(y,fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufr),fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufg),fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufb),fpw);
      mssWriteRet(fpw);
      mssGV.outCnt++;
    }
  }

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力*/
  fclose(fpr);            /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ*/
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放*/
  mssFreeOption(opt);     /*オプション領域開放*/
  mssShowEndMsg();        /*完了メッセージ*/
  mssEnd(mssExitSuccess); /*終了*/
  return(0); /* to avoid warning message*/
}
