/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応(2003/06)                                             */
/* 1.1 : -Sを10文字まで指定可能にする                                         */
/*============================================================================*/
  
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <regex.h>

#include <xml2xtHelp.h>
struct mssComHelp comHelp={
  "xml2xt",       /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */                                    
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvで使う出力用文字列長*/

/*----------------------------------------------------------------------------*/
/* 構造体                                                                     */
/*----------------------------------------------------------------------------*/

/* -f 項目名構造体                                      */
/* ex) -f rec@id:recID                                  */
/*        要素パス@属性名%オプション:新項目名           */
/* data/rec@id%f:recID,/a/b@id%n:keyID                  */
/*   eleNam[0][0]="data",[0][1]="rec",[0][2]=NULL       */
/*   attNam[0]="id"                                     */
/*   optNam[0][0]='f',[0][1]=0                          */
/*   newNam[0]="recID"                                  */
/*                                                      */
/*   eleNam[1][0]="/",[1][1]="a",[1][2]="b",[1][3]=NULL */
/*   attNam[1]="id"                                     */
/*   optNam[1][0]='f',[1][1]=0                          */
/*   newNam[1]="keyID"                                  */

struct XmlFld {
  int   cnt;                       /*項目数         */
  char *element[MssFieldMaxCnt];   /*要素名UTF8     */
  char *attribute[MssFieldMaxCnt]; /*属性名UTF8     */
  char  option[MssFieldMaxCnt];    /*オプション t:テキスト,f:フラグ,n:名前 */
  char *field[MssFieldMaxCnt];     /*新項目名UTF8   */
 };


struct XmlKey {
  char    **path;  /*-kで指定されたカンマで区切られた文字列*/
  regex_t  *regex; /*上の文字列を正規表現にコンパイルしたもの*/
  int       cnt;   /*キー要素の数*/
};

typedef struct _XmlState {
  int level;            /* 現在処理中の要素Nodeのレベル(rootNode=0) */
}XmlState;

/*----------------------------------------------------------------------------*/
/* グローバル変数                                                             */
/*----------------------------------------------------------------------------*/
extern xmlParserCtxtPtr ctxt;
extern struct mssGlobalVariables mssGV;

static struct mssFPW    *fpw; /*出力ファイル構造体*/
static struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
static iconv_t *icid;   /*iconv用 変換ハンドラ*/
static char *inEnc=NULL; /*エンコーディング*/
static char *inVer=NULL; /*バージョン*/
static char currentPath[4096]; /*現在処理中のパス (/a/b/c/)*/
static char *inKeyStartPath=NULL; /*-kで指定したパスからの現在処理中の相対パス*/
static int inKey;/*現在処理中の要素が-kで指定したいずれかのパスに入ってるか*/
static int inFldNo[MssFieldMaxCnt];/*現在処理中の-fの番号*/
static char   fldDat[MssFieldMaxCnt][MssFieldMaxLen];/*-fで指定された各項目の実際の値*/
static struct XmlKey *key;
static struct XmlFld *fld;


/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 一行の単位となるXMLタグのパス名                                            */
/*----------------------------------------------------------------------------*/
  MssOptSTR optKEY={
    OSTR,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,    /* 文字列の最大長                                               */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力する項目のタグ名                                                       */
/*----------------------------------------------------------------------------*/
  MssOptSTR optFLD={
    OSTR,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL  , /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    1024,   /* 文字列の最大長                                               */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* spaceを何に変換するか                                                      */
/*----------------------------------------------------------------------------*/
  MssOptSTR optSPC={
    OSTR,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "_",    /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    10,     /* 文字列の最大長                                               */
    SPCT,   /* このオプションのタイトル(Helpで表示)                         */
    SPCC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optKEY,&optFLD,&optSPC,&optINF,&optOTF,&optZIP,NULL};
    
/*----------------------------------------------------------------------------*/
/* -k のトークン分割+encoding                                                 */
/*----------------------------------------------------------------------------*/
static void setXmlKey(void){
  int i;
  char *pos;
  char *keyPos[MssFieldMaxCnt];

  key=mssCalloc(sizeof(struct XmlKey),"setXmlKey");
  if(optKEY.set){

    /* カンマによるトークン分割 */
    i=0;
    pos = strtok(optKEY.str,",");
    while(pos!=NULL){
      keyPos[i++]=pos;
      pos=strtok(NULL,",");
    }
    key->cnt=i;

    /* encoding してpathにセット */
    key->path=mssCalloc(sizeof(char *),"xml2xt");
    for(i=0; i<key->cnt; i++){
      *(key->path+i)=mssEncoding(keyPos[i],icid);
    }
  }else{
    key->path=NULL;
  }

  key->regex=mssCalloc(sizeof(regex_t)*key->cnt,"xml2xt");
  for(i=0; i<key->cnt; i++){
    if( regcomp(key->regex+i,*(key->path+i),REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }
}

static void freeXmlKey(struct XmlKey *key){
  int i;
  if(key!=NULL){
    for(i=0; i<key->cnt; i++){
      if(*(key->path+i)!=NULL) mssFree(*(key->path+i));
      regfree(key->regex+i);
    }
    mssFree(key->regex);
    mssFree(key->path);
    mssFree(key);
  }
}

/*----------------------------------------------------------------------------*/
/* -f のトークン分割+encoding                                                 */
/* data/rec@id%f:recID,/a/b@id%n:keyID                                        */
/*----------------------------------------------------------------------------*/
static struct XmlFld *setXmlFld(){
  int i,j;
  char *pos;
  struct XmlFld *fld=NULL;
  char *element[MssFieldMaxCnt];    /*encode前の要素名     */
  char *attribute[MssFieldMaxCnt];  /*encode前の属性名     */
  char  option[MssFieldMaxCnt];     /*encode前のオプション */
  char *field[MssFieldMaxCnt];      /*encode前の新項目名   */
  char tmp[4096];

  fld=mssCalloc(sizeof(struct XmlFld),"setXmlFld");

  /*カンマのトークン分割(要素名の先頭アドレスをセット)*/
  /* data/rec@id%f:recID|/a/b@id%n:keyID              */
  fld->cnt=0;
  pos = strtok(optFLD.str,",");
  while(pos!=NULL){
    if(fld->cnt>=MssFieldMaxCnt){
      mssShowErrMsg("too many fields on -f");
      mssEnd(mssErrorNoDefault);

    }
    element[fld->cnt]=pos;
    fld->cnt++;
    pos=strtok(NULL,",");
  }

  /*コロンでトークン分割(新項目名のセット:strdup)*/
  /* data/rec@id%f|recID|/a/b@id%n|keyID  */
  for(i=0; i<fld->cnt; i++){
    pos=strchr(element[i],':');
    if(pos!=NULL){
      *pos='\0';
      field[i]=mssStrdup(++pos);
    }else{
      field[i]=NULL;
    }
  }

  /*%でトークン分割(オプションのセット)  */
  /* data/rec@id|f|recID|/a/b@id|n|keyID  */
  for(i=0; i<fld->cnt; i++){
    j=0;
    pos = strchr(element[i],'%');
    if(pos!=NULL){
      *pos='\0';
      option[i]=*(++pos);
    }else{
      option[i]=0;
    }
  }

  /*この段階で新項目名が指定されていなければ、
    要素名+属性名を新項目名として登録する*/
  for(i=0; i<fld->cnt; i++){
    if(field[i]==NULL){
      field[i]=mssStrdup(element[i]);
    }
  }

  /*@でトークン分割(属性名のセット)*/
  /* data/rec|id|f|recID|/a/b|id|n|keyID  */
  for(i=0; i<fld->cnt; i++){
    pos=strchr(element[i],'@');
    if(pos!=NULL){
      *pos='\0';
      attribute[i]=++pos;
    }else{
      attribute[i]=NULL;
    }
  }

  /*-----------------------------------*/
  /*UTF8へのencoding + 構造体へのセット*/
  /*-----------------------------------*/
  for(i=0; i<fld->cnt; i++){

    /*要素*/
    /* 要素の最後に"/"を加える */
    if(*(element[i]+strlen(element[i])-1)!='/'){
      strcpy(tmp,element[i]);
      strcat(tmp,"/");
    }else{
      strcpy(tmp,element[i]);
    }
    fld->element[i]=mssEncoding(tmp,icid);

    /*属性*/
    fld->attribute[i]=mssEncoding(attribute[i],icid);

    /*パラメータ*/
    fld->option[i]=option[i];

    /*新項目名*/
    fld->field[i]=mssEncoding(field[i],icid);
  }

  for(i=0; i<fld->cnt; i++){
    mssFree(field[i]);
  }

  return(fld);
}

static void freeXmlFld(struct XmlFld *fld){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(fld->element[i]  !=NULL) mssFree(fld->element[i]);
    if(fld->attribute[i]!=NULL) mssFree(fld->attribute[i]);
    if(fld->field[i]    !=NULL) mssFree(fld->field[i]);
  }
  if(fld!=NULL)mssFree(fld);
}

static void writeEncStr(char *str){
  char *buf;

  if( str!=NULL && *str!='\0') {
    buf=mssEncoding(str,icid);
    mssWriteStr(buf,fpw);
    if(buf!=NULL && buf!=str) mssFree(buf);
  }else{
    mssWriteStr("*",fpw);
  }
}

/*デリミタ文字(\t,\n)を指定の文字列に変換する*/
static char *chgSpc(char *str){
  int repStrLen;
  int cnt;
  char *pos;
  char *last;
  char *newStr; /*Delimiter文字を変換して保存する文字列領域*/
  char *retStr; /*返値用の文字列*/

  if(str==NULL) return(NULL);

  newStr=mssMalloc(sizeof(char)*(MssFieldMaxLen+1),"chgSpc");
  *newStr='\0';

  repStrLen=strlen(optSPC.str);

  /*左のDelimiter文字をスキップ*/
  while(*str!='\0'){
    if(*str!=MssFieldDelim && *str!='\n') break;
    str++;
  }

  /*右のDelimiter文字を省く*/
  last=str+strlen(str)-1;
  if(str==last+1) return(newStr);
  while(*last==MssFieldDelim || *last=='\n'){
    *last--='\0';
  }

  cnt=0;
  pos=newStr;
  while(*str!='\0'){
    if(*str==MssFieldDelim || *str=='\n'){
      /*項目最大長を超えたらそこで打ち切り*/
      if(cnt+repStrLen>=MssFieldMaxLen-1){
        break;
      }
      strncpy(pos,optSPC.str,repStrLen);
      pos+=repStrLen;
      str++;
      cnt+=repStrLen;
    }else{
      *pos++=*str++;
      cnt++;
    }
  }
  *pos='\0';

  retStr=mssStrdup(newStr);
  mssFree(newStr);
  return(retStr);
}
 
/*fldDatを出力*/
static void printDat(XmlState *state){
  int fn;
  char *str;

  for(fn=0; fn<fld->cnt-1; fn++){
    str=chgSpc(fldDat[fn]);
    writeEncStr(str);
    mssFree(str);
    mssWriteDlm(fpw);
  }
    str=chgSpc(fldDat[fn]);
    writeEncStr(str);
    mssFree(str);
    mssWriteRet(fpw);
  mssGV.outCnt++;
}

/*fldDatをクリア*/
static void clearFldDat(XmlState *state){
  int i;

  for(i=0; i<fld->cnt; i++){
    /*絶対パス指定(キー要素)の項目はクリアしない*/
    if(*fld->element[i]!='/') fldDat[i][0]='\0';
  }
}

void Strncpy(char *to, char *from, int len){
  int i,j;

  i=0;
  for(j=0; j<len; j++){
    *(to+i)=*(from+j);
    if((++i)>=MssFieldMaxLen-1) {
      mssShowErrMsg("exceed maximum length of field");
      mssEnd(mssErrorNoDefault);
    }
  }
  *(to+i)='\0';
}

void Strncat(char *to, char *from, int len){
  int i,j;

  i=strlen(to);
  for(j=0; j<len; j++){
    *(to+i)=*(from+j);
    if((++i)>=MssFieldMaxLen-1) {
      mssShowErrMsg("exceed maximum length of field");
      mssEnd(mssErrorNoDefault);
    }
  }
  *(to+i)='\0';
}

/*----------------------------------------------------------------------------*/
/* SAX ハンドラー                                                             */
/*----------------------------------------------------------------------------*/
/*############## start_doc */
void start_doc(XmlState *state){
  int i;

  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");

  /*パラメータ用のiconvオープン                                   */
  /*xmlコマンドのパラメータ、入力データ、出力データのencoding     */
  /*は全て、入力データのエンコーディングとおなじことを前提に作る。*/
  icid=iconv_open("UTF-8",inEnc);
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* -k,-f パラメータのセット+漢字をUTF-8に変換 */
  setXmlKey();
  fld=setXmlFld(key);

  /*パラメータ用のiconvクローズ*/
  if(icid!=NULL) iconv_close(icid);

  /*出力のiconvオープン*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /*出力ヘッダーの作成と出力   */
  hdo=mssInitHeader(NULL,NULL);
  for(i=0; i<fld->cnt; i++){
    mssAddFieldsByStr( hdo->flds, mssEncoding(fld->field[i],icid) );
  }

  /*xmlTableヘッダーの書き出し*/
  mssWriteHeader(hdo, fpw);

  /* currentPathの初期化 */
  currentPath[0]='/';
  currentPath[1]='\0';

  for(i=0; i<fld->cnt; i++){
    inFldNo[i]=0;
  }
}

/*############## end_doc */
void end_doc(XmlState *state){
  /*出力用のiconvクローズ*/
  if(icid!=NULL) iconv_close(icid);
}

/*-kのキーに入ったならば1を返す。その他は0。*/
static int isInKey(void){
  int i;
  for(i=0; i<key->cnt; i++){
    /*0でマッチ*/
    if(0==regexec(key->regex+i,currentPath,0,NULL,0)) return(1);
  }
  return(0);
}

/*----------------------------------------------*/
/*-fの要素に入ったならば、その要素の番号を返す。*/
/* inFldNo[]に当てはまる項目番号をセットし、    */
/* inFldCntにその項目数をセットする。           */
/*----------------------------------------------*/
static void setInFld(){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(*fld->element[i]=='/'){ /* ----- 絶対パスの場合 ( -f /a/b ) */
      if(currentPath!=NULL){
        if(0==strcmp(currentPath,fld->element[i])){
          inFldNo[i]=1;
        }
      }
    }else{                     /* ----- 相対パスの場合 ( -f a/b ) */
      if(inKeyStartPath!=NULL){
        if(0==strcmp(inKeyStartPath,fld->element[i])){
          inFldNo[i]=1;
        }
      }
    }
  }
}

static void unsetInFld(){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(*fld->element[i]=='/'){ /* ----- 絶対パスの場合 ( -f /a/b ) */
      if(currentPath!=NULL){
        if(0==strcmp(currentPath,fld->element[i])){
          inFldNo[i]=0;
        }
      }
    }else{                     /* ----- 相対パスの場合 ( -f a/b ) */
      if(inKeyStartPath!=NULL){
        if(0==strcmp(inKeyStartPath,fld->element[i])){
          inFldNo[i]=0;
        }
      }
    }
  }
}

static char *getAttVal(char *attName, char **atts) {
  int i;

  if(atts==NULL || attName==NULL) return(NULL);

  i=0;
  while(1){
    if( *(atts+i)==NULL ) return(NULL);
    if( 0==strcmp(attName,*(atts+i)) ){
      return(*(atts+i+1));
    }
    i=i+2;
  }
}

/*############## start_element */
void start_element(XmlState *state, char *fullname, char **atts){
  char *attVal;
  int prvInKey=inKey;

  int i;

  mssGV.inCnt++;

  /*現在のノードパスを更新*/
  strcat(currentPath,fullname);
  strcat(currentPath,"/");

  /*-kのキーに入ったかどうか*/
  inKey=isInKey();
//printf("curPath=%s(%d)\n",currentPath,inKey);

  /*初めてキーに入った場合 キー内の開始文字位置をセット*/
  if(prvInKey==0 && inKey==1){
    inKeyStartPath=currentPath+strlen(currentPath);
  }

  /*-fで指定したどの要素に入っているか*/
  setInFld();

  for(i=0; i<fld->cnt; i++){
    if(inFldNo[i]){
      /*属性指定項目の場合(<a id="aaa">)*/
      if(fld->attribute[i]!=NULL){
        attVal=getAttVal(fld->attribute[i],atts);
        if( attVal!=NULL ){
          switch(fld->option[i]){
          case 'f': /*フラグ*/
            fldDat[i][0]='1';
            fldDat[i][1]='\0';
            break;
          case 'n': /*名前(要素名+属性名)*/
            Strncpy(fldDat[i],currentPath,strlen(currentPath));
            fldDat[i][strlen(currentPath)-1]='\0'; /*最後の"/"を消す*/
            Strncat(fldDat[i],"@",1);
            Strncat(fldDat[i],fld->attribute[i],strlen(fld->attribute[i]));
            break;
          default: /*テキスト(デフォルト)*/
            Strncpy(fldDat[i],attVal,strlen(attVal));
            break;
          }
        }

      /*要素指定項目の場合(<a>)*/
      }else{
        switch(fld->option[i]){
        case 'f': /*フラグ*/
          fldDat[i][0]='1';
          fldDat[i][1]='\0';
          break;
        case 'n': /*名前(要素名+属性名)*/
          Strncpy(fldDat[i],currentPath,strlen(currentPath));
          fldDat[i][strlen(currentPath)-1]='\0'; /*最後の"/"を消す*/
          break;
        default: /*テキスト(デフォルト)*/
          /*要素内テキスト指定の場合(<a>text</a>)はcharacerにてセットする*/
          /*同じ要素が出て来たときのために、前のデータをクリアする*/
          fldDat[i][0]='\0'; /*最後の"/"を消す*/
          break;
        }
      }
    }
  }
  state->level++;
}

/*############## end_element */
void end_element(XmlState *state, char *fullname, char **atts){
  int prvInKey=inKey;
  char *pos;

  unsetInFld();

  state->level--;

  /*現在のノードパスを更新*/
  pos=currentPath+strlen(currentPath)-2;
  while(*pos!='/') pos--;
  *(++pos)='\0';

  /*今回のend_elementでキーを出たならば*/
  inKey=isInKey();
  if(prvInKey==1 && inKey==0){
    /*キーから出る場合 キー内の開始文字位置をNULLにセット*/
    inKeyStartPath=NULL;
    /*データ出力*/
    printDat(state);
    clearFldDat(state);
  }

  /*-fで指定したどの要素に入っているか*/
  /*end_elementでは、テキスト指定項目の時のみ、調査する*/

}

/*############## start_characters */
void start_characters(XmlState *state, xmlChar *chars, int len){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(inFldNo[i]){
      /*属性でなく、要素の場合*/
      if(fld->attribute[i]==NULL){
        /*%n,%fでない場合*/
        if(fld->option[i]==0){
          /* fldDat[i][0]='\0'; start_elementでクリアに変更*/
          Strncat(fldDat[i],chars,len);
        }
      }
    }
  }
}

/*sax error handler*/
#include "saxerror.h"

void xmlSaxErrEndLocal(void *ctx, const char *msg, ...){
  
  XmlState *dummy=NULL;

  if(0==strncmp(msg,"Document is empty",17)){
    
    ctxt->input->encoding=MssXmlDefEnc;
    start_doc(dummy);
    mssWriteFooter(fpw);
    mssCloseFPW(fpw);
    mssShowEndMsg();
    mssEnd(mssExitSuccess);
  }else{
     xmlSaxErrEnd(ctx, msg);
  }
}


static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEndLocal, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEndLocal, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEndLocal, /* xmlParserError */
    NULL, /* getParameterEntity */
    NULL,
};


int main(int argc, char *argv[]){

  XmlState      *state;

  unsigned char *tmp;
  char *fname;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp); /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                       */
  mssSetOption(opt,argc,argv);    /* コマンドオプションの設定     */

/*prnOption(opt);*/

  tmp=optSPC.str;
  while(*tmp!='\0'){
    if(isspace(*tmp++)) {
      mssShowErrMsg("cannot use space character in -S option");
      mssEnd(mssErrorNoDefault);
    }
  }

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*標準出力オープン*/

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  state=mssCalloc(sizeof(XmlState),"xml2xt");
  state->level = 0;

  if(optINF.set){
    fname=optINF.str;
  }else{
    fname="/dev/stdin";
  }

  ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(fname);
  if(!ctxt){
    fprintf(stderr,"not xml\n");
  }
  ctxt->sax=&SAXFunctions;
  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

  freeXmlKey(key);
  freeXmlFld(fld);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ*/
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放*/
  mssFreeOption(opt);     /*オプション領域開放*/
  mssShowEndMsg();        /*完了メッセージ*/
  mssEnd(mssExitSuccess); /*終了*/
  return(0); /* to avoid warning message*/
}
