/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応                                                      */
/*============================================================================*/
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>

#include <xmlcatHelp.h>
struct mssComHelp comHelp={
  "xmlcat",       /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvで使う出力用文字列長*/

/*----------------------------------------------------------------------------*/
/* グローバル変数                                                             */
/*----------------------------------------------------------------------------*/
extern xmlParserCtxtPtr ctxt;
extern struct mssGlobalVariables mssGV;

static struct mssFPW    *fpw; /*出力ファイル構造体*/
static iconv_t *icid;
static char *inEnc1=NULL; /*一つ目のファイルのエンコーディング*/
static char *inVer1=NULL; /*一つ目のファイルのバージョン*/
static char *inEncN=NULL; /*二つ目以降のファイルのエンコーディング*/
static char *inVerN=NULL; /*二つ目以降のファイルのバージョン*/
static int  procFileNo=-1;/*現在処理中のファイル番号(一つ目のファイルを認識するため)*/
static struct mssXmlTag *rootTag;

/*----------------------------------------------------------------------------*/
/* ルートタグ名                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optRTG={
    OSTR,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL  , /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,    /* 文字列の最大長                                               */
    RTGT,   /* このオプションのタイトル(Helpで表示)                         */
    RTGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    256,    /* 指定可能の最大ファイル数                                     */
    1,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optRTG,&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* 構造体                                                                     */
/*----------------------------------------------------------------------------*/
/* -f 項目名構造体 */
/* ex) -f rec@id:recID */
struct XmlFld {
  int   cnt;               /*項目数         */
  char *eleNamOrg[MssFieldMaxCnt]; /*要素名 (rec)   */
  char *attNamOrg[MssFieldMaxCnt]; /*属性名 (id)    */
  char *newNamOrg[MssFieldMaxCnt]; /*新項目名(recID)*/
  char *eleNam[MssFieldMaxCnt];    /*要素名UTF8     */
  char *attNam[MssFieldMaxCnt];    /*属性名UTF8     */
  char *newNam[MssFieldMaxCnt];    /*新項目名UTF8   */
  int   keyNum[MssFieldMaxCnt];    /*-kでも指定されていれば、その番号*/
};

struct XmlKey {
  char *namOrg[MssFieldMaxCnt];
  char *nam[MssFieldMaxCnt];
  int   on[MssFieldMaxCnt];
  int   allKeyIsOn;
  int   cnt;
};

typedef struct _XmlState {
  int level;
  int crFlg;
} XmlState;

/*----------------------------------------------------------------------------*/
/* SAX ハンドラー                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  procFileNo++; /*処理中のファイル番号をUP*/

  /*一つ目のファイルのXML宣言を獲得し出力*/
  if(procFileNo==0){
    inEnc1=mssStrdup((char *)ctxt->input->encoding);
    inVer1=mssStrdup((char *)ctxt->version);
    mssWriteXmlDeclaration( inVer1, inEnc1, fpw );
    if(inEnc1==NULL) inEnc1=mssStrdup("UTF-8");

    /*出力のiconvオープン*/
    icid=iconv_open(inEnc1,"UTF-8");
    if((int)icid==-1){
      mssShowErrMsg("encoding type error in iconv_open");
      mssEnd(mssErrorNoDefault);
    }

  /*二つ目以降のファイルのXML宣言を獲得し一つ目と比較*/
  }else{
    mssFree(inEncN);
    mssFree(inVerN);
    inEncN=mssStrdup((char *)ctxt->input->encoding);
    inVerN=mssStrdup((char *)ctxt->version);
    if(inEncN==NULL) inEncN=mssStrdup("UTF-8");
    if( 0!=strcmp(inVer1,inVerN) ){
      mssShowErrMsg("different xml version on %s",ctxt->input->filename);
      mssEnd(mssErrorNoDefault);
    }
    if( 0!=strcmp(inEnc1,inEncN) ){
      mssShowErrMsg("different xml encoding on %s",ctxt->input->filename);
      mssEnd(mssErrorNoDefault);
    }
    /*出力のiconvオープン*/
    icid=iconv_open(inEncN,"UTF-8");
    if((int)icid==-1){
      mssShowErrMsg("encoding type error in iconv_open");
      mssEnd(mssErrorNoDefault);
    }
  }
}

void end_doc(XmlState *state){
  if(icid!=NULL) iconv_close(icid);
}

/*エレメント start */
void start_element(XmlState *state, char *fullname, char **atts){

  struct mssXmlTag *xmlTag;
  int i;

  mssGV.inCnt++;

  if(state->level==0){
    if(!optRTG.set){
      if(!procFileNo==0){
        if(0!=strcmp(rootTag->element,fullname)){
          mssShowErrMsg("different root tag [%s] in %s",
                                              fullname,ctxt->input->filename );
          mssEnd(mssErrorNoDefault);
        }
        state->level++;
        return;
      }else{
        rootTag=mssInitXmlTag(fullname,NULL);
      }

    /*ルートタグが指定されている*/
    }else{
      if(procFileNo==0){
        mssWriteXmlStartTag(rootTag,icid,fpw);
        mssGV.outCnt++;
        state->crFlg=1;
        state->level++;
      }
    }
  }

  if(state->crFlg){
    mssWriteRet(fpw);
    state->crFlg=0;
  }
  mssWriteXmlIndent(state->level,fpw);

  xmlTag=mssInitXmlTag(fullname,NULL);
  if(atts!=NULL){
    for(i=0;;i++){
      if(*(atts+2*i+0)==NULL) break;
      if(*(atts+2*i+1)==NULL) break;
      mssAddXmlTagAttributeStr(xmlTag,*(atts+2*i),*(atts+2*i+1),NULL);
    }
  }
  mssWriteXmlStartTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  mssGV.outCnt++;
  state->level++;
}

/*エレメント end */
void end_element(XmlState *state, char *fullname, char **atts){

  struct mssXmlTag *xmlTag;

  state->level--;

  /* ルートタグ & add型 & 最後のファイルでない */
  if(state->level==0){
    if(!optRTG.set){
      if(procFileNo!=optINF.cnt-1){
        return;
      }
    }
  }

  if(state->crFlg){
    mssWriteRet(fpw);
    mssWriteXmlIndent(state->level,fpw);
    state->crFlg=0;
  }
  xmlTag=mssInitXmlTag(fullname,NULL);
  mssWriteXmlEndTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  if(optRTG.set){
    if(state->level==1){
      mssWriteRet(fpw);
      if(procFileNo==optINF.cnt-1){
        mssWriteXmlEndTag(rootTag,icid,fpw);
        mssWriteRet(fpw);
        state->level--;
      }
    }
  }else{
    if(state->level==0){
      mssWriteRet(fpw);
    }
  }
}

void start_characters(XmlState *state, xmlChar *chars, int len){
  char *tmp;

  switch(*chars){
  case '\n':
    state->crFlg=1; break;
  case '&':
    mssWriteStr("&amp;",fpw); break;
  case '>':
    mssWriteStr("&gt;",fpw); break;
  case '<':
    mssWriteStr("&lt;",fpw); break;
  case '\'':
    mssWriteStr("&apos;",fpw); break;
  case '"':
    mssWriteStr("&quot;",fpw); break;
  default:
    tmp=mssNencoding(chars,len,icid);
    mssWriteStr(tmp,fpw);
    mssFree(tmp);
  }
}

void start_cdata(XmlState *state, xmlChar *chars, int len){
  char *tmp;

  mssWriteStr("<![CDATA[",fpw);
  tmp=mssNencoding(chars,len,icid);
  mssWriteStr(tmp,fpw);
  mssFree(tmp);
  mssWriteStr("]]>",fpw);
}

static xmlEntityPtr get_entity( XmlState *ctx, xmlChar *name){
  return xmlGetPredefinedEntity(name);
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    (getEntitySAXFunc) get_entity, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
    (cdataBlockSAXFunc)start_cdata,
};

int main(int argc, char *argv[]){

  XmlState         *state;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */

  /*引数のタグ名、属性名をUTF-8に変換して格納*/
  if(optRTG.set){
    icid=iconv_open("UTF-8",MssXmlDefEnc);
    if((int)icid==-1) {
      mssShowErrMsg("encoding type error in -E");
      mssEnd(mssErrorNoDefault);
    }

    rootTag=mssOpt2XmlTag(optRTG.str,icid);
    //rootTag=mssOpt2XmlTag(optRTG.str,NULL);

    if(icid!=NULL) iconv_close(icid);
  }

  /*標準出力オープン*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
//mssWriteXmlStartTag(rootTag,NULL,fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  state=mssCalloc(sizeof(XmlState),"xml2xt");
  for(i=0; i<optINF.cnt; i++){

    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(*(optINF.strList+i));
    if(!ctxt){
      mssShowErrMsg("not xml file");
      mssEnd(mssErrorNoDefault);
    }
    ctxt->sax=&SAXFunctions;

    ctxt->userData=state;
    xmlParseDocument(ctxt);
    ctxt->sax=NULL;
    xmlFreeParserCtxt(ctxt);
  }

  mssFree(inEnc1);
  mssFree(inVer1);
  mssFree(inEncN);
  mssFree(inVerN);
  mssFree(state);
  mssFreeXmlTag(rootTag);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ   */
  mssFreeOption(opt);     /*オプション領域開放       */
  mssShowEndMsg();        /*完了メッセージ           */
  mssEnd(mssExitSuccess); /*終了                     */
  return(0);              /* to avoid warning message*/
}
