
/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応                                                      */
/*============================================================================*/
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>

#include <xmlheadHelp.h>
struct mssComHelp comHelp={
  "xmlhead",    /* コマンド名       */
  "1.0",        /* バージョン       */
  HELPT,        /* コマンドタイトル */
  HELPS,        /* 要約             */
  HELPE,        /* 利用例           */
  HELPR,        /* 参照コマンド     */
  HELPA,        /* 作者情報         */
  HELPB,        /* バグレポート情報 */
  HELPH         /* ホームページ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvで使う出力用文字列長*/

/*----------------------------------------------------------------------------*/
/* グローバル変数                                                             */
/*----------------------------------------------------------------------------*/
extern struct mssGlobalVariables mssGV;
extern xmlParserCtxtPtr ctxt;

static struct mssFPW    *fpw; /*出力ファイル構造体*/
static iconv_t *icid;   /*iconv用 変換ハンドラ*/
static char *inEnc=NULL; /*一つ目のファイルのエンコーディング*/
static char *inVer=NULL; /*一つ目のファイルのバージョン*/
static char  currentPath[4096]; /*現在処理中のパス (/a/b/c/)*/

/*----------------------------------------------------------------------------*/
/* 整数型                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optLIN={
    OINT,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    10,     /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    LINT,   /* このオプションのタイトル(Helpで表示)                         */
    LINC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    256,    /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optLIN,&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* 構造体                                                                     */
/*----------------------------------------------------------------------------*/

/* -f 項目名構造体 */
/* ex) -f rec@id:recID */
struct XmlFld {
  int   cnt;               /*項目数         */
  char *eleNamOrg[MssFieldMaxCnt]; /*要素名 (rec)   */
  char *attNamOrg[MssFieldMaxCnt]; /*属性名 (id)    */
  char *newNamOrg[MssFieldMaxCnt]; /*新項目名(recID)*/
  char *eleNam[MssFieldMaxCnt];    /*要素名UTF8     */
  char *attNam[MssFieldMaxCnt];    /*属性名UTF8     */
  char *newNam[MssFieldMaxCnt];    /*新項目名UTF8   */
  int   keyNum[MssFieldMaxCnt];    /*-kでも指定されていれば、その番号*/
};

struct XmlKey {
  char *namOrg[MssFieldMaxCnt];
  char *nam[MssFieldMaxCnt];
  int   on[MssFieldMaxCnt];
  int   allKeyIsOn;
  int   cnt;
};

typedef struct _XmlState {
  int level;
  int crFlg;
  int tagCnt; /*スタートタグの出現回数(この数値を元にセレクトする)*/
} XmlState;

void endOfProgram(XmlState *state){

  mssFree(inEnc);
  mssFree(inVer);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);     /*出力ファイルのクローズ*/
  mssFreeOption(opt);      /*オプション領域開放*/
  mssShowEndMsg();        /*完了メッセージ           */
  mssEnd(mssExitSuccess); /*終了                     */
}

/*----------------------------------------------------------------------------*/
/* SAX ハンドラー                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  /*XML宣言を獲得し出力*/
  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  mssWriteXmlDeclaration( inVer, inEnc, fpw );
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");

  /*出力のiconvオープン*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* currentPathの初期化 */
  currentPath[0]='/';
  currentPath[1]='\0';

}

void end_doc(XmlState *state){
  if(icid!=NULL) iconv_close(icid);
}

/*エレメント start */
void start_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;
  char *pos;
  int i;

  /*タグの出現件数がoptLINを超えたら終了*/
  state->tagCnt++;
  if(state->tagCnt>optLIN.val){
    mssWriteRet(fpw);
    pos=currentPath+strlen(currentPath)-1;
    while(pos>currentPath){
      state->level--;
      *pos='\0';
      while(*pos!='/') pos--;
      mssWriteXmlIndent(state->level,fpw);
      xmlTag=mssInitXmlTag(pos+1,NULL);
      mssWriteXmlEndTag(xmlTag,icid,fpw);
      mssFreeXmlTag(xmlTag);
      mssWriteRet(fpw);
    }
    endOfProgram(state);
  }

  mssGV.inCnt++;

  /*現在のノードパスを更新*/
  strcat(currentPath,fullname);
  strcat(currentPath,"/");

  if(state->crFlg){
    mssWriteRet(fpw);
    state->crFlg=0;
  }
  mssWriteXmlIndent(state->level,fpw);
  xmlTag=mssInitXmlTag(fullname,NULL);
  if(atts!=NULL){
    for(i=0;;i++){
      if(*(atts+2*i+0)==NULL) break;
      if(*(atts+2*i+1)==NULL) break;
      mssAddXmlTagAttributeStr(xmlTag,*(atts+2*i),*(atts+2*i+1),NULL);
    }
  }
  mssWriteXmlStartTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);
  mssGV.outCnt++;
  state->level++;
}

/*エレメント end */
void end_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;
  char *pos;

  state->level--;
  if(state->crFlg){
    mssWriteRet(fpw);
    mssWriteXmlIndent(state->level,fpw);
    state->crFlg=0;
  }
  xmlTag=mssInitXmlTag(fullname,NULL);
  mssWriteXmlEndTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  /*現在のノードパスを更新*/
  pos=currentPath+strlen(currentPath)-2;
  while(*pos!='/') pos--;
  *(++pos)='\0';

}

void start_characters(XmlState *state, xmlChar *chars, int len){
  char *tmp;
  switch(*chars){
  case '\n':
    state->crFlg=1; break;
  case '&':
    mssWriteStr("&amp;",fpw); break;
  case '>':
    mssWriteStr("&gt;",fpw); break;
  case '<':
    mssWriteStr("&lt;",fpw); break;
  case '\'':
    mssWriteStr("&apos;",fpw); break;
  case '"':
    mssWriteStr("&quot;",fpw); break;
  default:
    tmp=mssNencoding(chars,len,icid);
    mssWriteStr(tmp,fpw);
    mssFree(tmp);
  }
}

void start_cdata(XmlState *state, xmlChar *chars, int len){
  char *tmp;
  mssWriteStr("<![CDATA[",fpw);
  tmp=mssNencoding(chars,len,icid);
  mssWriteStr(tmp,fpw);
  mssFree(tmp);
  mssWriteStr("]]>",fpw);
}

static xmlEntityPtr get_entity( XmlState *ctx, xmlChar *name){
  return xmlGetPredefinedEntity(name);
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    (getEntitySAXFunc) get_entity, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
    (cdataBlockSAXFunc)start_cdata,
};

int main(int argc, char *argv[]){

  XmlState         *state;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*標準出力オープン*/

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  state=mssCalloc(sizeof(XmlState),"xml2xt");

  ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(*(optINF.strList+0));
  if(!ctxt){
    mssShowErrMsg("not xml file\n");
    mssEnd(mssErrorNoDefault);
  }
  ctxt->sax=&SAXFunctions;

  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

/*----------------------------------------------------------------------------*/
/*終了処理                                                                    */
/*----------------------------------------------------------------------------*/
  endOfProgram(state);
  return(0);              /* to avoid warning message*/
}
