/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成(2003/12/02)                                                 */
/* 1.1 : category属性の値リストのカンマに関するバグ修正(2003/12/03)           */
/* 1.2 : category属性を最後に出力するように変更(2004/02/05)                   */
/* 1.3 : -i パラメータがオプションになっていたバグ修正(2004/04/19)            */
/* 1.4 : 文字列型、日付型に対応(2004/07/31)                                   */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2arffHelp.h>
struct mssComHelp comHelp={
  "xt2arff",      /* コマンド名       */
  "1.4",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */                                      
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};
    
extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 数値項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNUM={
    OFLD,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    NUMT,   /* このオプションのタイトル(Helpで表示)                         */
    NUMC,   /* このオプションのコメント(Helpで表示)                         */
    NUMF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* カテゴリ項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCAT={
    OFLD,   /* オプションタイプ                                             */
    "d",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    CATT,   /* このオプションのタイトル(Helpで表示)                         */
    CATC,   /* このオプションのコメント(Helpで表示)                         */
    CATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 文字列項目                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optSTR={
    OFLD,   /* オプションタイプ                                             */
    "s",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    STRT,   /* このオプションのタイトル(Helpで表示)                         */
    STRC,   /* このオプションのコメント(Helpで表示)                         */
    STRF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };


/*----------------------------------------------------------------------------*/
/* 日付項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optDAT={
    OFLD,   /* オプションタイプ                                             */
    "D",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "t",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    DATT,   /* このオプションのタイトル(Helpで表示)                         */
    DATC,   /* このオプションのコメント(Helpで表示)                         */
    DATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optNUM,&optCAT,&optSTR,&optDAT,&optINF,&optOTF,&optZIP,NULL};
    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRec *fr;  /*項目-行バッファ構造体*/

  struct mssHash **hash=NULL;  /* カテゴリ属性の値を格納するhash */
  struct mssHashNode *hn; /* 上記hashのノードを示す一時変数 */
  MssValue v; /* hash登録用ダミー */
  int fldNo;
  int firstFlg;
  char *str;
  int i,j;
  int *withTime=NULL;
  int len;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */
  fpr=mssOpenFPR(optINF.str,4);       /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);             /* ヘッダの読み込み             */
  mssSetOptFld(&optNUM, hdi);        /* -n 項目をヘッダー項目に関連づける */
  mssSetOptFld(&optCAT, hdi);        /* -d 項目をヘッダー項目に関連づける */
  mssSetOptFld(&optSTR, hdi);        /* -s 項目をヘッダー項目に関連づける */
  mssSetOptFld(&optDAT, hdi);        /* -D 項目をヘッダー項目に関連づける */

  /*属性が少なくとも一つは指定されているか*/
  if(!optCAT.set && !optNUM.set && !optSTR.set && !optDAT.set){
    mssShowErrMsg("must be specify at least one of parameters -n,-d,-s,-D.");
    exit(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*前処理                                                                      */
/*----------------------------------------------------------------------------*/
  fr=mssInitFldRec(hdi->flds->cnt);

  /* 全項目を一度スキャンし、カテゴリ属性の値をハッシュに格納 */
  if(optCAT.set){

    hash=mssCalloc(sizeof(struct mssHash *)*optCAT.flds->cnt,"main");
    for(i=0;i<optCAT.flds->cnt;i++){
      *(hash+i)=mssInitHash(101); /* hash構造体の初期化 */
    }

    while(EOF!=mssReadFldRec(fpr,fr)){
      /* 項目数でLoop */
      for(i=0;i<optCAT.flds->cnt;i++){
        fldNo=MssFlds2num(optCAT.flds,i);
        if(!MssIsNull(*(fr->pnt+fldNo))){
          /* 項目の値(文字列)をハッシュ表に登録する       */
          /* ハッシュ表になければ、新しいノードを追加する */
          mssHashInsert(*(hash+i),*(fr->pnt+fldNo),v);
        }
      }
    }
  }

/*----------------------------------------------------------------------------*/
/*arffヘッダー出力                                                            */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  /* relation */
  mssWriteStr("@RELATION\t\"",fpw);
  if(hdi->title==NULL){
    mssWriteStr("By MUSASHI\"",fpw);
  }else{
    mssWriteStr(hdi->title,fpw);
    mssWriteStr("\"",fpw);
  } 
  mssWriteStr("\n\n",fpw);

  /* attribute(string) */
  if(optSTR.set){
    for(i=0;i<optSTR.flds->cnt;i++){
      mssWriteStr("@ATTRIBUTE\t",fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr(MssFlds2name(optSTR.flds,i),fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr("\t",fpw);
      mssWriteStr("string\n",fpw);
    }
  }

  /* attribute(date) */
  if(optDAT.set){
    withTime=mssMalloc(sizeof(int)*optDAT.flds->cnt,"xt2arff");
    for(i=0;i<optDAT.flds->cnt;i++){
      mssWriteStr("@ATTRIBUTE\t",fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr(MssFlds2name(optDAT.flds,i),fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr("\t",fpw);
      if(mssIsFldOptOn(&optDAT,i,'t')){
        mssWriteStr("date yyyyMMddHHmmss\n",fpw);
        *(withTime+i)=1;
      }else{
        mssWriteStr("date yyyyMMdd\n",fpw);
        *(withTime+i)=0;
      }
    }
  }


  /* attribute(numeric) */
  if(optNUM.set){
    for(i=0;i<optNUM.flds->cnt;i++){
      mssWriteStr("@ATTRIBUTE\t",fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr(MssFlds2name(optNUM.flds,i),fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr("\t",fpw);
      mssWriteStr("numeric\n",fpw);
    }
  }

  /* attribute(categorical) */
  if(optCAT.set){
    for(i=0;i<optCAT.flds->cnt;i++){
      mssWriteStr("@ATTRIBUTE\t",fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr(MssFlds2name(optCAT.flds,i),fpw);
      mssWriteStr("\"",fpw);
      mssWriteStr("\t",fpw);
      mssWriteStr("{",fpw);
      firstFlg=1;
      for(j=0; j<(*(hash+i))->hashVal; j++){
        if( NULL != (hn=*((*(hash+i))->node+j)) ){
          while(hn!=NULL){
            if(firstFlg) firstFlg=0;
            else         mssWriteStr(",",fpw);
            mssWriteStr("\"",fpw);
            mssWriteStr(hn->str,fpw);
            mssWriteStr("\"",fpw);
            hn=hn->next;
          }
        }
      }
      mssWriteStr("}\n",fpw);
    }
  }
  mssWriteStr("\n",fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  mssSeekTopFPR(fpr);
  mssWriteStr("@DATA\n",fpw);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;
    firstFlg=1;

    /*項目の書き出し(String)*/
    if(optSTR.set){
      for(i=0; i<optSTR.flds->cnt; i++){
        if(firstFlg) firstFlg=0;
        else         mssWriteStr(",",fpw);
        str=*(fr->pnt+MssFlds2num(optSTR.flds,i));
        if( MssIsNull(str) ){
          mssWriteStr("?",fpw);
        }else{
          mssWriteStr(*(fr->pnt+MssFlds2num(optSTR.flds,i)),fpw);
        }
      }
    }

    /*項目の書き出し(Date)*/
    if(optDAT.set){
      for(i=0; i<optDAT.flds->cnt; i++){
        if(firstFlg) firstFlg=0;
        else         mssWriteStr(",",fpw);
        str=*(fr->pnt+MssFlds2num(optDAT.flds,i));
        len=strlen(str);
        if( MssIsNull(str) ){
          mssWriteStr("?",fpw);
        }else{
          if(*(withTime+i)){
            if(len==14) mssWriteStr(*(fr->pnt+MssFlds2num(optDAT.flds,i)),fpw);
            else        mssWriteStr("?",fpw);
          }else{
            if(len==8) mssWriteStr(*(fr->pnt+MssFlds2num(optDAT.flds,i)),fpw);
            else       mssWriteStr("?",fpw);
          }
        }
      }
    }

    /*項目の書き出し(Numerical)*/
    if(optNUM.set){
      for(i=0; i<optNUM.flds->cnt; i++){
        if(firstFlg) firstFlg=0;
        else         mssWriteStr(",",fpw);
        str=*(fr->pnt+MssFlds2num(optNUM.flds,i));
        if( MssIsNull(str) ){
          mssWriteStr("?",fpw);
        }else{
          mssWriteStr(*(fr->pnt+MssFlds2num(optNUM.flds,i)),fpw);
        }
      }
    }

    /*項目の書き出し(Categorical)*/
    if(optCAT.set){
      for(i=0; i<optCAT.flds->cnt; i++){
        if(firstFlg) firstFlg=0;
        else         mssWriteStr(",",fpw);
        str=*(fr->pnt+MssFlds2num(optCAT.flds,i));
        if( MssIsNull(str) ){
          mssWriteStr("?",fpw);
        }else{
          mssWriteStr("\"",fpw);
          mssWriteStr(*(fr->pnt+MssFlds2num(optCAT.flds,i)),fpw);
          mssWriteStr("\"",fpw);
        }
      }
    }

    mssWriteRet(fpw);
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);

  mssFree(withTime);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);        /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);        /*出力ファイルのクローズ*/
  mssFreeHeader(hdi);      /*入力ヘッダ領域開放*/
  mssFreeOption(opt);      /*オプション領域開放*/
  mssShowEndMsg();         /*完了メッセージ*/
  mssEnd(mssExitSuccess);  /*終了*/
  return(0); /* to avoid warning message*/
}
