/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成(2004/03/03)                                                 */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2csvHelp.h>
struct mssComHelp comHelp={
  "xt2csv",       /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */                                      
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};
    
extern struct mssGlobalVariables mssGV;

void writeCSVdat(char *str,struct mssFPW *fpw){

  mssWriteChr('"',fpw);
  while(*str!='\0'){
    if(*str=='"'){
      mssWriteStr("\"\"",fpw);
    }else{
      mssWriteChr(*str,fpw);
    }
    str++;
  }
  mssWriteChr('"',fpw);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* クオートする項目                                                           */
/*----------------------------------------------------------------------------*/
  MssOptFLD optQUO={
    OFLD,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    QUOT,   /* このオプションのタイトル(Helpで表示)                         */
    QUOC,   /* このオプションのコメント(Helpで表示)                         */
    QUOF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 先頭行に項目名を出力する                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optHFD={
    OFLG,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    HFDT,   /* このオプションのタイトル(Helpで表示)                         */
    HFDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optEXP={
    OOTF,   /* オプションタイプ                                             */
    "E",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    EXPT,   /* このオプションのタイトル(Helpで表示)                         */
    EXPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optQUO,&optHFD,&optEXP,&optINF,&optOTF,&optZIP,NULL};
    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFPW    *fpw2;/*エクスポートファイル構造体*/
  struct mssFldRec *fr;  /*項目-行バッファ構造体*/

  int i;
  int tmp;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */
  fpr=mssOpenFPR(optINF.str,4);       /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);             /* ヘッダの読み込み             */
  mssSetOptFld(&optQUO, hdi);         /* -q 項目をヘッダー項目に関連づける*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  /*ヘッダーのエクスポート*/
  if(optEXP.set){
    fpw2=mssOpenFPW(optEXP.str,optZIP.set,0);
    tmp=mssGV.txtFlg;mssGV.txtFlg=0;    
    mssWriteHeader(hdi, fpw2);
    mssWriteFooter(fpw2);  /*フッターの出力*/
    mssGV.txtFlg=tmp;    
    mssCloseFPW(fpw2);
  }

  /*テキストのヘッダー出力*/
  if(optHFD.set){
    for(i=0; i<hdi->flds->cnt-1; i++){
      mssWriteStr(MssFlds2name(hdi->flds,i),fpw);
      mssWriteStr(",",fpw);
    }
    mssWriteStr(MssFlds2name(hdi->flds,i),fpw);
    mssWriteRet(fpw);
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;
    for(i=0; i<hdi->flds->cnt; i++){
      if(i!=0) mssWriteStr(",",fpw);
      if(optQUO.set){
        if(*(optQUO.fldNo2optNo+i)==-1){  /*クオートなし*/
          mssWriteStr(*(fr->pnt+i),fpw);
        }else{                            /*クオートあり*/
          writeCSVdat(*(fr->pnt+i),fpw);
        }
      }else{
        mssWriteStr(*(fr->pnt+i),fpw);
      }
    }
    mssWriteRet(fpw);
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);        /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);        /*出力ファイルのクローズ*/
  mssFreeHeader(hdi);      /*入力ヘッダ領域開放*/
  mssFreeOption(opt);      /*オプション領域開放*/
  mssShowEndMsg();         /*完了メッセージ*/
  mssEnd(mssExitSuccess);  /*終了*/
  return(0); /* to avoid warning message*/
}
