/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成(2004/08/13)                                                 */
/* 1.1 : メモリリーク解決(2004/10/31)                                         */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2gmlHelp.h>
struct mssComHelp comHelp={
  "xt2gml",       /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */                                      
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};
    
extern struct mssGlobalVariables mssGV;

/**
 * # FUNCTION #
 * 現在読み込まれているノードとエッジファイルのキーの値を比較する
 */
int keyCmp(
  struct mssFldRecDbl *frdN,
  struct mssFldRecDbl *frdE,
  struct mssFields    *fldsN,
  struct mssFields    *fldsE){
  int cmp;
  int i;
  int fnN;
  int fnE;
  
  for(i=0; i<fldsN->cnt; i++){
    fnN=MssFlds2num(fldsN,i);
    fnE=MssFlds2num(fldsE,i);
    cmp = strcmp(*(frdN->pnt[frdN->old]+fnN),
                 *(frdE->pnt[frdE->new]+fnE));
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

/**
 * # FUNCTION #
 * Vertex要素の出力
 * Vertexを示す値(-v)をハッシュに登録し、それをかえす
 */
struct mssHash *writeVertex(
  struct mssFldRecDbl *frdN,
  struct mssFPR       *fprN,
  MssOptKEY           *optNKY,
  MssOptFLD           *optNID,
  MssOptFLD           *optNAT,
  MssOptFLG           *optWOT,
  struct mssFPW       *fpw){

  int dimention;
  struct mssXmlTag *vTag; /* Vertexタグ*/
  struct mssXmlTag *lTag; /* VertexLabelタグ*/
  char *fldVal;
  int i;
  int nulFlg;
  struct mssHash *hash;
  MssValue v; /* hash登録用 */
  char buf[MssRecordMaxLen];
  struct mssHashNode *hn;

  if(!optWOT->set) dimention=optNID->cnt+optNAT->cnt;
  else             dimention=            optNAT->cnt;

  hash=mssInitHash(101); /* hash構造体の初期化 */
  mssVinit(&v,INT);         /* vertexID */
  v.v.i=1;                  /*vertexIDは1からはじまる*/

  while(1){
    mssReadFRD(fprN,frdN);

    /* ノードIDのハッシュ登録 (null値を含んでいれば登録しない) */
    nulFlg=0;
    buf[0]='\0';
    for(i=0; i<optNID->cnt; i++){
      fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNID->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(buf,fldVal);
    }
    /* 項目の値(文字列)をハッシュ表に登録する       */
    /* ハッシュ表になければ、新しいノードを追加する */
    if(!nulFlg){
      hn=mssHashInsert(hash,buf,v);
      if(hn==NULL){
        mssShowErrMsg("-n fields must be unique");
        mssEnd(mssErrorNoDefault);
      }
    }else{
      continue;
    }
 
    /* <Vertex vertexID="1" dimention="2"> */
    vTag=mssInitXmlTag("Vertex",NULL);
    mssAddXmlTagAttributeInt(vTag,"vertexId" , hn->val.v.i , NULL);
    mssAddXmlTagAttributeInt(vTag,"dimention", dimention, NULL);
    mssWriteXmlStartTag(vTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    if(!optWOT->set){
      for(i=0; i<optNID->flds->cnt; i++){
        /* <VertexLabel field="year" value="2004"> */
        fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNID->flds,i));
        lTag=mssInitXmlTag("VertexLabel",NULL);
        mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optNID->flds,i),NULL);
        mssAddXmlTagAttributeStr(lTag,"value", fldVal     , NULL);
        mssWriteXmlEmptyTag(lTag,NULL,fpw);
        mssWriteRet(fpw); mssGV.outCnt++;
        mssFreeXmlTag(lTag);
      }
    }

    for(i=0; i<optNAT->flds->cnt; i++){
      /* <VertexLabel field="year" value="2004"> */
      fldVal=*(frdN->pnt[frdN->old] + MssFlds2num(optNAT->flds,i));
      lTag=mssInitXmlTag("Vertex",NULL);
      mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optNAT->flds,i), NULL);
      mssAddXmlTagAttributeStr(lTag,"value", fldVal     , NULL);
      mssWriteXmlEmptyTag(lTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(lTag);
    }

    /* </Vertex> */
    mssWriteXmlEndTag(vTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(vTag);

    if(mssKeyBreak(frdN, optNKY)) break;

    if(frdN->eof) break;

    v.v.i++;
  }

  return(hash);
}

/**
 * # FUNCTION #
 * Edge要素の出力
 */
void writeEdge(
  struct mssFldRecDbl *frdE,
  struct mssFPR       *fprE,
  struct mssHash      *hash,
  MssOptKEY           *optEKY,
  MssOptFLD           *optEBG,
  MssOptFLD           *optEED,
  MssOptFLD           *optDIR,
  MssOptFLG           *optDFG,
  MssOptFLD           *optEAT,
  struct mssFPW       *fpw){

  int dimention=optEAT->flds->cnt;
  struct mssXmlTag *eTag; /* Edgeタグ*/
  struct mssXmlTag *lTag; /* EdgeLabelタグ*/
  char *fldVal;
  int i;
  int nulFlg;
  char bufB[MssRecordMaxLen];
  char bufE[MssRecordMaxLen];
  struct mssHashNode *hn;
  int bNo=0,eNo=0;
  char *dir;

  while(1){
    mssReadFRD(fprE,frdE);

    /* -b項目の値を結合 (null値を含んでいればなにもしない) */
    nulFlg=0;
    bufB[0]='\0';
    for(i=0; i<optEBG->cnt; i++){
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEBG->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(bufB,fldVal);
    }
    if(nulFlg) continue;

    /* -e項目の値を結合 (null値を含んでいればなにもしない) */
    nulFlg=0;
    bufE[0]='\0';
    for(i=0; i<optEED->cnt; i++){
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEED->flds,i));
      if(MssIsNull(fldVal)) {
        nulFlg=1;
        break;
      }
      strcat(bufE,fldVal);
    }
    if(nulFlg) continue;

    /* -e項目の値をhash表に問い合わせ、ノード番号を得る */
    hn=mssHashMember(hash,bufB);
    if(hn!=NULL) {
      bNo=hn->val.v.i;
    }else{
      mssShowErrMsg("internal error in referencing a hash");
      mssEnd(mssErrorNoDefault);
    }

    /* -b項目の値をhash表に問い合わせ、ノード番号を得る */
    hn=mssHashMember(hash,bufE);
    if(hn!=NULL) {
      eNo=hn->val.v.i;
    }else{
      mssShowErrMsg("internal error in referencing a hash");
      mssEnd(mssErrorNoDefault);
    }

    /* directionを決める(-D項目の値、-Dirより) */
    if(optDFG->set){
      dir="directed";
    }else{
      if(optDIR->set){
        fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optDIR->flds,0));
        if(MssIsNull(fldVal) || *fldVal=='0') {
          dir="undirected";
        }else{
          dir="directed";
        }
      }else{
        dir="undirected";
      }
    }

    /* <Edge edgeID="1" edgeType="undirected" dimention="2"
                        bgnVertexId="1" endVertexId="2" > */
    eTag=mssInitXmlTag("Edge",NULL);
    mssAddXmlTagAttributeStr(eTag,"edgeType" ,dir , NULL);
    mssAddXmlTagAttributeInt(eTag,"dimention", dimention, NULL);
    mssAddXmlTagAttributeInt(eTag,"bgnVertexId", bNo, NULL);
    mssAddXmlTagAttributeInt(eTag,"endVertexId", eNo, NULL);
    mssWriteXmlStartTag(eTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    for(i=0; i<optEAT->flds->cnt; i++){
      /* <EdgeLabel field="att1" value="xxx"> */
      fldVal=*(frdE->pnt[frdE->old] + MssFlds2num(optEAT->flds,i));
      lTag=mssInitXmlTag("EdgeLabel",NULL);
      mssAddXmlTagAttributeStr(lTag,"field",MssFlds2name(optEAT->flds,i), NULL);
      mssAddXmlTagAttributeStr(lTag,"value", fldVal, NULL);
      mssWriteXmlEmptyTag(lTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(lTag);
    }

    /* </Edge> */
    mssWriteXmlEndTag(eTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(eTag);

    if(mssKeyBreak(frdE, optEKY)) break;

    if(frdE->eof) break;
  }
}


int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ノードファイルのグラフキー項目                                             */
/*----------------------------------------------------------------------------*/
  MssOptKEY optNKY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    NKYT,   /* このオプションのタイトル(Helpで表示)                         */
    NKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* エッジファイルのグラフキー項目                                             */
/*----------------------------------------------------------------------------*/
  MssOptKEY optEKY={
    OKEY,   /* オプションタイプ                                             */
    "K",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "I",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    EKYT,   /* このオプションのタイトル(Helpで表示)                         */
    EKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ノードID項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNID={
    OFLD,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    NIDT,   /* このオプションのタイトル(Helpで表示)                         */
    NIDC,   /* このオプションのコメント(Helpで表示)                         */
    NIDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* ノード属性項目                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNAT={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    NATT,   /* このオプションのタイトル(Helpで表示)                         */
    NATC,   /* このオプションのコメント(Helpで表示)                         */
    NATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* エッジの開始ノード項目                                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEBG={
    OFLD,   /* オプションタイプ                                             */
    "b",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "I",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    EBGT,   /* このオプションのタイトル(Helpで表示)                         */
    EBGC,   /* このオプションのコメント(Helpで表示)                         */
    EBGF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* エッジの開始ノード項目                                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEED={
    OFLD,   /* オプションタイプ                                             */
    "e",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "I",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    EEDT,   /* このオプションのタイトル(Helpで表示)                         */
    EEDC,   /* このオプションのコメント(Helpで表示)                         */
    EEDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* エッジ属性項目                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLD optEAT={
    OFLD,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "I",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    EATT,   /* このオプションのタイトル(Helpで表示)                         */
    EATC,   /* このオプションのコメント(Helpで表示)                         */
    EATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* ノードファイル                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optNIF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    NIFT,   /* このオプションのタイトル(Helpで表示)                         */
    NIFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* エッジファイル                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optEIF={
    OINF,   /* オプションタイプ                                             */
    "I",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    EIFT,   /* このオプションのタイトル(Helpで表示)                         */
    EIFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* directed/undirectedフラグ項目                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLD optDIR={
    OFLD,   /* オプションタイプ                                             */
    "d",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "I",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    DIRT,   /* このオプションのタイトル(Helpで表示)                         */
    DIRC,   /* このオプションのコメント(Helpで表示)                         */
    DIRF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* directedフラグ                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optDFG={
    OFLG,   /* オプションタイプ                                             */
    "D",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    DFGT,   /* このオプションのタイトル(Helpで表示)                         */
    DFGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* -n の項目をgraphLabelに含めないフラグ                                      */
/*----------------------------------------------------------------------------*/
  MssOptFLG optWOT={
    OFLG,   /* オプションタイプ                                             */
    "w",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    WOTT,   /* このオプションのタイトル(Helpで表示)                         */
    WOTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* コピーライト                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCPY={
    OSTR,   /* オプションタイプ                                             */
    "cr",   /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "musashi.sourceforge.jp", /* デフォルト                                 */
    1,      /* 文字列の最小長                                               */
    250,    /* 文字列の最大長                                   */
    CPYT,   /* このオプションのタイトル(Helpで表示)                         */
    CPYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* description                                                                */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDSC={
    OSTR,   /* オプションタイプ                                             */
    "desc",   /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "xt2gml", /* デフォルト                                                */
    1,      /* 文字列の最小長                                               */
    250,    /* 文字列の最大長                                   */
    DSCT,   /* このオプションのタイトル(Helpで表示)                         */
    DSCC    /* このオプションのコメント(Helpで表示)                         */
  };


/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optNKY,&optEKY,&optNID,&optNAT,&optEBG,&optEED,&optEAT,
               &optNIF,&optEIF,&optOTF,&optDIR,&optDFG,&optWOT,&optTXT,
               &optTMP,&optCPY,&optDSC,NULL};
    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdN; /*ノードファイル用<head>タグ格納構造体*/
  struct mssHeader *hdE; /*エッジファイル用<head>タグ格納構造体*/

  struct mssFPR    *fprN; /*ノードファイル構造体*/
  struct mssFPR    *fprE; /*エッジファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRec *fr;  /*項目-行バッファ構造体*/
  struct mssFldRecDbl *frdN;  /*項目-行バッファ構造体*/
  struct mssFldRecDbl *frdE;  /*項目-行バッファ構造体*/
  struct mssFields *sfN; /*ソート項目構造体*/
  struct mssFields *sfE; /*ソート項目構造体*/
  int sortedN;           /*ソート済チェック用*/
  int sortedE;           /*ソート済チェック用*/

  struct mssHash *hash=NULL;     /* ノードIDの値を格納するhash */

  struct mssHash **hashNID=NULL;  /* -n項目の値を格納するhash */
  struct mssHash **hashNAT=NULL;  /* -b項目の値を格納するhash */
  struct mssHash **hashEAT=NULL;  /* -e項目の値を格納するhash */
  struct mssHash *hs;             /* 計算用hash */
  struct mssHashNode *hn;

  MssValue v; /* hash登録用ダミー */
  char *fldVal;
  int i,j;
  int kc;
  int gNo;
  struct mssXmlTag *rTag; /* root(graphML)タグ*/
  struct mssXmlTag *hTag; /* headerタグ*/
  struct mssXmlTag *dTag; /* DataDictionaryタグ*/
  struct mssXmlTag *dfTag; /* DataFieldタグ*/
  struct mssXmlTag *gTag; /* graphタグ*/
  struct mssXmlTag *gdTag; /* GraphDataタグ*/
  struct mssXmlTag *tag; /* 一時タグ*/
  int    nf;
  int    numFlg;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */

  /*-Kが指定されていなければ-kをコピーする*/
  if(!optEKY.set){
    mssCpyOptKey(&optEKY,&optNKY);
  }

  fprN=mssOpenFPR(optNIF.str,4);       /* ノードファイルオープン       */
  fprE=mssOpenFPR(optEIF.str,4);       /* エッジファイルオープン       */
  hdN=mssReadHeader(fprN);             /* ノードファイルヘッダの読み込み */
  hdE=mssReadHeader(fprE);             /* エッジファイルヘッダの読み込み */

  mssSetOptKey(&optNKY, hdN); /* -k */
  mssSetOptFld(&optNID, hdN); /* -n */
  mssSetOptFld(&optNAT, hdN); /* -f */
  mssSetOptKey(&optEKY, hdE); /* -K */
  mssSetOptFld(&optEBG, hdE); /* -b */
  mssSetOptFld(&optEED, hdE);        /* -e 項目をヘッダー項目に関連づける */
  mssSetOptFld(&optDIR, hdE);        /* -d 項目をヘッダー項目に関連づける */
  mssSetOptFld(&optEAT, hdE);        /* -F 項目をヘッダー項目に関連づける */

  /*ノードのソート項目の作成*/
  sfN=mssInitFields();
  mssAddFieldsByFields(sfN,optNKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfN);        /* ソート優先順位番号を登録順にふる   */
  sortedN=mssChkSorted(sfN,hdN);        /* ソート済かチェック                 */

  /*エッジのソート項目の作成*/
  sfE=mssInitFields();
  mssAddFieldsByFields(sfE,optEKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfE);        /* ソート優先順位番号を登録順にふる   */
  sortedE=mssChkSorted(sfE,hdE);        /* ソート済かチェック                 */


/*----------------------------------------------------------------------------*/
/*前処理                                                                      */
/*----------------------------------------------------------------------------*/
  if(!sortedN){
    fprN=mssReopenFPRsort(fprN,4,sfN,hdN->flds->cnt,optTMP.str);
  }
  if(!sortedE){
    fprE=mssReopenFPRsort(fprE,4,sfE,hdE->flds->cnt,optTMP.str);
  }

  /* ノードID項目を一度スキャンし、ハッシュに格納しID番号をふる*/
  /* ノード属性項目を一度スキャンし、ハッシュに格納*/

  /* ノードID関連初期化 */
  hashNID=mssCalloc(sizeof(struct mssHash *)*optNID.flds->cnt,"main");
  for(i=0;i<optNID.flds->cnt;i++){
    *(hashNID+i)=mssInitHash(101); /* hash構造体の初期化 */
  }

  /* ノード属性関連初期化 */
  hashNAT=mssCalloc(sizeof(struct mssHash *)*optNAT.flds->cnt,"main");
  for(i=0;i<optNAT.flds->cnt;i++){
    *(hashNAT+i)=mssInitHash(101); /* hash構造体の初期化 */
  }

  /* ノードファイルをスキャン */
  fr=mssInitFldRec(hdN->flds->cnt);
  mssVinit(&v,INT);         /* hash登録用ダミー */
  while(EOF!=mssReadFldRec(fprN,fr)){

    /* ノードID (null値は登録しない) */
    for(i=0;i<optNID.flds->cnt;i++){
      fldVal=*(fr->pnt + MssFlds2num(optNID.flds,i));
      if(!MssIsNull(fldVal)) {
        mssHashInsert(*(hashNID+i),fldVal,v); /* vはダミー */
      }
    }
 
    /* ノード属性 (null値も登録する)*/
    for(i=0;i<optNAT.flds->cnt;i++){
      numFlg=mssIsFldOptOn(&optNAT,i,'n');
      if(!numFlg){ /* numeric項目はスキップ*/
        fldVal=*(fr->pnt + MssFlds2num(optNAT.flds,i));
        mssHashInsert(*(hashNAT+i),fldVal,v); /* vはダミー */
      }
    }
  }
  mssFreeFldRec(fr);


  /* エッジ属性関連初期化 */
  hashEAT=mssCalloc(sizeof(struct mssHash *)*optEAT.flds->cnt,"main");
  for(i=0;i<optEAT.flds->cnt;i++){
    *(hashEAT+i)=mssInitHash(101); /* hash構造体の初期化 */
  }

  /* エッジファイルをスキャン */
  fr=mssInitFldRec(hdE->flds->cnt);
  while(EOF!=mssReadFldRec(fprE,fr)){
    /* エッジ属性(null値も登録する) */
    for(i=0;i<optEAT.flds->cnt;i++){
      numFlg=mssIsFldOptOn(&optNAT,i,'n');
      if(!numFlg){ /* numeric項目はスキップ*/
        fldVal=*(fr->pnt + MssFlds2num(optEAT.flds,i));
        mssHashInsert(*(hashEAT+i),fldVal,v); /* vはダミー */
      }
    }
  }
  mssFreeFldRec(fr);


/*----------------------------------------------------------------------------*/
/* XMLヘッダー & graphMLヘッダー出力                                          */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,0,0);

  /*xmlヘッダーの書き出し*/
  mssWriteXmlDeclaration(MssXmlDefVer,MssXmlDefEnc,fpw);
  mssGV.outCnt++;

  /* <GraphML version="0.1"> */
  rTag=mssInitXmlTag("GraphML",NULL);
  mssAddXmlTagAttributeStr(rTag,"version", "0.1", NULL);
  mssWriteXmlStartTag(rTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /* <Header copyright="xxx" description="xxxxx"/> */
  hTag=mssInitXmlTag("Header",NULL);
  mssAddXmlTagAttributeStr(hTag,"copyright", optCPY.str, NULL);
  mssAddXmlTagAttributeStr(hTag,"description", optDSC.str, NULL);
  mssWriteXmlStartTag(hTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /*   <DataDictionary numberOfFields="xxxxx"> */
  if(!optWOT.set) nf=optNID.cnt+optNAT.cnt+optEAT.cnt;
  else            nf=           optNAT.cnt+optEAT.cnt;
  dTag=mssInitXmlTag("DataDictionary",NULL);
  mssAddXmlTagAttributeInt(dTag,"numberOfFields",nf,NULL);
  mssWriteXmlStartTag(dTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /*     <DataField name="xxx" optype="xxxxx"> */
  /*       <Value value="xxx"/> */
  /*     </DataField> */

  /* -v */
  if(!optWOT.set){
    for(i=0; i<optNID.cnt; i++){
      dfTag=mssInitXmlTag("DataField",NULL);
      mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optNID.flds,i),NULL);
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      hs=*(hashNID+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
      mssFreeXmlTag(dfTag);
    }
  }

  /* -f */
  for(i=0; i<optNAT.cnt; i++){
    numFlg=mssIsFldOptOn(&optNAT,i,'n');
    dfTag=mssInitXmlTag("DataField",NULL);
    mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optNAT.flds,i),NULL);
    if(numFlg){
      mssAddXmlTagAttributeStr(dfTag,"optype","numerical",NULL);
      mssWriteXmlEmptyTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }else{
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;

      hs=*(hashNAT+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }
    mssFreeXmlTag(dfTag);
  }

  /* -F */
  for(i=0; i<optEAT.cnt; i++){
    numFlg=mssIsFldOptOn(&optEAT,i,'n');
    dfTag=mssInitXmlTag("DataField",NULL);
    mssAddXmlTagAttributeStr(dfTag,"name",MssFlds2name(optEAT.flds,i),NULL);
    if(numFlg){
      mssAddXmlTagAttributeStr(dfTag,"optype","numerical",NULL);
      mssWriteXmlEmptyTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }else{
      mssAddXmlTagAttributeStr(dfTag,"optype","categorical",NULL);
      mssWriteXmlStartTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;

      hs=*(hashEAT+i);
      for(j=0; j<hs->hashVal; j++){
        if( NULL != (hn=*(hs->node+j)) ){
          while(hn!=NULL){
            tag=mssInitXmlTag("Value",NULL);
            mssAddXmlTagAttributeStr(tag,"value",hn->str,NULL);
            mssWriteXmlEmptyTag(tag,NULL,fpw);
            mssWriteRet(fpw); mssGV.outCnt++;
            mssFreeXmlTag(tag);
            hn=hn->next;
          }
        }
      }
      mssWriteXmlEndTag(dfTag,NULL,fpw);
      mssWriteRet(fpw); mssGV.outCnt++;
    }
    mssFreeXmlTag(dfTag);
  }


  /*   </DataDictionary> */
  mssWriteXmlEndTag(dTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(dTag);

  /* </Header> */
  mssWriteXmlEndTag(hTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(hTag);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /* <GraphData> */
  gdTag=mssInitXmlTag("GraphData",NULL);
  mssWriteXmlStartTag(gdTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;

  /* <Graph graphID="xx"> */

  mssSeekTopFPR(fprN);
  mssSeekTopFPR(fprE);

  frdN=mssInitFRD(hdN->flds->cnt);
  frdE=mssInitFRD(hdE->flds->cnt);

  mssReadFRD(fprN,frdN);
  mssReadFRD(fprE,frdE);
  frdN->firstRead=0;
  frdE->firstRead=0;
  gNo=1;
  while(1){

    /* ノードファイルがEnd */
    if(frdN->eof) break;

    /* <Graph graphID="1"> */
    gTag=mssInitXmlTag("Graph",NULL);
    mssAddXmlTagAttributeInt(gTag,"graphId", gNo, NULL);
    mssWriteXmlStartTag(gTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;

    /* ノードの書き出し */
    hash=writeVertex(frdN,fprN,&optNKY,&optNID,&optNAT,&optWOT,fpw);

BgnLoop:
    /* エッジファイルがEnd */
    if(frdE->eof) goto EndLoop;

    kc=keyCmp(frdN,frdE,optNKY.flds,optEKY.flds);
    if(kc>0){        /*T>M*/
      /* エッジファイルをスキップ*/
      while(kc>0){
        mssReadFRD(fprE,frdE);
        kc=keyCmp(frdN,frdE,optNKY.flds,optEKY.flds);
        if(frdE->eof)break;
      }
      goto BgnLoop;
    }else if(kc<0) { /*T<M*/
      goto EndLoop;
    }else{           /*T==M*/
      writeEdge(frdE,fprE,hash,&optEKY,&optEBG,&optEED,&optDIR,&optDFG,&optEAT,fpw);
    }
EndLoop:

    mssFreeHash(hash);

    /* </Graph> */
    mssWriteXmlEndTag(gTag,NULL,fpw);
    mssWriteRet(fpw); mssGV.outCnt++;
    mssFreeXmlTag(gTag);
    gNo++;
  }

  /* </GraphData> */
  mssWriteXmlEndTag(gdTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(gdTag);

  /* </GraphML> */
  mssWriteXmlEndTag(rTag,NULL,fpw);
  mssWriteRet(fpw); mssGV.outCnt++;
  mssFreeXmlTag(rTag);


  /* free */
  if(hashNID!=NULL){
    for(i=0;i<optNID.flds->cnt;i++){
      mssFreeHash(*(hashNID+i)); /* hash構造体の初期化 */
    }
    mssFree(hashNID);
  }
  if(hashNAT!=NULL){
    for(i=0;i<optNAT.flds->cnt;i++){
      mssFreeHash(*(hashNAT+i)); /* hash構造体の初期化 */
    }
    mssFree(hashNAT);
  }
  if(hashEAT!=NULL){
    for(i=0;i<optEAT.flds->cnt;i++){
      mssFreeHash(*(hashEAT+i)); /* hash構造体の初期化 */
    }
    mssFree(hashEAT);
  }

  mssFreeFRD(frdN);
  mssFreeFRD(frdE);


/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fprN);       /*入力ファイルのクローズ*/
  mssCloseFPR(fprE);       /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);        /*出力ファイルのクローズ*/
  mssFreeFields(sfN);      /* ソート項目構造体の領域開放(追加2004/10/31) */
  mssFreeFields(sfE);      /* ソート項目構造体の領域開放(追加2004/10/31) */
  mssFreeHeader(hdN);      /*入力ヘッダ領域開放*/
  mssFreeHeader(hdE);      /*入力ヘッダ領域開放*/
  mssFreeOption(opt);      /*オプション領域開放*/
  mssShowEndMsg();         /*完了メッセージ*/
  mssEnd(mssExitSuccess);  /*終了*/
  return(0); /* to avoid warning message*/
}
