/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応(2003/06)                                             */
/* 1.2 : -bパラメータ追加(2003/03/27)                                         */
/* 1.3 : -kの指定によって空白セルが出てしまうバグ修正(2004/10/12)             */
/* 1.4 : メモリリーク解決(2004/10/31)                                         */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2htmlHelp.h>
struct mssComHelp comHelp={
  "xt2html",      /* コマンド名       */
  "1.4",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int keyBreak(char **old, char **new, int fldNo)
{
  if( 0!=strcmp(*(old+fldNo),*(new+fldNo)) ){
    return(1);
  }else{
    return(0);
  }
}

void cpyToOldRec(char **old, char **new, int fldCnt)
{
  int i;
  for(i=0; i<fldCnt; i++){
    mssFree(*(old+i));
    *(old+i)=mssStrdup(*(new+i));
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 右詰め対象項目                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRIT={
    OFLD,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    RITT,   /* このオプションのタイトル(Helpで表示)                         */
    RITC,   /* このオプションのコメント(Helpで表示)                         */
    RITF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 中央揃え対象項目                                                           */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCNT={
    OFLD,   /* オプションタイプ                                             */
    "C",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    CNTT,   /* このオプションのタイトル(Helpで表示)                         */
    CNTC,   /* このオプションのコメント(Helpで表示)                         */
    CNTF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTBL={
    OFLG,   /* オプションタイプ                                             */
    "b",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TBLT,   /* このオプションのタイトル(Helpで表示)                         */
    TBLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optRIT,&optCNT,&optTBL,&optSEQ,&optINF,&optOTF,&optZIP,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRecKey *frk=NULL;/*キー単位バッファ構造体            */
  struct mssFields    *sf;      /*ソート項目構造体                  */
  struct mssFldRec *fr=NULL;/*項目バッファ構造体*/
  int sorted;                   /*ソート済チェック用                */

  struct mssXmlTag *htmlTag=NULL;
  struct mssXmlTag *headTag=NULL;
  struct mssXmlTag *metaTag=NULL;
  struct mssXmlTag *bodyTag=NULL;
  struct mssXmlTag *tableTag=NULL;
  struct mssXmlTag *trTag=NULL;
  struct mssXmlTag *thTag=NULL;
  struct mssXmlTag *tdTag=NULL;

  void *optInside[2]; /* 追加 2004/10/31 */
  MssOptKEY pkey; /*最も外側のキー項目*/

  char **oldRec;
  int  recNo;
  int  fldNo;
  int  cmp;
  int  *rspan;
  int  rspanCnt;
  char *str;
  int i,j,k;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */
  fpr=mssOpenFPR(optINF.str,4);       /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);             /* ヘッダの読み込み             */
  mssSetOptKey(&optKEY, hdi);         /* -k 項目をヘッダー項目に関連づける  */
  mssSetOptFld(&optRIT, hdi);         /* -R 項目をヘッダー項目に関連づける  */
  mssSetOptFld(&optCNT, hdi);         /* -C 項目をヘッダー項目に関連づける  */

  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

  /*mssShowOption(opt);*/
  /*mssShowHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  /*-bが指定されていればヘッダー関連は出力しない*/
  if(!optTBL.set){

    /* <html> */
    htmlTag=mssInitXmlTag("html",NULL);
    mssWriteXmlStartTag(htmlTag,NULL,fpw);
    mssWriteRet(fpw);

    /* <head> */
    headTag=mssInitXmlTag("head",NULL);
    mssWriteXmlStartTag(headTag,NULL,fpw);
    mssWriteRet(fpw);

    /* <meta> */
    str=mssCatTwoStrings("text/html;Content-Type;charset=",hdi->xmlenc);
    metaTag=mssInitXmlTag("meta",NULL);
    mssAddXmlTagAttributeStr(metaTag,"http-equiv", "Content-Type", NULL);
    mssAddXmlTagAttributeStr(metaTag,"content"   , str, NULL);
    mssFree(str); /* 追加(2004/10/31) */

    /* <title> */
    mssWriteXmlTagStr(0,"TITLE",hdi->title,1,NULL,fpw);

    /* </head> */
    mssWriteXmlEndTag(headTag,NULL,fpw);
    mssWriteRet(fpw);

    /* <body> */
    bodyTag=mssInitXmlTag("BODY",NULL);
    mssWriteXmlStartTag(bodyTag,NULL,fpw);
    mssWriteRet(fpw);

    /* <h1>タイトル</H1> */
    mssWriteXmlTagStr(0,"H1",hdi->title,1,NULL,fpw);
 
    /* <P>コメント</P> */
    mssWriteXmlTagStr(0,"P",hdi->comment,1,NULL,fpw);

  }

  /* <table border="1"> */
  tableTag=mssInitXmlTag("table",NULL);
  mssAddXmlTagAttributeStr(tableTag,"border", "1", NULL);
  mssWriteXmlStartTag(tableTag,NULL,fpw);
  mssWriteRet(fpw);

  /* <TR> */
  trTag=mssInitXmlTag("TR",NULL);
  mssWriteXmlStartTag(trTag,NULL,fpw);
  mssWriteRet(fpw);

  /* <TH>項目名</TH> */
  for(i=0; i<hdi->flds->cnt; i++){
    thTag=mssInitXmlTag("TH",NULL);

    /*文字位置*/
    /*
    if(optRIT.set){
      if(*(optRIT.fldNo2optNo+i) != -1){
        mssAddXmlTagAttributeStr(thTag,"ALIGN","right",NULL);
      }
    }
    if(optCNT.set){
      if(*(optCNT.fldNo2optNo+i) != -1){
        mssAddXmlTagAttributeStr(thTag,"ALIGN","center",NULL);
      }
    }
    */

    /*THのバックのカラー*/
    mssAddXmlTagAttributeStr(thTag,"BGCOLOR","#00ffff",NULL);

    /*THの出力*/
    mssWriteXmlStartTag(thTag,NULL,fpw);
    mssWriteXmlContent(MssFlds2name(hdi->flds,i),NULL,fpw);
    mssWriteXmlEndTag(thTag,NULL,fpw);
    mssFreeXmlTag(thTag);
  }

  /* </TR> */
  mssWriteXmlEndTag(trTag,NULL,fpw);
  mssWriteRet(fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*キーがセットされていれば*/
  if(optKEY.set){
    optInside[0]=&pkey; optInside[1]=NULL; /* 追加 2004/10/31 */
    /*最初の項目のみpkeyにセットする*/
    pkey.type=OKEY; /* 追加 2004/10/31 */
    pkey.str=NULL; /* 追加 2004/10/31 */
    pkey.nam=NULL; /* 追加 2004/10/31 */
    pkey.flds=NULL; /* 追加 2004/10/31 */
    pkey.fldNo2optNo=NULL; /* 追加 2004/10/31 */
    pkey.set=0;
    pkey.diffSame=optKEY.diffSame;
    pkey.cnt=1;
    pkey.flds=mssInitFields();
    mssAddFieldsByFldInfo(pkey.flds,*(optKEY.flds->fi+0));

    /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
    if(!optSEQ.set && !sorted)
      fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

    /*FRK構造体の初期化*/
    frk=mssInitFRK(hdi->flds->cnt, &pkey,optTMP.str);

    /*oldRecの初期化*/
    oldRec=mssMalloc(sizeof(char*)*hdi->flds->cnt, "xt2html");
    for(i=0; i<hdi->flds->cnt; i++){
      *(oldRec+i)=mssStrdup("");
    }

    while(1){
      /*データ読み込み*/
      if(EOF==mssReadFRK(fpr,frk)) break;
      mssGV.inCnt+=frk->keyRecCnt;
      rspan=mssMalloc(sizeof(int)*frk->keyRecCnt*optKEY.flds->cnt,"xt2html");

      /*各キー項目の値がいくつの行を結合するかを計算*/
      recNo=0;
      while( EOF != mssReadFldRecFRK(frk) ){

        /* -k no1,no2,no3 の時、no1の値が同じ行のデータがfrkに読み込まれている
          そこで、no1,no2,no3についてのキーブレーク表を作成する(rspan)
           no1 no2 no3  rspan
           k a x        1 1 1
           k a x        0 0 0
           k a y  ->    0 0 1
           k b y        0 1 1
           k b y        0 0 0
           k b z        0 0 1
        */
	/* 最初の行は全項目でキーブレーク */
	if(recNo==0){
          for(i=0; i<optKEY.flds->cnt; i++){
            *(rspan+i)=1;
	  }
	}else {
          for(i=1; i<optKEY.flds->cnt; i++){
            cmp=keyBreak(oldRec,frk->pnt,MssFlds2num(optKEY.flds,i));
            *(rspan+recNo*optKEY.flds->cnt+i)=cmp;
            if(cmp==1){
              for(j=i+1; j<optKEY.flds->cnt; j++){
                i++;
                *(rspan+recNo*optKEY.flds->cnt+j)=cmp;
              }
            }
          }
	}
        cpyToOldRec(oldRec,frk->pnt,frk->fldCnt);
        recNo++;
      }
      *rspan=1;
      for(i=1; i<frk->keyRecCnt; i++){
        *(rspan+i*optKEY.flds->cnt+0)=0;
      }

      /* 上記で作成したキーブレーク表から、rowspanの数値(各項目の結合行数)
         を求める。
           rspan    rspan
             1 1    3 2
             0 0    0 0
             0 1 -> 0 1
             1 1    3 2
             0 0    0 0
             0 1    0 1
      */
      for(i=0; i<frk->keyRecCnt; i++){
        for(j=0; j<optKEY.flds->cnt; j++){
          if(*(rspan+i*optKEY.flds->cnt+j) == 1 ){
            rspanCnt=1;
            for(k=i+1; k<frk->keyRecCnt; k++){
              if(*(rspan+k*optKEY.flds->cnt+j) == 1 ) break;
              rspanCnt++;
            }
            *(rspan+i*optKEY.flds->cnt+j) = rspanCnt;
          }
        } 
      }

      /*
      for(i=0; i<frk->keyRecCnt; i++){
        printf("%d: ",i);
        for(j=0; j<optKEY.flds->cnt; j++){
          printf("%d ",*(rspan+i*optKEY.flds->cnt+j));
        }
        printf("\n");
      }
      */

      /*出力*/
      mssSeekTopFRK(frk);
      recNo=0;
      while( EOF != mssReadFldRecFRK(frk) ){
        /* <tr> */
        mssWriteXmlStartTag(trTag,NULL,fpw);

        fldNo=0;
        for(i=0; i<frk->fldCnt; i++){
          tdTag=mssInitXmlTag("TD",NULL);

          /*-kで指定された項目なら*/
          if(*(optKEY.fldNo2optNo+i) != -1){
            /*TDが必要ならROWSPANを設定、必要なければcontinure*/
            if( *(rspan+recNo*optKEY.flds->cnt+fldNo) != 0){
              mssAddXmlTagAttributeInt(tdTag,"ROWSPAN",
                      *(rspan+recNo*optKEY.flds->cnt+fldNo), NULL);
              fldNo++;
            }else{
              fldNo++;
              mssFreeXmlTag(tdTag); /* 追加(2004/10/31) */
              continue;
            }
          }

          /*文字位置*/

          if(optRIT.set){
            if(*(optRIT.fldNo2optNo+i) != -1){
              mssAddXmlTagAttributeStr(tdTag,"ALIGN","right",NULL);
            }
          }
          if(optCNT.set){
            if(*(optCNT.fldNo2optNo+i) != -1){
              mssAddXmlTagAttributeStr(tdTag,"ALIGN","center",NULL);
            }
          }

          /*TDの出力*/
          mssWriteXmlStartTag(tdTag,NULL,fpw);
          mssWriteXmlContent(*(frk->pnt+i),NULL,fpw);
          mssWriteXmlEndTag(tdTag,NULL,fpw);
          mssFreeXmlTag(tdTag);
        }

        /* </TR> */
        mssWriteXmlEndTag(trTag,NULL,fpw);
        mssWriteRet(fpw);
        mssGV.outCnt++;
        recNo++;
      }
      mssFree(rspan);
    }

    /*oldRecの開放*/
    for(i=0; i<hdi->flds->cnt; i++){
      mssFree(*(oldRec+i));
    }
    mssFree(oldRec);
    mssFreeFRK(frk);

  /*キーがセットされていない*/
  }else{
    fr=mssInitFldRec(hdi->flds->cnt);
    while( EOF != mssReadFldRec(fpr,fr) ){
      mssGV.inCnt++;

      /* <TR> */
      mssWriteXmlStartTag(trTag,NULL,fpw);

      /* <TD> */
      for(i=0; i<fr->fldCnt; i++){
        tdTag=mssInitXmlTag("TD",NULL);

        /*文字位置*/
        if(optRIT.set){
          if(*(optRIT.fldNo2optNo+i) != -1){
            mssAddXmlTagAttributeStr(tdTag,"ALIGN","right",NULL);
          }
        }
        if(optCNT.set){
          if(*(optCNT.fldNo2optNo+i) != -1){
            mssAddXmlTagAttributeStr(tdTag,"ALIGN","center",NULL);
          }
        }
        /*TDの出力*/
        mssWriteXmlStartTag(tdTag,NULL,fpw);
        mssWriteXmlContent(*(fr->pnt+i),NULL,fpw);
        mssWriteXmlEndTag(tdTag,NULL,fpw);
        mssFreeXmlTag(tdTag);
      }

      /* </TR> */
      mssWriteXmlEndTag(trTag,NULL,fpw);
      mssWriteRet(fpw);

      mssGV.outCnt++;
    }
    mssFreeFldRec(fr);
  }

  /* </table> */
  mssWriteXmlEndTag(tableTag,NULL,fpw);
  mssWriteRet(fpw);

  /*-bが指定されていればヘッダー関連は出力しない*/
  if(!optTBL.set){

    /* </body> */
    mssWriteXmlEndTag(bodyTag,NULL,fpw);
    mssWriteRet(fpw);

    /* </html> */
    mssWriteXmlEndTag(htmlTag,NULL,fpw);
    mssWriteRet(fpw);
  }

  /*各種開放*/
  mssFreeXmlTag(trTag);
  mssFreeXmlTag(htmlTag);
  mssFreeXmlTag(headTag);
  mssFreeXmlTag(metaTag);
  mssFreeXmlTag(bodyTag);
  mssFreeXmlTag(tableTag);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);       /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ*/
  mssFreeFields(sf);      /* ソート項目構造体の領域開放(追加2004/10/31) */
  mssFreeHeader(hdi);     /*入力ヘッダ領域開放*/
  mssFreeOption(opt);     /*オプション領域開放*/
 /* 追加 2004/10/31 */
  if(optKEY.set){
    mssFreeOption(optInside);     /*オプション領域開放*/
  }
  mssShowEndMsg();        /*完了メッセージ*/
  mssEnd(mssExitSuccess); /*終了*/
  return(0); /* to avoid warning message*/
}
