/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成(2003/08/07)                                                 */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <xt2ppmHelp.h>
struct mssComHelp comHelp={
  "xt2ppm",       /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */                                      
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* X                                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLD optX={
    OFLD,   /* オプションタイプ                                             */
    "H",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    HOLT,   /* このオプションのタイトル(Helpで表示)                         */
    HOLC,   /* このオプションのコメント(Helpで表示)                         */
    HOLF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* Y                                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLD optY={
    OFLD,   /* オプションタイプ                                             */
    "V",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    HOLT,   /* このオプションのタイトル(Helpで表示)                         */
    HOLC,   /* このオプションのコメント(Helpで表示)                         */
    HOLF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* RGB                                                                        */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRGB={
    OFLD,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    3,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    RGBT,   /* このオプションのタイトル(Helpで表示)                         */
    RGBC,   /* このオプションのコメント(Helpで表示)                         */
    RGBF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 要素の最大値                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINT optMAX={
    OINT,   /* オプションタイプ                                             */
    "M",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    MAXT,   /* このオプションのタイトル(Helpで表示)                         */
    MAXC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* サイズ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptILS optSIZ={
    OILS,   /*オプションタイプ*/
    "S",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /*デフォルト(文字列で)                                          */
    2,      /*リスト要素の最大数                                            */
    1,      /*要素の最小値                                                  */
    3200,   /*要素の最大値                                                  */
    SIZT,   /*パラメータタイトル                                            */
    SIZC    /*パラメータコメント                                            */
};

/*----------------------------------------------------------------------------*/
/* NULL                                                                       */
/*----------------------------------------------------------------------------*/
  MssOptILS optNUL={
    OILS,   /*オプションタイプ*/
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "0,0,0",/*デフォルト(文字列で)                                          */
    3,      /*リスト要素の最大数                                            */
    0,      /*要素の最小値                                                  */
    INT_MAX,/*要素の最大値                                                  */
    NULT,   /*パラメータタイトル                                            */
    NULC    /*パラメータコメント                                            */
};

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                  */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optX,&optY,&optRGB,&optMAX,&optSIZ,&optNUL,
               &optINF,&optOTF,&optTMP,NULL};
    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRec *fr;  /*項目-行バッファ構造体*/
  struct mssFields *sf;  /*ソート項目構造体                  */
  int sorted;            /*ソート済チェック用                */

  int depthMax;
  int xSize,ySize;
  int x,y;
  int xv,yv,rv,gv,bv;
  int xNo,yNo,rNo,gNo,bNo;
  int readNext;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* ヘルプ                       */
  mssSetOption(opt,argc,argv);        /* コマンドオプションの設定     */

  if(optRGB.cnt!=3){
    mssShowErrMsg("-c must have three fields");
    mssEnd(mssErrorNoDefault);
  }

  if(optSIZ.cnt!=2){
    mssShowErrMsg("-M must have two values (X size,Y size)");
    mssEnd(mssErrorNoDefault);
  }

  if(optNUL.set){
    if(optNUL.cnt!=3){
      mssShowErrMsg("-n must have three values");
      mssEnd(mssErrorNoDefault);
    }
  }

  depthMax=optMAX.val;
  xSize=*(optSIZ.val+0);
  ySize=*(optSIZ.val+1);

  fpr=mssOpenFPR(optINF.str,4);       /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);             /* ヘッダの読み込み             */
  mssSetOptFld(&optX,   hdi);        /* -H 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optY,   hdi);        /* -V 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optRGB, hdi);        /* -c 項目をヘッダー項目に関連づける     */

  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optY.flds); /* -V 項目をソート項目としてセット    */
  mssAddFieldsByFields(sf,optX.flds); /* -H 項目をソート項目としてセット    */
  mssSetFldInfoSort(*(sf->fi+0),1,0,1); /*数値ソートとして*/
  mssSetFldInfoSort(*(sf->fi+1),2,0,1); /*数値ソートとして*/
  sorted=mssChkSorted(sf,hdi);        /* ソート済かチェック                 */

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,0,0);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if(sorted!=2){
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);
  }

  /*x,y,r,g,bの項目番号をセット*/
  xNo=MssFlds2num(optX  .flds,0);
  yNo=MssFlds2num(optY  .flds,0);
  rNo=MssFlds2num(optRGB.flds,0);
  gNo=MssFlds2num(optRGB.flds,1);
  bNo=MssFlds2num(optRGB.flds,2);

  /*ppm ヘッダー*/
  mssWriteStr("P3",fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;
  mssWriteInt(xSize,fpw);
  mssWriteStr(" ",fpw);
  mssWriteInt(ySize,fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;
  mssWriteInt(depthMax,fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;

  fr=mssInitFldRec(hdi->flds->cnt);

  readNext=1;
  xv=yv=rv=gv=bv=0; /* to avoid waring message */
  for(y=0; y<ySize; y++){
    for(x=0; x<xSize; x++){
      if(readNext){
        if( EOF != mssReadFldRec(fpr,fr) ){
          mssGV.inCnt++;
          xv=atoi( *(fr->pnt+xNo) );
          yv=atoi( *(fr->pnt+yNo) );
          rv=atoi( *(fr->pnt+rNo) );
          gv=atoi( *(fr->pnt+gNo) );
          bv=atoi( *(fr->pnt+bNo) );
        }else{
          xv=-1;
          yv=-1;
        }
      }
      if(x==xv && y==yv && rv<=depthMax && gv<=depthMax && bv<=depthMax){
        mssWriteInt(rv,fpw);
        mssWriteStr(" ",fpw);
        mssWriteInt(gv,fpw);
        mssWriteStr(" ",fpw);
        mssWriteInt(bv,fpw);
        mssWriteRet(fpw);
        mssGV.outCnt++;
        readNext=1;
      }else{
        mssWriteInt(*(optNUL.val+0),fpw);
        mssWriteStr(" ",fpw);
        mssWriteInt(*(optNUL.val+1),fpw);
        mssWriteStr(" ",fpw);
        mssWriteInt(*(optNUL.val+2),fpw);
        mssWriteRet(fpw);
        mssGV.outCnt++;
        readNext=0;
      }
    }
  }

  mssFreeFldRec(fr);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);        /*入力ファイルのクローズ*/
  mssCloseFPW(fpw);        /*出力ファイルのクローズ*/
  mssFreeHeader(hdi);      /*入力ヘッダ領域開放*/
  mssFreeOption(opt);      /*オプション領域開放*/
  mssShowEndMsg();         /*完了メッセージ*/
  mssEnd(mssExitSuccess);  /*終了*/
  return(0); /* to avoid warning message*/
}
