/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : まったく動作しなかったエラー修正(APIにて)                            */
/* 1.2 : title,commentがないときのエラー修正                                  */
/* 1.3 : -n オプション追加                                                    */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xt2xmlHelp.h>
struct mssComHelp comHelp={
  "xt2xml",       /* コマンド名       */                                    
  "1.3",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;
static int spcCnt=0;

void writeXmlKeyTag(struct mssFldRecDbl *frd, MssOptKEY *optKEY, struct mssFPW *fpw){

  int i,fn,flg;
  int wflg[256]; /*ネストの限界*/
  struct mssXmlTag *xmlTag;

  /*書き出すキーの番号を決定する*/
  if(frd->firstRead || frd->eof){
    for(i=0; i<optKEY->flds->cnt; i++) wflg[i]=1;
  }else{
    for(i=0; i<optKEY->flds->cnt; i++){
      fn=MssFlds2num(optKEY->flds,i);
      if( 0 != strcmp(*(frd->pnt[frd->new]+fn),*(frd->pnt[frd->old]+fn)) ){
        wflg[i]=1;
      }else{
        wflg[i]=0;
      }
    }
    flg=0;
    for(i=0; i<optKEY->flds->cnt; i++){
      if(wflg[i]) flg=1;
      if(flg)wflg[i]=1;
    }
  }

  /*終了タグの書き出し*/
  if(!frd->firstRead){
    for(i=optKEY->flds->cnt-1; i>=0; i--){
      if(wflg[i]){
        spcCnt--;
        xmlTag=mssInitXmlTag(MssFlds2name(optKEY->flds,i),NULL);
        mssWriteXmlIndent(spcCnt,fpw);
        mssWriteXmlEndTag(xmlTag,NULL,fpw);
        mssFreeXmlTag(xmlTag);
        mssWriteRet(fpw);
        mssGV.outCnt++;
      }
    }
  }

  /*開始タグの書き出し*/
  if(!frd->eof){
    for(i=0; i<optKEY->flds->cnt; i++){
      if(wflg[i]){
        fn=MssFlds2num(optKEY->flds,i);
        xmlTag=mssInitXmlTag(MssFlds2name(optKEY->flds,i),NULL);
        mssAddXmlTagAttributeStr(xmlTag, "id", *(frd->pnt[frd->new]+fn), NULL);
        mssWriteXmlIndent(spcCnt,fpw);
        mssWriteXmlStartTag(xmlTag,NULL,fpw);
        mssFreeXmlTag(xmlTag);
        mssWriteRet(fpw);
        mssGV.outCnt++;
        spcCnt++;
      }
    }
  }
}

void writeXmlFld(
  struct mssFldRecDbl *frd,
  MssOptKEY *optKEY,
  struct mssHeader *hd,
  struct mssXmlTag *lineTag,
  int nulFlg,
  struct mssFPW *fpw){

  int i,j;
  int wflg[256]; /*ネストの限界*/

  /* -k で指定した項目を除いた全項目番号を調べる */
  for(i=0; i<frd->fldCnt; i++){
    wflg[i]=1;
    for(j=0; j<optKEY->flds->cnt; j++){
      if(i==MssFlds2num(optKEY->flds,j)){
        wflg[i]=0;
        break;
      }
    }
  }

  /* 行タグが指定されていれば出力する */
  if(lineTag!=NULL){
    mssWriteXmlIndent(spcCnt,fpw);
    mssWriteXmlStartTag(lineTag,NULL,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    spcCnt++;
  }

  /* 項目タグ＆値を出力する */
  for(i=0; i<hd->flds->cnt; i++){
    if(wflg[i]){
      if(**(frd->pnt[frd->new]+i)==MssNullChr && !nulFlg)continue;
      mssWriteXmlTagStr(spcCnt, MssFlds2name(hd->flds, i),
                      *(frd->pnt[frd->new]+i), 1, NULL, fpw);
      mssGV.outCnt++;
    }
  }

  /* 行タグが指定されていればそのENDタグを出力する */
  if(lineTag!=NULL){
    spcCnt--;
    mssWriteXmlIndent(spcCnt,fpw);
    mssWriteXmlEndTag(lineTag,NULL,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 行タグ名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optLTG={
    OSTR,   /* オプションタイプ                                             */
    "L",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    50,     /* 文字列の最大長                                               */
    LTGT,   /* このオプションのタイトル(Helpで表示)                         */
    LTGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ルートタグ名                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optRTG={
    OSTR,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "root", /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    50,     /* 文字列の最大長                                               */
    RTGT,   /* このオプションのタイトル(Helpで表示)                         */
    RTGC    /* このオプションのコメント(Helpで表示)                         */
  };
     
/*----------------------------------------------------------------------------*/
/* NULL値出力フラグ                                                           */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNUL={
    OFLG,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    NULT,   /* このオプションのタイトル(Helpで表示)                         */
    NULC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optLTG,&optRTG,&optNUL,&optSEQ,
               &optINF,&optOTF,&optZIP,&optTMP,NULL};
    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFields *sf;  /*ソート項目構造体  */

  struct mssFldRecDbl *frd; /*項目-二行バッファ構造体*/

  int sorted;
  struct mssXmlTag *rootTag;
  struct mssXmlTag *lineTag;

  int lineNo;
  char *tmp;

/*------------------------------------------------------------------------------
パラメータ処理
------------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */

  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */
  
/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/
    
/*----------------------------------------------------------------------------*/
/*前処理                                                                      */
/*----------------------------------------------------------------------------*/
  lineTag=mssInitXmlTag(optLTG.str,NULL); /*行タグの設定*/

  /*グローバルタグの設定*/
  rootTag=mssInitXmlTagByOpt(optRTG.str,NULL);

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if( !optSEQ.set && !sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*xmlヘッダーの書き出し*/
  mssWriteXmlDeclaration(MssXmlDefVer,MssXmlDefEnc,fpw);
  mssGV.outCnt++;

  /*グローバルタグの書き出し*/
  mssWriteXmlStartTag(rootTag,NULL,fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;
  spcCnt++;

  /*タイトルの出力*/
  mssWriteXmlTagStr(spcCnt,"title",hdi->title,1,NULL,fpw);
  tmp=hdi->title;
  if(tmp!=NULL){
    while(*tmp!='\0') if(*tmp++=='\n') mssGV.outCnt++;
    mssGV.outCnt++;
  }

  /*コメントの出力*/
  mssWriteXmlTagStr(spcCnt,"comment",hdi->comment,1,NULL,fpw);
  if(tmp!=NULL){
    tmp=hdi->comment;
    while(*tmp!='\0') if(*tmp++=='\n') mssGV.outCnt++;
    mssGV.outCnt++;
  }

  frd=mssInitFRD(hdi->flds->cnt);
  lineNo=1;
  while(EOF!=mssReadFRD(fpr,frd)){
    mssGV.inCnt++;

    /*キーブレイク時の処理*/
    if(mssKeyBreak(frd, &optKEY)){
      writeXmlKeyTag(frd,&optKEY,fpw);
      if(frd->eof) break;
      lineNo=1;
    }

    /*最初の一行目はkeyBreakに引っかからないため*/
    if(frd->firstRead) writeXmlKeyTag(frd,&optKEY,fpw);

    /*通常行の処理(集計値の計算)*/
    mssAddXmlTagAttributeInt(lineTag,"no", lineNo,NULL);
    writeXmlFld(frd,&optKEY,hdi,lineTag,optNUL.set,fpw);
    lineNo++;
  }
  mssFreeFRD(frd);

  /*グローバルタグの書き出し*/
  spcCnt--;
  mssWriteXmlIndent(spcCnt,fpw);
  mssWriteXmlEndTag(rootTag,NULL,fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;

  mssFreeXmlTag(rootTag);
  mssFreeXmlTag(lineTag);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssCloseFPR(fpr);       /*入力ファイルのクローズ      */
  mssFreeFields(sf);      /*ソート項目構造体の領域開放  */
  mssFreeHeader(hdi);     /*入力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
