
/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : バケットの数値範囲を出力可能にする 2004/08/09                        */
/* 1.2 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtbucketHelp.h>
struct mssComHelp comHelp={
  "xtbucket",     /* コマンド名       */
  "1.2",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

#define MALLOC_CNT 1000

struct ctbl { /*count table*/
  double Val;
  unsigned long Cnt;
};

struct kTbl { /*k-cluster table*/
           double minVar;
  unsigned long prvNo;
  unsigned long from;
  unsigned long to;
};

struct rTbl { /*range table*/
  double from;
  double to;
};

static struct ctbl *cTable;       /*値とその件数の入った配列*/
static long         cTableCnt;    /*各cTable配列に登録されている件数*/
static long         cTableMaxCnt; /*各cTable配列に登録可能最大件数(malloc)*/

static struct kTbl   *kTable;
static struct rTbl   *rTable;
static unsigned long *sTable;
static struct rTbl   **rTables;

int cutCnt; /*実際の分割数*/

void insertValue(
  double value,	/*挿入する値*/
  int    start	/*挿入するスタート位置*/
                 ){
  int i;

  /*メモリオーバー時のリアロケーション（MALLOC_CNT行単位で増える） */
  if( cTableCnt >= cTableMaxCnt) {
    cTableMaxCnt+=MALLOC_CNT;
    cTable = (struct ctbl *)mssRealloc(cTable,
                             cTableMaxCnt * sizeof(struct ctbl),"xtbucket");
  }

  for(i=cTableCnt-1; i>=start; i--){
    (cTable+i+1)->Val = (cTable+i)->Val;
    (cTable+i+1)->Cnt = (cTable+i)->Cnt;
  }
  (cTable+start)->Val = value;
  (cTable+start)->Cnt = 1;
  cTableCnt++;
}

void setCntTable(char *str){
  /*バイナリサーチで探索するスタート位置とエンド位置とその中間値*/
  double value; /*テーブルにセットする値*/
  int start;
  int end;
  int try=0;

  if(MssIsNull(str))return;

  value=atof(str);
  /*探索中に同じ値がテーブルに見つかればカウントアップ*/
  /*見つからなければstartの位置にその値を挿入する*/
  start=0;
  end=cTableCnt-1;
  while(start<=end){
    try=(start+end)/2;
    if((cTable+try)->Val > value) {
      end=try-1;
    } else if((cTable+try)->Val < value) {
      start=try+1;
    } else {
      (cTable+try)->Cnt++;
      return;
    }
  }
  /*探索で見つからなければその値をテーブルに新規登録*/
  insertValue(value, start);
  return;
}


/*----------------------------------------------------------------------------*/
/*データのメモリへのセット
cTable[i]にセットされる iはf=で指定した項目番号を０から順番に割り振った番号
                        ex)f=2,5の場合 cTable[0]が項目2,cTable[1]が項目5
cTable[i]にmallocで確保された領域の先頭アドレスがセットされる。
領域は次の構造体のデータ構造を持つ
double Val;        値
unsigned long Cnt; その値の出現件数
*/
/*----------------------------------------------------------------------------*/
struct ctbl *setcTable(struct mssFldRecKey *frk,int fldNo){
/*  int i;*/

  cTableMaxCnt=MALLOC_CNT;
  cTable =NULL;
  cTable =(struct ctbl *)mssCalloc(cTableMaxCnt*sizeof(struct ctbl),"xtbucket");

  mssSeekTopFRK(frk);
  while( EOF != mssReadFldRecFRK(frk) ){
    /*項目の値をセットする*/
    setCntTable(*(frk->pnt+fldNo));
  }

/* デバッグリスト*/
/*
  for(i=0; i<cTableCnt; i++){
    printf("field[%d] %g - %ld\n",i,(cTable+i)->Val,(cTable+i)->Cnt);
  }
*/
  return(cTable);
}

/*cTableにおいて、startからendまでの件数二乗和を求める*/
/*分散最小化は件数の二乗和最小化に等しいので*/
double calVariance( int start, int end){
  double result=0;
  int i;
  for(i=start; i<=end; i++){
    result+=(cTable+i)->Cnt;
  }
  return(result*result);
}

/*----------------------------------------------------------------------------*/
/* 最適カットポイントを求める                                                 */
/*----------------------------------------------------------------------------*/
/*
Algorithm by N.Katoh
kTableとは、分散最小化を求めるためのワークテーブルで以下のような構造をとる
kTableからrTableが作られる。

分割数 値1    値2    値3    ... 値k
     1 a(1,1) a(1,2) a(1,3) ... a(1,k)
     2 a(2,1) a(2,2) a(2,3) ... a(2,k)
     3 a(3,1) a(3,2) a(3,3) ... a(3,k)
     .   .      .      .    ...   .
     .   .      .      .    ...   .
     j a(j,1) a(j,2) a(j,3) ... a(j,k)

a(j,k)には次の構造体を持つ
           double minVar;
  unsigned long prvNo;
  unsigned long from;
  unsigned long to;
minVarは、k個の値についてj分割したときの最小分散値
ただし、分散値は用いる必要はなく、単に件数の２乗値で代替することができる
prvNoは、j分割の場合に、最小分散値を持つようなj-1分割時のk。
from,toは、j分割の場合に、最小分散値を持つようなj番目の分割範囲。

分割数１の行は、実際にはcTableの件数の２乗和が入っている
*/
/*----------------------------------------------------------------------------*/
void calOptCutPoint(int cutNum){

  unsigned long   maxCnt;
           double minMinVar=0;
  unsigned long   minPrvNo=0;
  unsigned long   minFrom=0;
  unsigned long   minTo=0;
           double tmpVar;
  struct kTbl *tmpKtbl;
  int j,k,l;

  /* cTableCnt==0 ということは、値が全てNULL */
  if(cTableCnt==0){
    kTable=NULL;
    sTable=NULL;
    rTable=NULL;
    cutCnt=0;
    return;
  }

  maxCnt=cTableCnt; /* 値の種類数 */
  /*kTableメモリアロケーション*/
  kTable = (struct kTbl *)mssCalloc(
                          maxCnt*cutNum*sizeof(struct kTbl),"calOptCutP");
  /*sTableメモリアロケーション*/
  sTable = (unsigned long *)mssCalloc(
                          maxCnt*sizeof(unsigned long),"calOptCutP");
  /*rTableメモリアロケーション*/
  rTable = (struct rTbl *)mssCalloc(
                          cutNum*sizeof(struct rTbl),"calOptCutP");

  /*累積値を持っておく*/
  *sTable = cTable->Cnt;
  for(j=1; j<cTableCnt; j++){
    *(sTable+j) = *(sTable+j-1) + (cTable+j)->Cnt;
  }

  /*k=1の場合の計算*/
  for(j=0; j<cTableCnt; j++){
    (kTable+j)->minVar = calVariance(0,j);
    (kTable+j)->prvNo  = 0;
    (kTable+j)->from   = 0;
    (kTable+j)->to     = j;
  }

  /*値の種類数よりもカット数(k=の値)が大きければcutCntを調整*/
  cutCnt=cutNum;
  if(cutNum>cTableCnt)cutCnt=cTableCnt;

  /*k=2以上の場合の計算*/
  for(j=1; j<cutCnt; j++){ /*j=1で始まるのはk分割の1は配列の0に対応*/
    for(k=j; k<cTableCnt; k++){
      minMinVar=DBL_MAX;
      for(l=j-1; l<k; l++){
        tmpVar = (kTable+cTableCnt*(j-1)+l)->minVar +
                 (double)(sTable[k]-sTable[l])*(double)(sTable[k]-sTable[l]);
        /*ここの不等式を>にすれば、同じ件数の場合に後を多くする*/
        /*ここの不等式を>=にすれば、同じ件数の場合に前を多くする*/
        if( minMinVar > tmpVar ){
          minMinVar =tmpVar;
          minPrvNo  =l;
          minFrom   =l+1;
          minTo     =k;
        }
      } /*for l*/
      (kTable+cTableCnt*j+k)->minVar = minMinVar;
      (kTable+cTableCnt*j+k)->prvNo  = minPrvNo;
      (kTable+cTableCnt*j+k)->from   = minFrom;
      (kTable+cTableCnt*j+k)->to     = minTo;
    }/*for k*/
  } /*for j*/

  tmpKtbl=kTable+cutCnt*cTableCnt-1;
  for(j=cutCnt-1; j>=0; j--){
    //(rTable+cutNum+j)->from=(cTable+(tmpKtbl->from))->Val;
    //(rTable+cutNum+j)->to  =(cTable+(tmpKtbl->to  ))->Val;
    (rTable+j)->from=(cTable+(tmpKtbl->from))->Val;
    (rTable+j)->to  =(cTable+(tmpKtbl->to  ))->Val;
    tmpKtbl=kTable+(j-1)*cTableCnt+(tmpKtbl->prvNo);
  }
  /*fromとtoの中点をとる*/
  if(cutCnt>1) (rTable+0)->to=((rTable+0)->to+(rTable+1)->from)/2;
  for(j=1; j<cutCnt-1; j++){
    (rTable+j)->from=(rTable+j-1)->to;
    (rTable+j)->to  =((rTable+j)->to+(rTable+j+1)->from)/2;
  }
  (rTable+j)->from=(rTable+j-1)->to;

/* デバッグリスト*/
/*
  printf("---- kTable : cnt-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("%g ", (kTable+cTableCnt*j+k)->minVar);
    }
    printf("\n");
  }
  printf("---- kTable : from,to-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("(%ld,%ld) ", (kTable+cTableCnt*j+k)->from,
                           (kTable+cTableCnt*j+k)->to   );
    }
    printf("\n");
  }
  printf("---- kTable : prvNo-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("%ld ", (kTable+cTableCnt*j+k)->prvNo);
    }
    printf("\n");
  }
  printf("---- rTable : prvNo-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%g - %g\n",
    (rTable+j)->from, (rTable+j)->to);
    //(rTable+cutNum+j)->from, (rTable+cutNum+j)->to);
  }
  printf("=============\n");
*/
}

/*
===============================================================================
Main Function
===============================================================================
*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 分割数                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optNUM={
    OINT,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    2,      /* 最小値                                                       */
    255,    /* 最大値                                                       */
    NUMT,   /* このオプションのタイトル(Helpで表示)                         */
    NUMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力書式                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSEL optFMT={
    OSEL,    /* オプションタイプ                                             */
    "F",     /* キーワード(複数文字は不可)                                   */
    0,       /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "0",     /* デフォルト(文字列にて)                                       */
    "0,1,2",
            /* 指定可能な値リスト                                           */
    FMTT,   /* このオプションのタイトル(Helpで表示)                         */
    FMTC,   /* このオプションのコメント(Helpで表示)                         */
    FMTS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* バケット計算方法                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSEL optTyp={
    OSEL,    /* オプションタイプ                                             */
    "c",     /* キーワード(複数文字は不可)                                   */
    0,       /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "cnt",   /* デフォルト(文字列にて)                                       */
    "cnt,rng",
            /* 指定可能な値リスト                                           */
    TYPT,   /* このオプションのタイトル(Helpで表示)                         */
    TYPC,   /* このオプションのコメント(Helpで表示)                         */
    TYPS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 番号逆順フラグ                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* バケット範囲出力ファイル                                                   */
/*----------------------------------------------------------------------------*/
  MssOptOTF optRNG={
    OOTF,   /* オプションタイプ                                             */
    "O",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    RNGT,   /* このオプションのタイトル(Helpで表示)                         */
    RNGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optNUM,&optFMT,&optTyp,&optREV,
               &optINF,&optRNG,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;     /* 入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo;     /* 出力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo2;    /* 出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr;     /* 入力ファイル構造体                */
  struct mssFPW       *fpw;     /* 出力ファイル構造体                */
  struct mssFPW       *fpw2;    /* 範囲出力ファイル構造体            */
  struct mssFldRecKey *frk=NULL;/* キーバッファ構造体                */
  struct mssFields    *sf;      /* ソート項目構造体                  */
  int sorted;                   /*ソート済チェック用                 */

  char *vstr;
  double val;
  int num;      /*出力するバケット番号*/
  int *cutCnts; /*項目毎の実際のバケット数*/
  char  *bufStr;
  double bufNum;
  double *max;
  double *min;
  double rng;
  int i,j,k,l;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */
  
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/                              
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*新項目名を追加する*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);                  
    
  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!sorted){
    mssSetFieldsSort(hdo->flds,sf);
  } 
    
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);                                    
  mssWriteHeader(hdo, fpw);

  /*範囲出力ファイルオープン+ヘッダーの出力*/

  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  if(optRNG.set){
    hdo2=mssInitCpyHeader(hdi);

    for(l=0; l<optKEY.flds->cnt; l++){
      mssAddFieldsByStr(hdo2->flds,MssFlds2name(optKEY.flds,l)); /*key*/
    }
    mssAddFieldsByStr(hdo2->flds,"fieldName"); /*fieldName*/
    mssAddFieldsByStr(hdo2->flds,"bucketNo");  /*bucketNo*/
    mssAddFieldsByStr(hdo2->flds,"rangeFrom"); /*rangeFrom*/
    mssAddFieldsByStr(hdo2->flds,"rangeTo");   /*rangeTo*/

    fpw2=mssOpenFPW(optRNG.str,optZIP.set,0);
    mssWriteHeader(hdo2, fpw2);
  }else{
    hdo2=NULL;
    fpw2=NULL;
  }
  
/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/            
  if(!sorted){
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);
  }

  rTables=mssMalloc(optFLD.flds->cnt*sizeof(struct rTbl *),"xtbucket");
  cutCnts=mssMalloc(optFLD.flds->cnt*sizeof(int),"xtbucket");

  /*FRK構造体の初期化*/
  frk=mssInitFRK(hdi->flds->cnt, &optKEY,optTMP.str);

  while(1){ /*loop by key*/
    /*データ読み込み*/
    if(EOF==mssReadFRK(fpr,frk)) break;

    /*範囲均等化分割(rng)*/
    if( strcmp("rng",optTyp.str)==0 ){
      max=mssMalloc(optFLD.flds->cnt*sizeof(double),"rng1");
      min=mssMalloc(optFLD.flds->cnt*sizeof(double),"rng2");
      for(i=0; i<optFLD.flds->cnt; i++){
        *(max+i)=-DBL_MAX;
        *(min+i)= DBL_MAX;
      }

      mssSeekTopFRK(frk);
      while( EOF != mssReadFldRecFRK(frk) ){
        /*最大値、最小値をセットする*/
        for(i=0; i<optFLD.flds->cnt; i++){
          bufStr=*(frk->pnt+MssFlds2num(optFLD.flds,i));
          if(MssIsNull(bufStr)) continue;
          bufNum=atof(bufStr);
          if( *(max+i)<bufNum ) *(max+i)=bufNum;
          if( *(min+i)>bufNum ) *(min+i)=bufNum;
        }
      }

      /*rTableメモリアロケーション*/
      for(i=0; i<optFLD.flds->cnt; i++){
        if( *(max+i)==DBL_MAX || *(min+i)==-DBL_MAX ){
          *(rTables+i)=NULL;
          *(cutCnts+i)=0; /*カット数のセット*/
        }else if( *(max+i) == *(min+i) ){
          *(rTables+i) = (struct rTbl *)mssMalloc(
                          1*sizeof(struct rTbl),"calOptCutP");
          ((*(rTables+i))+0)->from=*(min+i);
          ((*(rTables+i))+0)->to  =*(max+i);
          *(cutCnts+i)=1; /*カット数のセット*/
        }else{
          *(rTables+i) = (struct rTbl *)mssMalloc(
                          optNUM.val*sizeof(struct rTbl),"calOptCutP");
          rng=( *(max+i) - *(min+i) )/(double)optNUM.val;
          for(j=0; j<optNUM.val; j++){
                                 (*(rTables+i)+j)->from=*(min+i)+rng*j;
            if(j==optNUM.val-1)  (*(rTables+i)+j)->to  =*(max+i);
            else                 (*(rTables+i)+j)->to  =*(min+i)+rng*(j+1);
          }
          *(cutCnts+i)=optNUM.val; /*カット数のセット*/
        }
      }
      mssFree(max);
      mssFree(min);

    /*件数均等化分割(cnt)*/
    }else{
      for(i=0; i<optFLD.flds->cnt; i++){
        /*データをcTableにセット*/
        cTableCnt=0;
        cTableMaxCnt=0;
        cTable=setcTable(frk,MssFlds2num(optFLD.flds,i));

        /*最適カットポイントを求める*/
        calOptCutPoint(optNUM.val);

        /*カット数のセット*/
        *(cutCnts+i)=cutCnt;

        /*rTableの保存*/
        *(rTables+i)=rTable;

        /*領域開放*/
        mssFree(cTable);
        mssFree(kTable);
        mssFree(sTable);
      }
    }

    /*範囲ファイル出力*/
    if(optRNG.set){
      for(i=0; i<optFLD.flds->cnt; i++){
        for(k=0; k<*(cutCnts+i); k++){
          if(optREV.set)num=*(cutCnts+i)-k-1;
          else          num=k;
          mssSeekTopFRK(frk);
          mssReadFldRecFRK(frk);
          for(l=0; l<optKEY.flds->cnt; l++){
            mssWriteStr(*(frk->pnt+MssFlds2num(optKEY.flds,l)),fpw2);
            mssWriteDlm(fpw2);
          }
          mssWriteStr(MssFlds2name(optFLD.flds,i),fpw2);
          mssWriteDlm(fpw2);
          mssWriteInt(num+1,fpw2);
          mssWriteDlm(fpw2);
	  if(*(cutCnts+i)>0) mssWriteDbl((*(rTables+i)+k)->from,fpw2);
	  else               mssWriteNull(fpw2);
          mssWriteDlm(fpw2);
          if(*(cutCnts+i)>0) mssWriteDbl((*(rTables+i)+k)->to  ,fpw2);
	  else               mssWriteNull(fpw2);
          mssWriteRet(fpw2);
        }
      }
    }

    /*出力*/
    mssSeekTopFRK(frk);
    while( EOF != mssReadFldRecFRK(frk) ){
      mssGV.inCnt++;
      mssWriteFld(frk->pnt,frk->fldCnt,"",fpw);
      mssGV.outCnt++;

      for(i=0; i<optFLD.flds->cnt; i++){
        mssWriteDlm(fpw);
        vstr=*(frk->pnt+MssFlds2num(optFLD.flds,i));
        if(MssIsNull(vstr) || *(cutCnts+i) == 0){
          mssWriteNull(fpw);
        }else{
          val=atof(vstr);
          for(k=0; k<*(cutCnts+i)-1; k++){
            if( val>=(*(rTables+i)+k)->from && val<(*(rTables+i)+k)->to ){
              break;
            }
          }

          if(optREV.set)num=*(cutCnts+i)-k-1;
          else          num=k;
          if(*optFMT.str=='0'){
            mssWriteInt(num+1,fpw);
          }else if(*optFMT.str=='1'){
            mssWriteDbl((*(rTables+i)+k)->from,fpw);
            mssWriteStr("_",fpw);
            mssWriteDbl((*(rTables+i)+k)->to  ,fpw);
          }else{
            mssWriteInt(num+1,fpw);
            mssWriteStr(":",fpw);
            mssWriteDbl((*(rTables+i)+k)->from,fpw);
            mssWriteStr("_",fpw);
            mssWriteDbl((*(rTables+i)+k)->to  ,fpw);
          }
        }
      }
      mssWriteRet(fpw);
    }
    for(i=0; i<optFLD.flds->cnt; i++){
      mssFree(*(rTables+i));
    }
  }

  /*領域開放*/
  mssFree(rTables);
  mssFree(cutCnts);
  mssFreeFRK(frk);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssWriteFooter(fpw2);   /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssCloseFPW(fpw2);      /* 出力ファイルのクローズ     */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeHeader(hdo2);    /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
