/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/
  
#include <musashi.h>
#include <sys/time.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <unistd.h>

#include <xtcalenderHelp.h>
struct mssComHelp comHelp={
  "xtcalender",   /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */                                    
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */ 
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};  

extern struct mssGlobalVariables mssGV;

void writeYear(int y, struct mssFPW *fpw){
  mssWriteInt(1900+y,fpw);
}

void writeMonth(int m, struct mssFPW *fpw){
  if(1+m<10){
    mssWriteInt(0,fpw);
  }
  mssWriteInt(1+m ,fpw);
}

void writeDay(int d, struct mssFPW *fpw){
  if(d<10){
    mssWriteInt(0,fpw);
  }
  mssWriteInt(d ,fpw);
}

void writeAllDate(struct tm *time, struct mssFPW *fpw){
  writeYear(time->tm_year,fpw);
  writeMonth(time->tm_mon,fpw);
  writeDay(time->tm_mday,fpw);
}

time_t getTimeByYMD(int y, int m, int d){
  struct tm cTime;

  cTime.tm_year=y ;
  cTime.tm_mon =m;
  cTime.tm_mday=d;
  cTime.tm_hour=11;
  cTime.tm_min=0;
  cTime.tm_sec=1;
  cTime.tm_isdst=-1;
  return(mktime(&cTime));
}

void writeBeginPad(time_t t,int cYear,int cMonth,int mon,struct mssFPW *fpw){
  struct tm *cTime;
  int days;
  int i;

  cTime=localtime(&t);
  if(mon) days=cTime->tm_wday-1;
  else    days=cTime->tm_wday-0;

  t-=86400*days;
  for(i=0; i<days; i++){
    cTime=localtime(&t);
    writeYear(cYear,fpw);
    mssWriteDlm(fpw);
    writeMonth(cMonth,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
}

void writeEndPad(time_t t,int cYear,int cMonth,int mon,struct mssFPW *fpw){
  struct tm *cTime;
  int days;
  int i;

  cTime=localtime(&t);
  if(mon){
    if(cTime->tm_wday==0)      days=1;
    else if(cTime->tm_wday==1) days=0;
    else                       days=8-cTime->tm_wday;
  }else{
    if(cTime->tm_wday==0) days=0;
    else                  days=7-cTime->tm_wday;
  }

  for(i=0; i<days; i++){
    cTime=localtime(&t);
    writeYear(cYear,fpw);
    mssWriteDlm(fpw);
    writeMonth(cMonth,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
}

/*----------------------------------------------------------------------------*/
/* パディングを考慮して１ヵ月のカレンダーを出力                               */
/*----------------------------------------------------------------------------*/
void writeOneMonth(int cYear,int cMonth,int pad, int mon, struct mssFPW *fpw){
  time_t t;
  struct tm *cTime;
  t=getTimeByYMD(cYear,cMonth,1);

  if(pad) writeBeginPad(t,cYear,cMonth,mon,fpw);
  while(1){
    cTime=localtime(&t);
    if(cTime->tm_mon!=cMonth) break;

    writeYear(cTime->tm_year,fpw);
    mssWriteDlm(fpw);
    writeMonth(cTime->tm_mon,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
  if(pad) writeEndPad(t,cYear,cMonth,mon,fpw);
}
 
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 月の範囲(200201:200212                                                     */
/*----------------------------------------------------------------------------*/
  MssOptRNG optRNG={
    ORNG,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列として指定する)                             */
    1,      /* カンマで区切られる要素数の最大値                             */
    190001, /* 値の最小値                                                   */
    299912, /* 値の最大値                                                   */
    RNGT,   /* このオプションのタイトル(Helpで表示)                         */
    RNGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 前後月のパディングを行う                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optPAD={
    OFLG,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    PADT,   /* このオプションのタイトル(Helpで表示)                         */
    PADC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 月曜日を週の最初の曜日にする(-pといっしょに利用)                           */
/*----------------------------------------------------------------------------*/
  MssOptFLG optMON={
    OFLG,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    MONT,   /* このオプションのタイトル(Helpで表示)                         */
    MONC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optRNG,&optMON,&optPAD,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  
  char *dummyFldName[]={"year","month","date"};
  int   dummyFldCnt=3;
  char  dummyFName[MssFileNameMaxLen];

  int fYear,cYear,tYear,fMonth,cMonth,tMonth;
  time_t t;
  struct tm *cTime;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
/*mssShowOption(opt);*/

  if(optMON.set && !optPAD.set){
    mssShowErrMsg("can not specify -m without -p");
    mssEnd(mssErrorNoDefault);
  }

  if(optRNG.set){
    fYear =*optRNG.from/100-1900;
    tYear =*optRNG.to  /100-1900;
    fMonth=*optRNG.from%100-1;
    tMonth=*optRNG.to  %100-1;
    if(fMonth>11 || fMonth<0 || tMonth>11 || tMonth<0){
      mssShowErrMsg("invalid month");
      mssEnd(mssErrorNoDefault);
    }
    /*始点と終点の大小関係をチェック*/
    if(fYear>tYear || (fYear==tYear && fMonth>tMonth)){
      mssShowErrMsg("start month must be less than or eaqual to end month");
      mssEnd(mssErrorNoDefault);
    }

    t=getTimeByYMD(fYear,fMonth,1);

  }else{
    t=time(NULL);
    cTime=localtime(&t);
    fYear =tYear =cTime->tm_year;
    fMonth=tMonth=cTime->tm_mon;
    t=getTimeByYMD(fYear,fMonth,1);
  }

  /*ダミー入力データのファイル名*/
  sprintf(dummyFName,"%s/xt##%d-calender",optTMP.str,(int)getpid());

  /*ブランクのxmlTableファイルを作成し、入力ファイルとする*/
  mssCreateBlankXtFile(dummyFldName,dummyFldCnt,dummyFName);

  /*usedTempFileFlgをONにし、終了時に時動的にファイルは削除される。*/
  mssGV.usedTempFileFlg=1;

  fpr=mssOpenFPR(dummyFName,4);   /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);         /* ヘッダの読み込み             */

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン*/
/*----------------------------------------------------------------------------*/
/*tm_wday:0->日曜*/

  cYear =fYear;
  cMonth=fMonth;
  while(1){

    writeOneMonth(cYear,cMonth,optPAD.set,optMON.set,fpw);

    cMonth++;
    if(cMonth>11){
      cYear++;
      cMonth=0;
    }
    if(cYear>tYear) break;
    if(cYear==tYear && cMonth>tMonth) break;
  }
  mssGV.inCnt=0;

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理*/
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssCloseFPR(fpr);       /*入力ファイルのクローズ      */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
