/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.2 : wild cardを持たないファイルの指定時、なければエラー終了 2004/07/30   */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtcatHelp.h>
struct mssComHelp comHelp={
  "xtcat",        /* コマンド名       */                                    
  "1.2",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int diffHeaderName(struct mssHeader *hdi,struct mssHeader *hdn){
  int i;

  /*項目数が異なれば*/
  if(hdi->flds->cnt != hdn->flds->cnt) return(1);

  /*項目名が異なれば*/
  for(i=0; i<hdi->flds->cnt; i++){
    if( 0!=strcmp(MssFlds2name(hdi->flds,i),MssFlds2name(hdn->flds,i)) ){
      return(1);
    }
  }
  return(0);
}

void setFldConv(int conv[MssFieldMaxCnt],struct mssHeader *hdi,struct mssHeader *hdn){
  int i,j;
  int ino,jno;

  /*初期化：-1は対応する項目がないという意味*/
  for(i=0; i<hdi->flds->cnt; i++)conv[i]=-1;

  for(i=0; i<hdi->flds->cnt; i++){
    ino=MssFlds2num(hdi->flds,i);
    for(j=0; j<hdn->flds->cnt; j++){
      jno=MssFlds2num(hdn->flds,j);
      if( 0==strcmp(MssFlds2name(hdi->flds,i),MssFlds2name(hdn->flds,j)) ){
        conv[ino]=jno;
      }
    }
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 項目数のみチェックするフラグ                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLG optCNT={
    OFLG,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    CNTT,   /* このオプションのタイトル(Helpで表示)                         */
    CNTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 同一項目名のみcatするフラグ                                                */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNAM={
    OFLG,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    NAMT,   /* このオプションのタイトル(Helpで表示)                         */
    NAMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    256,    /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };


/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optCNT,&optNAM,&optINF,&optOTF,&optZIP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*一つめの入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdn; /*二つめ以降の入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpi;
  struct mssFPR    *fpn;
  struct mssFPW    *fpw;
  struct mssFldRec *fri =NULL;
  struct mssFldRec *frn =NULL;

  int i,j;
  int conv[MssFieldMaxCnt];

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);      /* シグナル処理などの初期化     */
  mssHelpDoc(opt,&comHelp,argc,argv);    /* ヘルプ                       */
  mssSetOption(opt,argc,argv);      /* コマンドオプションの設定     */
/*prnOption(opt);*/

  if( (optCNT.set+optNAM.set) >1 ){
    mssShowErrMsg("must choose one from -c,-n");
    mssEnd(mssErrorNoDefault);
  }

  fpi=mssOpenFPR(*(optINF.strList+0),4); /*一つめのファイルオープン*/
  hdi=mssReadHeader(fpi);                /*項目名情報の読み込み*/
/*prnHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*入力ヘッダーを出力ヘッダーにコピー*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*ソート順序は崩れるため、ソート情報をクリア*/
  mssClearFieldsSort(hdo->flds);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  fri =mssInitFldRec(hdi->flds->cnt);
  while( EOF!=mssReadFldRec(fpi,fri) ){
    mssGV.inCnt++;
    mssWriteFld(fri->pnt,fri->fldCnt,"\n",fpw);
    mssGV.outCnt++;
  }
  mssFreeFldRec(fri);
  mssCloseFPR(fpi);/*入力ファイルのクローズ*/

  for(i=1; i<optINF.cnt; i++){
    fpn=mssOpenFPR(*(optINF.strList+i),4); /*ファイルオープン*/
    hdn=mssReadHeader(fpn);                /*項目名情報の読み込み*/

    /*項目数チェックの場合*/
    if(optCNT.set){
      if(hdi->flds->cnt!=hdn->flds->cnt){
        mssShowErrMsg("different number of fields on header : %s",
                       *(optINF.strList+i));
        mssEnd(mssErrorNoDefault);
      }
      frn =mssInitFldRec(hdn->flds->cnt);
      while( EOF!=mssReadFldRec(fpn,frn) ){
        mssGV.inCnt++;
        mssWriteFld(frn->pnt,frn->fldCnt,"\n",fpw);
        mssGV.outCnt++;
      }

    /*項目名チェックの場合*/
    }else if(optNAM.set){
      setFldConv(conv,hdi,hdn);
      frn =mssInitFldRec(hdn->flds->cnt);
      while( EOF!=mssReadFldRec(fpn,frn) ){
        mssGV.inCnt++;
        for(j=0; j<hdi->flds->cnt-1; j++){
          if(conv[j]==-1) mssWriteNull(fpw);
          else            mssWriteStr(*(frn->pnt+conv[j]),fpw);
          mssWriteDlm(fpw);
        }
        if(conv[j]==-1) mssWriteNull(fpw);
        else            mssWriteStr(*(frn->pnt+conv[j]),fpw);
        mssWriteRet(fpw);
        mssGV.outCnt++;
      }

    /*デフォルト*/
    }else{
      if(diffHeaderName(hdi,hdn)){
        mssShowErrMsg("different type of header detected : %s",
                                                      *(optINF.strList+i));
        mssEnd(mssErrorNoDefault);
      }
      frn =mssInitFldRec(hdn->flds->cnt);
      while( EOF!=mssReadFldRec(fpn,frn) ){
        mssGV.inCnt++;
        mssWriteFld(frn->pnt,frn->fldCnt,"\n",fpw);
        mssGV.outCnt++;
      }
    }

    mssCloseFPR(fpn);/*入力ファイルのクローズ*/
    mssFreeFldRec(frn);
    mssFreeHeader(hdn);
  }

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);    /*フッターの出力           */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ   */
  mssFreeHeader(hdi);     /*入力ヘッダ領域開放       */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放       */
  mssFreeOption(opt);     /*オプション領域開放       */
  mssShowEndMsg();        /*完了メッセージ           */
  mssEnd(mssExitSuccess); /*終了                     */
  return(0);              /* to avoid warning message*/
}
