
/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtchgnumHelp.h>
struct mssComHelp comHelp={
  "xtchgnum",     /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

static MssOptDLS *LST;
static MssOptSLS *VAL;
static MssOptFLG *REQ;
static MssOptFLG *FRP;
static MssOptSTR *OTH;
static char  **DEF;

/*----------------------------------------------------------------------------*/
/* -vが指定されなかったとき、デフォルトの置換文字リストを作成する             */
/*----------------------------------------------------------------------------*/
char **getDefRep(MssOptDLS *optVAL){
  int i;
  char *dblStr;
  char **defRep;
  char rngStr[MssFieldMaxLen];

  defRep=mssMalloc(sizeof(char *)*optVAL->cnt,"getDefRep");
  for(i=0;i<optVAL->cnt-1; i++){
    rngStr[0]='\0';
  
    /*fromの文字列*/
    if( *(optVAL->val+i) != -DBL_MAX ){
      dblStr=mssFtoA(*(optVAL->val+i));
      strcat(rngStr,dblStr);
      mssFree(dblStr);
    }
    
    /*範囲文字*/
    strcat(rngStr,"_");

    /*toの文字列*/
    if( *(optVAL->val+i+1) != DBL_MAX ){
      dblStr=mssFtoA(*(optVAL->val+i+1));
      strcat(rngStr,dblStr);
      mssFree(dblStr);
    }
    
    /*領域確保してrange->tbl構造体にセット*/
    *(defRep+i)=mssMalloc(sizeof(char)*(strlen(rngStr)+1),"getDefRep");
    strcpy(*(defRep+i),rngStr);
  } 

  return(defRep);
}

/*----------------------------------------------------------------------------*/
/*範囲にマッチする文字列を返す                                                */
/* 2分探索法にかえる予定                                                      */
/*----------------------------------------------------------------------------*/
char *getRepStr(char *str){
  double num;
  int match;
  int i;

  if(MssIsNull(str)) return(MssNullStr);

  match=-1;
  num=atof(str);
  for(i=0; i<LST->cnt; i++){
    if(REQ->set){
      if(num>*(LST->val+i)){
        match=i;
        continue;
      }else{
        break;
      }
    }else{
      if(num>=*(LST->val+i)){
        match=i;
        continue;
      }else{
        break;
      }
    }
  }

  /*最後の条件にマッチしたということは、範囲外ということ*/
  if(match>=LST->cnt-1){
      match=-1;
  }

  if(match==-1){
         if(OTH->set) return(OTH->str);   /*unmatch & OTH指定 */
    else if(FRP->set) return(str);        /*unmatch & FRP指定 */
    else              return(MssNullStr); /*else              */
  }else{
    if(VAL->set){
      return(*(VAL->strList+match));
    }else{
      return(*(DEF+match));
    }
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 数値範囲リスト                                                             */
/*----------------------------------------------------------------------------*/
  MssOptDLS optLST={
    ODLS,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列として指定する)                             */
    50,     /* カンマで区切る要素の最大数                                   */
   -DBL_MAX,/* 値の最小値                                                   */
    DBL_MAX,/* 値の最大値                                                   */
    LSTT,   /* このオプションのタイトル(Helpで表示)                         */
    LSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 置換文字列リスト                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSLS optVAL={
    OSLS,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    49,     /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldMaxLen,/* 各要素の文字列長の最大値                              */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    VALT,   /* このオプションのタイトル(Helpで表示)                         */
    VALC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 数値範囲外の置換文字列                                                     */
/*----------------------------------------------------------------------------*/
  MssOptSTR optOTH={
    OSTR,   /* オプションタイプ                                             */
    "O",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    MssFieldMaxLen,/* 文字列の最大長                                        */
    OTHT,   /* このオプションのタイトル(Helpで表示)                         */
    OTHC    /* このオプションのコメント(Helpで表示)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* 数値範囲外の時置換しない                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optFRP={
    OFLG,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    FRPT,   /* このオプションのタイトル(Helpで表示)                         */
    FRPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新しい項目として出力する                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNEW={
    OFLG,   /* オプションタイプ                                             */
    "A",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    NEWT,   /* このオプションのタイトル(Helpで表示)                         */
    NEWC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 数値範囲の条件を〜より大きく〜以下とする                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREQ={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REQT,   /* このオプションのタイトル(Helpで表示)                         */
    REQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optLST,&optVAL,&optOTH,&optFRP,&optNEW,&optREQ,
               &optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体                */
  struct mssFPW    *fpw; /*出力ファイル構造体                */
  struct mssFldRec *fr;  /*項目-行バッファ構造体             */

  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/
    
  if(optFRP.set && optOTH.set){
    mssShowErrMsg("-O and -F are exclusive");
    mssEnd(mssErrorNoDefault);
  }

  if(optVAL.set && (optVAL.cnt != optLST.cnt-1)){
    mssShowErrMsg("the number of elements on -v must be %d",optLST.cnt-1);
    mssEnd(mssErrorNoDefault);
  }

  /* -v(置換文字列)の指定がなければ、数値範囲を置換文字列とする) */
  if(!optVAL.set){
    DEF=getDefRep(&optLST);
  }

  LST=&optLST;
  VAL=&optVAL;
  REQ=&optREQ;
  FRP=&optFRP;
  OTH=&optOTH;

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi); 
  
  /*入力ヘッダの全項目を追加*/
  
  /*新項目名を追加する*/
  if(optNEW.set){
    mssAddFieldsByFields(hdo->flds,hdi->flds);            
    mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*-fで指定された項目は-fから、その他は入力ヘッダから項目を追加する*/
  }else{
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    /*新項目追加の場合*/
    if(optNEW.set){
      mssWriteFld(fr->pnt,fr->fldCnt,"",fpw);
      for(i=0; i<optFLD.flds->cnt; i++){
        mssWriteDlm(fpw);
        mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(optFLD.flds,i))),fpw);
      }
      mssWriteRet(fpw);

    /*新項目置換の場合*/
    }else{
      for(i=0; i<hdi->flds->cnt-1; i++){
        if( *(optFLD.fldNo2optNo+i)==-1){
          mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
        }else{
          mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(hdi->flds,i))),fpw);
        }
        mssWriteDlm(fpw);
      }
      if( *(optFLD.fldNo2optNo+i)==-1){
        mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
      }else{
        mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(hdi->flds,i))),fpw);
      }
      mssWriteRet(fpw);
    }
    mssGV.outCnt++;
  }

  /*領域開放*/
  mssFreeFldRec(fr);
  if(!optVAL.set){
    for(i=0;i<optLST.cnt-1; i++) mssFree(*(DEF+i));
    mssFree(DEF);
  }

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);     /* フッターの出力             */
  mssCloseFPR(fpr);        /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);        /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);      /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);      /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);      /* オプション領域開放         */
  mssShowEndMsg();         /* 完了メッセージ             */
  mssEnd(mssExitSuccess);  /* 終了                       */
  return(0);               /* to avoid warning message   */
}
