/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : ソートされていなければうまく結果がでないバグ修正 2004/07/30          */
/* 1.2 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>

#include <xtcombiHelp.h>
struct mssComHelp comHelp={
  "xtcombi",      /* コマンド名       */
  "1.2",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */                                      
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */                                    
};  
    
extern struct mssGlobalVariables mssGV;

static char **FldStr;
static int    FldCnt;
static struct mssStrList *StrList;
static int Line; int K;     /* (nCk) Line Combination K */
static struct mssFPW *Fpw;
static int Permutation;
static int  CombiList[MssFieldMaxCnt];

/*順列の出力*/
/*アルゴリズム事典 pp.119-120 */
void perm(int i){
  int j,k;
  if(i>0){
    perm(i-1);
    for(j=i-1; j>=0; j--){
      mssSwapInt(&CombiList[i],&CombiList[j]);
      perm(i-1);
      mssSwapInt(&CombiList[i],&CombiList[j]);
    }
  }else{
    mssWriteFld(FldStr,FldCnt,"",Fpw);
    for(k=0; k<K; k++){
      mssWriteDlm(Fpw);
      mssWriteStr(mssGetStrList(StrList,CombiList[k]),Fpw);
    }
    mssWriteRet(Fpw);
    mssGV.outCnt++;
  }
}

void combi( int from, int depth){

  int i;

  if(depth>=K){
    /*順列出力*/
    if(Permutation){
      perm(K-1);
    /*組合出力*/
    }else{
      mssWriteFld(FldStr,FldCnt,"",Fpw);
      for(i=0; i<depth; i++){
        mssWriteDlm(Fpw);
        mssWriteStr(mssGetStrList(StrList,CombiList[i]),Fpw);
      }
      mssWriteRet(Fpw);
      mssGV.outCnt++;
    }
    return;
  }

  /*再帰処理*/
  for(i=from; i<Line; i++){
    CombiList[depth]=i;
    combi(i+1,depth+1);
  }
}

void writeCombi(
  struct mssFldRecDbl *frd,   /*項目-二行バッファ構造体*/
  struct mssStrList *strList, /* 各行の値リスト        */
  int k,                   /*組み合せ数             */
  int permutation,         /*順列フラグ             */
  struct mssFPW *fpw){

  if(k>strList->cnt) return; /* nCk で k>nなら何も出力しない*/

  /*グローバル変数のセット*/
  FldStr=frd->pnt[frd->old];
  FldCnt=frd->fldCnt;
  StrList=strList;
  Line=strList->cnt;
  K=k;
  Fpw=fpw;
  Permutation=permutation;

  /*再帰処理*/
  combi(0,0);

}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 組合せ数                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optNUM={
    OINT,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    2,      /* 最小値                                                       */
    50,     /* 最大値                                                       */
    NUMT,   /* このオプションのタイトル(Helpで表示)                         */
    NUMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 順列                                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLG optPER={
    OFLG,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    PERT,   /* このオプションのタイトル(Helpで表示)                         */
    PERC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    2,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    50,     /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldNameMaxLen,/* 各要素の文字列長の最大値                          */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optNUM,&optPER,&optFNM,&optSEQ,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRecDbl *frd; /*項目-二行バッファ構造体           */
  struct mssFields    *sf;  /*ソート項目構造体                  */
  int sorted;               /*ソート済チェック用                */

  struct mssStrList *strList;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */
        
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sf,optFLD.flds); /* -f 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */
    
/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

  /*組合せ数と新項目の数のチェック*/
  if(!mssGV.txtFlg){
    if( optNUM.val != optFNM.cnt ){
      mssShowErrMsg("number of new fields must be %d",optNUM.val);
      mssEnd(mssErrorNoDefault);
    }
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/                                
  hdo=mssInitCpyHeader(hdi);
  
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);
  
  /*新項目名を追加する*/
  mssAddFieldsByStrList(hdo->flds,optFNM.strList,optFNM.cnt);
    
  /*ソートする必要があるならばsfのソート情報を反映*/    
  if(!optSEQ.set && !sorted){
    mssSetFieldsSort(hdo->flds,sf); 
  }
  
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);
    
/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  strList=mssInitStrList();

  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if( !optSEQ.set && !sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*FRD構造体の初期化*/
  frd=mssInitFRD(hdi->flds->cnt);

  while( EOF!= mssReadFRD(fpr,frd) ){
    /*キーブレイク時の処理*/
    if(mssKeyBreak(frd, &optKEY)){

      /*一行書き出し*/
      writeCombi(frd, strList,optNUM.val,optPER.set,fpw);

      /*集計値の初期化*/
      mssFreeStrList(strList);
      strList=mssInitStrList();

      if(frd->eof) break;
    }

    mssGV.inCnt++;

    /*通常行の処理*/
    if( !MssIsNull(*(frd->pnt[frd->new]+MssFlds2num(optFLD.flds,0))) ){
      mssPutStrList( strList,*(frd->pnt[frd->new]+MssFlds2num(optFLD.flds,0)) );
    }
  }
  mssFreeStrList(strList);
  mssFreeFRD(frd);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);  /* フッターの出力             */
  mssCloseFPR(fpr);     /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);     /* 出力ファイルのクローズ     */
  mssFreeFields(sf);    /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);   /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);   /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);   /* オプション領域開放         */
  mssShowEndMsg();      /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /*終了*/
  return(0);            /* to avoid warning message   */
}
