/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : 数値でソートしたキーを持つデータの動作不具合対処(API) 2003/08/07     */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtcommonHelp.h>
struct mssComHelp comHelp={
  "xtcommon",     /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */ 
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--グローバル変数*/
static int statT; /*readFRK(Tra)のステータス*/
static int statM; /*readFRK(Mst)のステータス*/
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;

int keyCmp(
  struct mssFldRec *frT,
  struct mssFldRec *frM){
  int cmp;
  int i;
  int fnT;
  int fnM;

  if(statT==EOF) return(1);  /*T>M*/
  if(statM==EOF) return(-1); /*T<M*/

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp(*(frT->pnt+fnT),*(frM ->pnt+fnM));
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    TKYT,   /* このオプションのタイトル(Helpで表示)                         */
    TKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* オプションタイプ                                             */
    "K",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    MKYT,   /* このオプションのタイトル(Helpで表示)                         */
    MKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    MSTT,   /* このオプションのタイトル(Helpで表示)                         */
    MSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* アンマッチ出力ファイル                                                     */
/*----------------------------------------------------------------------------*/
  MssOptOTF optNOF={
    OOTF,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NOFT,   /* このオプションのタイトル(Helpで表示)                         */
    NOFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 強制ハッシュ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINT optHAS={
    OINT,   /* オプションタイプ                                             */
    "H",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1001,   /* デフォルト(数値として指定)                                   */
    11,     /* 最小値                                                       */
    100001, /* 最大値                                                       */
    HAST,   /* このオプションのタイトル(Helpで表示)                         */
    HASC    /* このオプションのコメント(Helpで表示)                         */
  };        

/*----------------------------------------------------------------------------*/
/* 条件反転転フラグ(アンマッチを出力)                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optMKY,&optMST,&optNOF,&optREV,&optHAS,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdT;  /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdM;  /*参照ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo;  /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fprT; /*入力ファイル構造体                */
  struct mssFPR       *fprM; /*参照ファイル構造体                */
  struct mssFPW       *fpw;  /*出力ファイル構造体                */
  struct mssFPW       *fpw2; /*アンマッチ出力ファイル構造体      */
  struct mssFields    *sfT;  /*ソート項目構造体                  */
  struct mssFields    *sfM;  /*ソート項目構造体                  */
  int sortedT;               /*ソート済チェック用                */
  int sortedM;               /*ソート済チェック用                */

  /*hash joinにて*/
  struct mssFldRec    *frT =NULL;
  struct mssFldRecMax *frmM=NULL;

  /*key break joinにて*/
  struct mssFldRec    *frM =NULL;

  struct mssFileInfo  *fi=NULL; /*マスターのファイル情報*/

  struct mssHashFld     *hash=NULL;
  struct mssHashNodeFld *hn;

  int mstIsSmall;
  int procType;
  int kc;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

  /*-Kが指定されていなければ-kをコピーする*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }

  fprT=mssOpenFPR(optINF.str,4);    /*ファイルオープン*/
  fprM=mssOpenFPR(optMST.str,128);  /*マスターファイルオープン*/
  hdT=mssReadHeader(fprT);          /*項目名情報の読み込み*/
  hdM=mssReadHeader(fprM);          /*項目名情報の読み込み*/

  mssSetOptKey(&optTKY, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptKey(&optMKY, hdM);       /* オプション項目をヘッダー項目に関連づけ*/

  /*traソート項目の作成*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfT);        /* ソート優先順位番号を登録順にふる   */
  sortedT=mssChkSorted(sfT,hdT);        /* ソート済かチェック                 */

  /*mstソート項目の作成*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfM);        /* ソート優先順位番号を登録順にふる   */
  sortedM=mssChkSorted(sfM,hdM);        /* ソート済かチェック                 */

  /*強制hashでなければ一万行を上限にマスターの情報を取得*/
  if(!optHAS.set){
    fi=mssGetFileInfo(optMST.str,10000);

  /*強制hashならば全行マスターの情報を取得*/
  }else{ 
    fi=mssGetFileInfo(optMST.str,0);
  }
  
/*----------------------------------------------------------------------------*/
/*前処理                                                                      */
/*----------------------------------------------------------------------------*/
/* Traは大きいという前提で考える*/
/* TraSrt MstSrt MstSmall */
/* 無     無   小 hash                (1)*/
/* 無     無   大 Tsrt+Msrt + keyBreak(2)*/
/* 無     済   小 hash                (1)*/
/* 無     済   大 Tsrt      + keyBreak(3)*/
/* 済     無   小 Msrt      + keyBreak(4)*/
/* 済     無   大 Msrt      + keyBreak(4)*/
/* 済     済   小             keyBreak(5)*/
/* 済     済   大             keyBreak(5)*/

  /*マスタが小さいかどうかのチェック*/
  if(!fi->readEnd){  /*最後まで読み切っていない*/
    mstIsSmall=0;    
  }else{             /*その他は、smallであると判断*/
    mstIsSmall=1;
  }
  mssFree(fi);

  /*処理タイプの決定*/
  if(sortedT){
    if(sortedM){
      if(mstIsSmall) procType=5;
      else           procType=5;
    }else{
      if(mstIsSmall) procType=4;
      else           procType=4;
    }
  }else{
    if(sortedM){
      if(mstIsSmall) procType=1;
      else           procType=3;
    }else{
      if(mstIsSmall) procType=1;
      else           procType=2;
    }
  }

  /*強制hashの時は、強制的にtype1*/
  if(optHAS.set) procType=1;

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdT);
  
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);
  
  if(procType==2 || procType==3){
    mssSetFieldsSort(hdo->flds,sfT);
  }
  
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

  /*条件不一致出力オープン+ヘッダーの出力*/
  if(optNOF.set){
    fpw2=mssOpenFPW(optNOF.str,0,0);
    mssWriteHeader(hdo, fpw2);
  }else{
    fpw2=NULL;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン*/
/*----------------------------------------------------------------------------*/
  /*グローバル変数セット*/
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;

  if(procType==1){

    /*ハッシュテーブルの作成*/
    frmM =mssInitFRM(hdM->flds->cnt);
    mssReadFRM(fprM,frmM);

    /*全行読み込んでるはずなのでeofフラグがたっているはず*/
    if(!frmM->eof) {
      mssShowErrMsg("internal error in xtcommon by hash");
      mssEnd(mssErrorNoDefault);
    }
    hash=mssInitHashFld(optHAS.val,optMKY.flds);
    for(i=0; i<frmM->recCnt; i++){
      mssHashInsertFld(hash, frmM->pnt+i*frmM->fldCnt);
    }
/*mssShowHashFld(hash, frmM->fldCnt);*/

    frT =mssInitFldRec(hdT->flds->cnt);

    while(1){
      statT=mssReadFldRec(fprT,frT);

      /*Tra Endの時*/
      if(statT==EOF){
        break;
      }

      mssGV.inCnt++;

      /*Mstセット*/
      hn=mssHashMemberFld(hash, frT->pnt, optTKY.flds);

      /*match*/
      if(hn!=NULL){
        if(optREV.set){
          if(optNOF.set) mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw2);
        }else{
          mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw);
          mssGV.outCnt++;
        }

      /*unmatch*/
      }else{
        if(optREV.set){
          mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw);
          mssGV.outCnt++;
        }else{
          if(optNOF.set) mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw2);
        }
      }
    }

    mssFreeFRM(frmM);
    mssFreeFldRec(frT);
    mssFreeHashFld(hash);

  }else{

    frT =mssInitFldRec(hdT->flds->cnt);
    frM =mssInitFldRec(hdM->flds->cnt);
    if(!sortedT){
      fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
    }
    if(!sortedM){
      fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
    }

    /*トラ読み込み*/
    statT=mssReadFldRec(fprT,frT);
    mssGV.inCnt++;

    /*マスタ読み込み*/
    statM=mssReadFldRec(fprM,frM);

    while(1){

      /*Tra,Mst両方Endの時*/
      /*if(statT==EOF || statM==EOF) break;*/
      if(statT==EOF) break;

      kc=keyCmp(frT,frM);
      if(kc == 1){       /*T>M*/
        statM=mssReadFldRec(fprM,frM);
      }else if(kc ==-1){ /*T<M*/
        if(optREV.set){
          mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw);
          mssGV.outCnt++;
        }else{
          if(optNOF.set) mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw2);
        }
        statT=mssReadFldRec(fprT,frT);
        mssGV.inCnt++;
      }else{             /*T==M*/
        if(optREV.set){
          if(optNOF.set) mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw2);
        }else{
          mssWriteFld(frT->pnt, frT->fldCnt, "\n", fpw);
          mssGV.outCnt++;
        }
        statT=mssReadFldRec(fprT,frT);
        mssGV.inCnt++;
      }
    }
    mssFreeFldRec(frT);
    mssFreeFldRec(frM);
  }


/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssWriteFooter(fpw2);   /*フッターの出力              */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssCloseFPW(fpw2);      /*条件不一致ファイルのクローズ*/
  mssCloseFPR(fprT);      /*入力ファイルのクローズ      */
  mssCloseFPR(fprM);      /*入力ファイルのクローズ      */
  mssFreeFields(sfT);     /*ソート項目構造体の領域開放  */
  mssFreeFields(sfM);     /*ソート項目構造体の領域開放  */
  mssFreeHeader(hdT);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdM);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
