/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : 新項目名が出力されないバグ修正 2003/07/18                            */
/* 1.2 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>

#include <xtcutHelp.h>
struct mssComHelp comHelp={
  "xtcut",        /* コマンド名       */
  "1.2",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 選択項目反転フラグ                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optREV,&optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体                */
  struct mssFPW    *fpw; /*出力ファイル構造体                */
  struct mssFldRec *fr;  /*項目-行バッファ構造体             */

  int *revFld=NULL;   /*-r指定時の出力項目フラグ          */
  int  revCnt=0;      /*-r指定時の出力項目数              */

  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/                                
  hdo=mssInitCpyHeader(hdi);
    
  /*-fに指定された項目情報のみ追加*/
  if(!optREV.set){
    for(i=0; i<optFLD.flds->cnt; i++){
      mssAddFieldsByFldInfo(hdo->flds, *(optFLD.flds->fi+i));
      mssSetFldInfoSort(*(hdo->flds->fi+i),
          mssFldNum2SrtPri(hdi->flds, MssFlds2num(optFLD.flds,i)),
          mssFldNum2SrtRev(hdi->flds, MssFlds2num(optFLD.flds,i)),
          mssFldNum2SrtNum(hdi->flds, MssFlds2num(optFLD.flds,i)) );
    }
  /*-fに指定されなかった項目情報のみ追加*/
  }else{
    for(i=0; i<hdi->flds->cnt; i++){
      if(*(optFLD.fldNo2optNo+i)==-1){
        mssAddFieldsByFldInfo(hdo->flds, *(hdi->flds->fi+i));
      }
    }
  }

  /* ソート情報を検査し、適切でないソート情報を削除する */
  mssUpdateFieldsSortPriority(hdo->flds);

  /* 全項目に項目番号を登録順にふる */                                      
  mssSetFieldsSequenceNum(hdo->flds);
    
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  if(optREV.set){
    /*-r時の出力項目番号を求める*/
    revFld=mssMalloc(sizeof(int)*hdi->flds->cnt,"xtcut");/*余分めに*/
    revCnt=0;
    for(i=0; i<hdi->flds->cnt; i++){
      if(*(optFLD.fldNo2optNo+i)==-1){
        *(revFld+revCnt++)=i;
      }
    }
  }

  fr=mssInitFldRec(hdi->flds->cnt);

  /*項目削除の場合*/
  if(optREV.set){
    while( EOF != mssReadFldRec(fpr,fr) ){
      mssGV.inCnt++;
      /*項目の書き出し*/
      for(i=0; i<revCnt-1; i++){
        mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,*(revFld+i))),fpw);
        mssWriteDlm(fpw);
      }
      mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,*(revFld+i))),fpw);
      mssWriteRet(fpw);
      mssGV.outCnt++;
    }
  /*項目撰択の場合*/
  }else{
    while( EOF != mssReadFldRec(fpr,fr) ){
      mssGV.inCnt++;
      /*項目の書き出し*/
      for(i=0; i<optFLD.flds->cnt-1; i++){
        mssWriteStr(*(fr->pnt+MssFlds2num(optFLD.flds,i)),fpw);
        mssWriteDlm(fpw);
      }
      mssWriteStr(*(fr->pnt+MssFlds2num(optFLD.flds,i)),fpw);
      mssWriteRet(fpw);
      mssGV.outCnt++;
    }
  }
  mssFreeFldRec(fr);
  mssFree(revFld);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);  /* フッターの出力             */
  mssCloseFPR(fpr);     /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);     /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);   /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);   /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);   /* オプション領域開放         */
  mssShowEndMsg();      /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /*終了*/
  return(0);            /* to avoid warning message   */
}
