/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応                                                      */
/* 1.1 : 2004/08/24 -fオプション追加                                          */
/*============================================================================*/
  
#include <musashi.h>
#include <stdlib.h>

#include <xtheaderHelp.h>
struct mssComHelp comHelp={
  "xtheader",     /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */                                      
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    MssFieldMaxCnt, /* カンマで区切られる要素数の最大値                     */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldNameMaxLen,/* 各要素の文字列長の最大値                          */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  }; 

/*----------------------------------------------------------------------------*/
/* 項目名の部分的な変更                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* タイトル                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTIT={
    OSTR,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    MssTitleMaxLen,/* 文字列の最大長                                        */
    TITT,   /* このオプションのタイトル(Helpで表示)                         */
    TITC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* コメント                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCOM={
    OSTR,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    MssCommentMaxLen,/* 文字列の最大長                                      */
    COMT,   /* このオプションのタイトル(Helpで表示)                         */
    COMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* インポートファイル                                                         */
/*----------------------------------------------------------------------------*/
  MssOptINF optIMP={
    OINF,   /* オプションタイプ                                             */
    "I",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    IMPT,   /* このオプションのタイトル(Helpで表示)                         */
    IMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ソートタグ削除                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSRT={
    OFLG,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SRTT,   /* このオプションのタイトル(Helpで表示)                         */
    SRTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFNM,&optFLD,&optTIT,&optCOM,&optIMP,&optSRT,
               &optINF,&optOTF,&optZIP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*テキストファイル用<head>タグ格納構造体*/
  struct mssHeader *hdI; /*-I入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPR    *fpr2;/*インポートファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssRec    *rec; /*項目-行バッファ構造体*/

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

  /*-f,-a,-Iが2つ以上指定されとき*/
  if(optIMP.set + optFNM.set + optFLD.set > 1){
    mssShowErrMsg("option -f, -a and -I are exclusive");
    mssEnd(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  if(optIMP.set){ /*-Iフラグon*/
    fpr2=mssOpenFPR(optIMP.str,4);   /*インポートファイルオープン*/
    hdI=mssReadHeader(fpr2);         /*項目名情報の読み込み*/

    /*出力ヘッダーの初期化(タイトル等のコピー)*/
    hdo=mssInitCpyHeader(hdI);

    /*入力ヘッダの全項目を追加*/
    mssAddFieldsByFields(hdo->flds,hdI->flds);

    if(!optSRT.set){
      /*ソート情報のクリア*/
      mssClearFieldsSort(hdo->flds);
    }
    mssCloseFPR(fpr2);               /*インポートファイルクローズ*/

  }else if(optFNM.set) {
    /*出力ヘッダーの初期化(タイトル等のコピー)*/
    hdo=mssInitCpyHeader(hdi);

    /* -aで指定された項目名を追加する*/
    mssAddFieldsByStrList(hdo->flds,optFNM.strList,optFNM.cnt);

  }else if(optFLD.set) {
    /*出力ヘッダーの初期化(タイトル等のコピー)*/
    hdo=mssInitCpyHeader(hdi);

    /*-fで指定された項目は-fから、その他は入力ヘッダから項目を追加する*/
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);

  }else{
    /*出力ヘッダーの初期化(タイトル等のコピー)*/
    hdo=mssInitCpyHeader(hdi);

    /*入力ヘッダの全項目を追加*/
    mssAddFieldsByFields(hdo->flds,hdi->flds);
  }

  if(hdo->flds->cnt != hdi->flds->cnt){
    mssShowErrMsg("the numbers of fields mismatch");
    mssEnd(mssErrorNoDefault);
  }

  /*-lフラグon*/
  if(optTIT.set){
    mssFree(hdo->title);
    hdo->title  = mssStrdup(optTIT.str);
  }

  /*-cフラグon*/
  if(optCOM.set){
    mssFree(hdo->comment);
    hdo->comment = mssStrdup(optCOM.str);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo,fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  rec=mssInitRec();
  while(EOF != mssReadRec(fpr,rec)){
    mssGV.inCnt++;
    mssWriteStr(rec->pnt,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
  } 
  mssFreeRec(rec);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
