/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>

#include <xtioHelp.h>
struct mssComHelp comHelp={
  "xtiotest",     /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 処理方法                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSEL optTYP={
    OSEL,   /* オプションタイプ                                             */
    "P",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列にて)                                       */
    "1,2,3,4,5,6",
            /* 指定可能な値リスト                                           */
    TYPT,   /* このオプションのタイトル(Helpで表示)                         */
    TYPC,   /* このオプションのコメント(Helpで表示)                         */
    TYPS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 整数型                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optCNT={
    OINT,   /* オプションタイプ                                             */
    "C",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    10000,  /* 最大値                                                       */
    CNTT,   /* このオプションのタイトル(Helpで表示)                         */
    CNTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optTYP,&optCNT,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */

  struct mssFldRecMax *frm=NULL; /*最大行バッファ構造体   */
  struct mssFldRecKey *frk=NULL; /*キー単位バッファ構造体 */
  struct mssFldRecDbl *frd=NULL; /*二行バッファ構造体     */
  struct mssFldRec    *fr =NULL; /*項目-行バッファ構造体  */
  struct mssRec       *rec=NULL; /*行バッファ構造体       */

  struct mssFileInfo *fi;
  int i,k;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */

/*prnOption(opt);*/
/*prnHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);
  
/*----------------------------------------------------------------------------*/
/*メインルーチン*/
/*----------------------------------------------------------------------------*/

  /*============================*/
  for(k=0; k<optCNT.val; k++){
  mssSeekTopFPR(fpr);
  /*============================*/

  switch(atoi(optTYP.str)){
  case 1:
    rec=mssInitRec();
    while(EOF != mssReadRec(fpr,rec)){
      mssGV.inCnt++;
      mssWriteStr(rec->pnt,fpw);
      mssWriteRet(fpw);
      mssGV.outCnt++;
    }
    mssFreeRec(rec);
    break;

  case 2:
    fr=mssInitFldRec(hdi->flds->cnt);
    while(EOF != mssReadFldRec(fpr,fr)){
      mssGV.inCnt++;
      mssWriteFld(fr->pnt,fr->fldCnt,"\n",fpw);
      mssGV.outCnt++;
    }
    mssFreeFldRec(fr);
    break;

  case 3:
    frd=mssInitFRD(hdi->flds->cnt);
    while(EOF != mssReadFRD(fpr,frd)){
      if(mssKeyBreak(frd,&optKEY) ){
        mssWriteStr("---keyBreak!!\n",fpw);
        if(frd->eof) break;
      }
      mssGV.inCnt++;
      mssWriteFld(frd->pnt[frd->new],frd->fldCnt,"\n",fpw);
      mssGV.outCnt++;
    }
    mssFreeFRD(frd);
    break;

  case 4:
    frm =mssInitFRM(hdi->flds->cnt);
    while(EOF != mssReadFRM(fpr,frm)){
      mssGV.inCnt+=frm->recCnt;
      for(i=0; i<frm->recCnt; i++){
        mssWriteFld(frm->pnt+i*frm->fldCnt,frm->fldCnt,"\n",fpw);
        mssGV.outCnt++;
      }
      mssWriteStr("---maxLine!!\n",fpw);
    }
    mssFreeFRM(frm);
    break;

  case 5:
    frk=mssInitFRK(hdi->flds->cnt,&optKEY,optTMP.str);
    while(EOF != mssReadFRK(fpr,frk)){
      mssSeekTopFRK(frk);
      while( EOF != mssReadFldRecFRK(frk) ){
        mssGV.inCnt++;
        mssWriteFld(frk->pnt,frk->fldCnt,"\n",fpw);
        mssGV.outCnt++;
      }
      mssWriteStr("---keyBreak!!\n",fpw);
    }
    mssFreeFRK(frk);
    break;

  case 6: /*fileStatusの表示*/
    fi=mssGetFileInfo(fpr->fName, 0);
    printf("fileName :%s\n",fi->fName);
    printf("maxCnt   :%d\n",fi->maxCnt);
    printf("fieldCnt :%d\n",fi->fldCnt);
    printf("recCnt   :%d\n",fi->recCnt);
    printf("readEnd  :%d\n",fi->readEnd);
    printf("totalSize:%d\n",fi->totalSize);
    printf("bodySize :%d\n",fi->bodySize);
    mssFree(fi);
    break;
  }

  /*============================*/
  }/*for k*/
  /*============================*/

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理*/
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
