/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : 数値でソートしたキーを持つデータの動作不具合対処(API) 2003/08/07     */
/* 1.2 : -nを伴ったデータ無しファイルの結合でのエラー修正 2004/10/20          */
/* 1.3 : ファイルの結合でのエラー修正 2004/10/25                              */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtjoinHelp.h>
struct mssComHelp comHelp={
  "xtjoin",       /* コマンド名       */
  "1.3",          /* バージョン       */
  HELPT,          /* コマンドタイトル */ 
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--グローバル変数*/
static int fcT;       /*トラの項目数*/
static int fcM;       /*マスの項目数*/
static int statT;     /*readFRK(Tra)のステータス*/
static int statM;     /*readFRK(Mst)のステータス*/
static struct mssFPW *op;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTFLD;

/**
 * # FUNCTION #
 * 現在読み込まれているTraとMstのキーの値を比較する
 */
int keyCmp(
  struct mssFldRecDbl *frdT,
  struct mssFldRec    *frM){
  int cmp;
  int i;
  int fnT;
  int fnM;

  if(frdT->eof)  return(1);  /*T>M*/
  if(statM==EOF) return(-1); /*T<M*/

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp(*(frdT->pnt[frdT->new]+fnT),*(frM ->pnt+fnM));
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}

/**
 * # FUNCTION #
 * マスター項目としてstr配列のcnt個の要素を書き出す。
 * 行末の改行を出力する。
 */
void writeMstFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
    mssWriteDlm(op);
  } 
  mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
  mssWriteRet(op);
} 

/**
 * # FUNCTION #
 * マスター項目として、cnt個のNULL値として書き出す。
 * 行末の改行を出力する。
 */
void writeMstNul(int cnt){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteNull(op); mssWriteDlm(op);
  } 
  mssWriteNull(op); mssWriteRet(op);
} 

/**
 * # FUNCTION #
 * トランザクション項目としてstr配列のcnt個の要素を書き出す。
 * 行末はスペースを出力する。
 */
void writeTraFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt; i++){
    mssWriteStr(*(str+i),op);
    mssWriteDlm(op);
  } 
} 

/**
 * # FUNCTION #
 * トランザクションキー項目の値が、にマスターキー項目に存在しないとき、
 * トランザクションのキー項目は、マスターの項目(str)を参照しながら出力し、
 * その他のトランザクション項目はNULL値を出力する。
 */
void writeTraByMst(char **str){
  int kv;
  int i;
  for(i=0; i<fcT; i++){
    kv=*(OPTTKY->fldNo2optNo+i);
    if(kv!=-1){
      mssWriteStr(*(str+MssFlds2num(OPTMKY->flds,kv)),op);
      mssWriteDlm(op);
    }else{
      mssWriteNull(op); mssWriteDlm(op);
    }
  }
}

void writeTM(struct mssFldRecDbl *frdT,struct mssFldRec *frM){

  /*マスターがEOFの時*/
  if(frM==NULL){
    writeTraFld(frdT->fldCnt,frdT->pnt[frdT->new]);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*トラがEOFの時*/
  }else if(frdT==NULL){
    writeTraByMst(frM->pnt);
    writeMstFld(OPTFLD->flds->cnt,frM->pnt);
    mssGV.outCnt++;

  /*トラ、マスターの両方ある場合*/
  }else{
    writeTraFld(frdT->fldCnt,frdT->pnt[frdT->new]);
    writeMstFld(OPTFLD->flds->cnt,frM->pnt);
    mssGV.outCnt++;
  }
}

void writeNulMstHash(struct mssHashFld *hash){
  struct mssHashNodeFld *node;
  int i,j;

  for(i=0; i<hash->hashVal; i++){ /*全hash値を見る*/
    node=*(hash->node+i);
    while(node != NULL){          /*hash値がiのノードを全て見る*/
      if(!node->endFlg){          /*そのノードが１回も検索されていなければ*/
        for(j=0; j<node->recCnt; j++){
          writeTraByMst(*(node->rec+j));
          writeMstFld(OPTFLD->flds->cnt,*(node->rec+j));
          mssGV.outCnt++;
        }
      }
      node=node->next;
    }
  }
}

void writeTMhash(struct mssFldRec *frT,struct mssHashNodeFld *hn){

  /*マスターがNULLの時*/
  if(hn==NULL){
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*トラ、マスターの両方ある場合*/
  }else{
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstFld(OPTFLD->flds->cnt,*hn->rec);
    mssGV.outCnt++;
  }
}

/*============================================================================*/
/* version 1.00 2000/07/07 初期作成 hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    TKYT,   /* このオプションのタイトル(Helpで表示)                         */
    TKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* オプションタイプ                                             */
    "K",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    MKYT,   /* このオプションのタイトル(Helpで表示)                         */
    MKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    MSTT,   /* このオプションのタイトル(Helpで表示)                         */
    MSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 結合項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* マスターouterJoin                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLG optMNL={
    OFLG,   /* オプションタイプ                                             */
    "N",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    MNLT,   /* このオプションのタイトル(Helpで表示)                         */
    MNLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力outerJoin                                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTNL={
    OFLG,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TNLT,   /* このオプションのタイトル(Helpで表示)                         */
    TNLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 強制ハッシュJoin                                                           */
/*----------------------------------------------------------------------------*/
  MssOptINT optHAS={
    OINT,   /* オプションタイプ                                             */
    "H",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1001,   /* デフォルト(数値として指定)                                   */
    11,     /* 最小値                                                       */
    100001, /* 最大値                                                       */
    HAST,   /* このオプションのタイトル(Helpで表示)                         */
    HASC    /* このオプションのコメント(Helpで表示)                         */
  };        

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optMKY,&optMST,&optFLD,&optMNL,&optTNL,&optHAS,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdM; /*参照ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fprT;/*入力ファイル構造体                */
  struct mssFPR       *fprM;/*参照ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFields    *sfT; /*ソート項目構造体                  */
  struct mssFields    *sfM; /*ソート項目構造体                  */
  int sortedT;              /*ソート済チェック用                */
  int sortedM;              /*ソート済チェック用                */

  /*hash joinにて*/
  struct mssFldRec    *frT =NULL;
  struct mssFldRecMax *frmM=NULL;

  /*key break joinにて*/
  struct mssFldRecDbl *frdT=NULL;
  struct mssFldRec    *frM =NULL;

  struct mssFileInfo  *fi=NULL; /*マスターのファイル情報*/

  struct mssHashFld     *hash;
  struct mssHashNodeFld *hn;


  /*マスターを一行でも書いたときon -tnullと単なるキーブレークを見分ける*/
  int mstw;

  int mstIsSmall;
  int procType;
  int kc;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  
  /*-Kが指定されていなければ-kをコピーする*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }
  
  fprT=mssOpenFPR(optINF.str,4);    /*ファイルオープン*/
  fprM=mssOpenFPR(optMST.str,128);  /*マスターファイルオープン*/
  hdT=mssReadHeader(fprT);          /*項目名情報の読み込み*/
  hdM=mssReadHeader(fprM);          /*項目名情報の読み込み*/
  
  mssSetOptKey(&optTKY, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptKey(&optMKY, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optFLD, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  
  /*traソート項目の作成*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfT);        /* ソート優先順位番号を登録順にふる   */
  sortedT=mssChkSorted(sfT,hdT);        /* ソート済かチェック                 */
  
  /*mstソート項目の作成*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfM);        /* ソート優先順位番号を登録順にふる   */
  sortedM=mssChkSorted(sfM,hdM);        /* ソート済かチェック                 */
  
  /*強制hashでなければ一万行を上限にマスターの情報を取得*/
  if(!optHAS.set){
    fi=mssGetFileInfo(optMST.str,10000);
  
  /*強制hashならば全行マスターの情報を取得*/
  }else{
    fi=mssGetFileInfo(optMST.str,0);
  }

/*----------------------------------------------------------------------------*/
/*前処理                                                                      */
/*----------------------------------------------------------------------------*/
/* Traは大きいという前提で考える*/
/* TraSrt MstSrt MstSmall */
/* 無     無     小 hash                (1)*/
/* 無     無     大 Tsrt+Msrt + keyBreak(2)*/
/* 無     済     小 hash                (1)*/
/* 無     済     大 Tsrt      + keyBreak(3)*/
/* 済     無     小 Msrt      + keyBreak(4)*/
/* 済     無     大 Msrt      + keyBreak(4)*/
/* 済     済     小             keyBreak(5)*/
/* 済     済     大             keyBreak(5)*/

  /*マスタが小さいかどうかのチェック*/
  if(!fi->readEnd){  /*最後まで読み切っていない*/
    mstIsSmall=0;
  }else{             /*その他は、smallであると判断*/
    mstIsSmall=1;
  }
  mssFree(fi);

  /*処理タイプの決定*/
  if(sortedT==1){
    if(sortedM==1){
      if(mstIsSmall) procType=5;
      else           procType=5;
    }else{
      if(mstIsSmall) procType=4;
      else           procType=4;
    }
  }else{
    if(sortedM==1){
      if(mstIsSmall) procType=1;
      else           procType=3;
    }else{
      if(mstIsSmall) procType=1;
      else           procType=2;
    }
  }

  /*強制hashの時は、強制的にtype1*/
  if(optHAS.set) procType=1;

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdT);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*新項目名を追加する*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  if(procType==2 || procType==3){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*グローバル変数セット*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTFLD=&optFLD;
  op=fpw;

  /*hash join*/
  if(procType==1){

    /*ハッシュテーブルの作成*/
    frmM =mssInitFRM(fcM);
    mssReadFRM(fprM,frmM);

    /*全行読み込んでるはずなのでeofフラグがたっているはず*/
    if(!frmM->eof) {
      mssShowErrMsg("internal error in xtjoin by hash");
      mssEnd(mssErrorNoDefault);
    }
    hash=mssInitHashFld(optHAS.val,optMKY.flds);
    for(i=0; i<frmM->recCnt; i++){
      mssHashInsertFld(hash, frmM->pnt+i*frmM->fldCnt);
    }
/*mssShowHashFld(hash, frmM->fldCnt);*/

    frT =mssInitFldRec(fcT);
    while(1){
      statT=mssReadFldRec(fprT,frT);

      /*Tra Endの時*/
      if(statT==EOF){
        if(optMNL.set) writeNulMstHash(hash);
        break;
      }

      mssGV.inCnt++;

      /*Traのキー項目値がMstにあるかどうか*/
      hn=mssHashMemberFld(hash, frT->pnt, optTKY.flds);
      if(hn==NULL && !optTNL.set) continue;

      /*書き出し*/
      writeTMhash(frT,hn);
    }

    mssFreeFRM(frmM);
    mssFreeFldRec(frT);
    mssFreeHashFld(hash);

  }else{

    frdT=mssInitFRD(fcT);
    frM =mssInitFldRec(fcM);
    if(sortedT!=1){
      fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
    }
    if(sortedM!=1){
      fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
    }

    /*トラ読み込み*/
    statT=mssReadFRD(fprT,frdT);

    /*マスタ読み込み*/
    statM=mssReadFldRec(fprM,frM); mstw=0;
    while(1){

      /*Tra,Mst両方Endの時*/
      if(statT==EOF && statM==EOF) break;

      /*TraがEndの時*/
      if(frdT->eof==1){
        if(statM==EOF) break;
        if(!optMNL.set) break;
      }

      /*MstだけEndの時*/
      if(statM==EOF){
        if(!optTNL.set) break;
      }

      kc=keyCmp(frdT,frM);
      if(kc == 1){       /*T>M*/
        if(optMNL.set && mstw==0) writeTM(NULL,frM);
        statM=mssReadFldRec(fprM,frM); mstw=0;
      }else if(kc ==-1){ /*T<M*/
        if(optTNL.set) writeTM(frdT,NULL);
        statT=mssReadFRD(fprT,frdT);
        mssGV.inCnt++;
      }else{             /*T==M*/
        writeTM(frdT,frM);
        mstw=1;
        statT=mssReadFRD(fprT,frdT);
        mssGV.inCnt++;
      }
    }
    mssFreeFRD(frdT);
    mssFreeFldRec(frM);
  }

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssCloseFPR(fprT);      /*入力ファイルのクローズ      */
  mssCloseFPR(fprM);      /*入力ファイルのクローズ      */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssFreeFields(sfT);     /*ソート項目構造体の領域開放  */
  mssFreeFields(sfM);     /*ソート項目構造体の領域開放  */
  mssFreeHeader(hdT);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdM);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
