/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/
  
#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <unistd.h>

#include <xtmkdataHelp.h>
struct mssComHelp comHelp={
  "xtmkdata",     /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */                                    
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */ 
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};  

extern struct mssGlobalVariables mssGV;                                     

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 計算式                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCAL={
    OSTR,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,    /* 文字列の最大長                                               */
    CALT,   /* このオプションのタイトル(Helpで表示)                         */
    CALC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力行数                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optLIN={
    OINT,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    10,     /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    LINT,   /* このオプションのタイトル(Helpで表示)                         */
    LINC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    2,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    2,      /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldMaxLen,/* 各要素の文字列長の最大値                              */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optCAL,&optLIN,&optFNM,
               &optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRec    *fr;  /*項目-行バッファ構造体             */
  
  struct mssCal       *cal=NULL; /*計算式をパースする構造体     */
  MssValue             rsl;      /*計算結果                     */
  char *dummyFldName[]={"8&31$#-^@dT4Jdeq"};
  int   dummyFldCnt=1;
  char  dummyFName[MssFileNameMaxLen];
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

  /*ダミー入力データのファイル名*/
  sprintf(dummyFName,"%s/xt##%d-mkdata",optTMP.str,(int)getpid());

  /*ブランクのxmlTableファイルを作成し、入力ファイルとする*/
  mssCreateBlankXtFile(dummyFldName,dummyFldCnt,dummyFName);

  /*usedTempFileFlgをONにし、終了時に時動的にファイルは削除される。*/
  mssGV.usedTempFileFlg=1;

  fpr=mssOpenFPR(dummyFName,4);   /* 入力ファイルオープン         */
  hdi=mssReadHeader(fpr);         /* ヘッダの読み込み             */

/*----------------------------------------------------------------------------*/
/*計算式の評価*/
/*----------------------------------------------------------------------------*/
  cal=mssCalCompile(optCAL.str,hdi);
    
/*mssCalShowTree(cal,0);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*新項目名の追加*/
  mssAddFieldsByStrList(hdo->flds,optFNM.strList,optFNM.cnt);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン*/
/*----------------------------------------------------------------------------*/
  /*FldRec構造体の初期化*/
  fr=mssInitFldRec(hdi->flds->cnt);

  /*calculationで利用する読込関数を登録*/
  mssCalReadFuncIsFldRec(cal,fr);

  /*データ読み込み*/
  mssGV.keyCnt=1;
  mssGV.keyNo =0;
  mssGV.keyLine=0;
  for(i=0; i<optLIN.val; i++){
    mssGV.inCnt++;

    /*計算実行*/
    rsl = mssCalculate(cal, fr->pnt);

    /*計算結果出力*/
    mssVwrite(rsl,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
  }
  mssGV.inCnt=0;
  mssFreeFldRec(fr);
  mssCalFree(cal);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理*/
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */ 
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
