/*============================================================================*/
/* xtnrcommon                                                                 */
/*----------------------------------------------------------------------------*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成 2004/08/01                                                  */
/* 1.1 : 文字列比較の評価に関するバグ修正 2004/10/09                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtnrcommonHelp.h>
struct mssComHelp comHelp={
  "xtnrcommonn",  /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */ 
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--グローバル変数*/
static int fcT;          /*入力データの項目数*/
static int fcM;          /*参照データの項目数*/
static int statT;        /*mssReadFRK(Tra)のステータス*/
static int statM;        /*mssReadFRK(Mst)のステータス*/
static struct mssFPW *op;
static struct mssFPW *op2;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTVAL;
static MssOptFLD *OPTRNG;
static MssOptOTF *OPTNOF;
static MssOptFLG *OPTREV;
static int NSflg; /*数値範囲(1)か文字範囲(0) */
static int EQflg0; /*開始範囲のイコール含むかフラグ*/
static int EQflg1; /*終了範囲のイコール含むかフラグ*/
static int StFldNo; /* -Rの開始項目の位置番号 */
static int EdFldNo; /* -Rの終了項目の位置番号 */

/**
 * # FUNCTION #
 * 現在読み込まれているTraとMstのキーの値を比較する
 */
int keyCmp(
  struct mssFldRecKey *frkT,
  struct mssFldRecKey *frkM){
  int cmp;
  int i;
  int fnT;
  int fnM;

  if(statT==EOF) return(1);  /*T>M*/
  if(statM==EOF) return(-1); /*T<M*/

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp( *(frkT->pnt+fnT), *(frkM->pnt+fnM) );
    if(cmp>0) return(1); /*T>M*/
    if(cmp<0) return(-1);/*T<M*/
  }
  return(0);
}


static int WriteFlg=0;

/**
 * # FUNCTION #
 * FRKのトランザクションを-uのファイルに全て書き出す。
 */
static void writeUnmatchTra(struct mssFldRecKey *frkT, struct mssFPW *fp){

  mssSeekTopFRK(frkT);
  while( EOF != mssReadFldRecFRK(frkT) ){
    mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",fp);
    if(fp==op) mssGV.outCnt++;
  }
}

/**
 * # FUNCTION #
 * トランザクションとマッチする範囲があれば書き出す。
 */
static void writeMatchRec(struct mssFldRecKey *frkT, struct mssRBnode *node, struct mssFPW *fp){

  if(!mssRBisExternalNode(node)){
    mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",fp);
    WriteFlg=1;
    if(fp==op) mssGV.outCnt++;
  }
}

/**
 * # FUNCTION #
 * トランザクションと範囲インデックスを突き合わせながら書き出し
 */
static void writeTMbyRng(struct mssFldRecKey *frkT,struct RangeIndex *rIndex){
  struct RangeNode *curNode=rIndex->list;
  struct mssRBnode *rb;
  char *val;
  MssValue v;
  int cmp;

  rb=mssRBinit(ADD);

  if( NSflg==1 ) mssVinit(&v,DBL);
  else           mssVinit(&v,STR);

  mssSeekTopFRK(frkT);
  while( EOF != mssReadFldRecFRK(frkT) ){
    /*トランザクションの-r項目の値をセット*/
    val = *(frkT->pnt+MssFlds2num(OPTVAL->flds,0));

    /* トランザクションがNULLもしくはマスターが終了の場合は、
       -N がセットされていれば出力 */
Loop3:
    if(MssIsNull(val) || curNode==NULL) {
      if(OPTREV->set){
        mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op);
      }else{
        if(OPTNOF->set)  mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op2);
      }
      break;
    }
    /*範囲の型に応じて変換*/
    if( NSflg==1 ) v.v.d = atof(val);
    else           v.v.s = val;

Loop2:
    cmp=mssVcmp(v,curNode->v);
    if(cmp<0){ /* val<curNode */ 
      if(OPTREV->set){
        WriteFlg=0;
        writeMatchRec(frkT,rb->left,op2);
        if(WriteFlg==0 && OPTNOF->set){
          mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op);
          mssGV.outCnt++;
        }
      }else{
        WriteFlg=0;
        writeMatchRec(frkT,rb->left,op);
        /* 一件も出力がなく-uが指定されていれば*/
        if(WriteFlg==0 && OPTNOF->set){
          mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op2);
        }
      }
      continue;
    } else if(cmp==0) {
      mssProcLTGE(rb, curNode);
      if(OPTREV->set){
        WriteFlg=0;
        writeMatchRec(frkT,rb->left,op2);
        if(WriteFlg==0 && OPTNOF->set){
          mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op);
          mssGV.outCnt++;
        }
      }else{
        WriteFlg=0;
        writeMatchRec(frkT,rb->left,op);
        /* 一件も出力がなく-uが指定されていれば*/
        if(WriteFlg==0 && OPTNOF->set){
          mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op2);
        }
      }
      continue;
    } else if(cmp>0) {
      mssProcLTGE(rb, curNode);
      mssProcLEGT(rb, curNode);
      curNode=curNode->next;
      if(curNode==NULL) goto Loop3;
      goto Loop2;
    }
  }

  mssRBfree(rb);
}

/**
 * # FUNCTION #
 * 現在のトランザクションとマスターを自然結合し、その結果を出力する。
 * frkTもしくはfrkMのいずれかにNULLを与えることにより、outerJOINを行い、
 * その結果を出力する。
 */
static void writeTM(struct mssFldRecKey *frkT,struct mssFldRecKey *frkM){
  struct RangeIndex *rIndex;

  /*マスターがEOFの時*/
  if(frkM==NULL){
    mssSeekTopFRK(frkT);
    while( EOF != mssReadFldRecFRK(frkT) ){
      mssWriteFld(frkT->pnt,frkT->fldCnt,"\n",op);
      mssGV.outCnt++;
    }

  /*トラ、マスターの両方ある場合*/
  /*トラがEOFの時はmainルーチンで終了処理している*/
  }else{

    /* マスターの範囲条件から範囲インデックス作成*/
    rIndex=mssSetRangeIndexFrk(frkM, NULL,StFldNo,EdFldNo,
                               NSflg,EQflg0,EQflg1);

    /*mssShowRangeIndex(rIndex);*/
    mssSeekTopFRK(frkT);
    while( EOF != mssReadFldRecFRK(frkT) ){
      writeTMbyRng(frkT,rIndex);
    }

    mssFreeRangeIndex(rIndex);
  }
}

/*============================================================================*/
/* version 1.00 2000/07/07 初期作成 hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    TKYT,   /* このオプションのタイトル(Helpで表示)                         */
    TKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 範囲比較される項目(一項目)                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optVAL={
    OFLD,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    VALT,   /* このオプションのタイトル(Helpで表示)                         */
    VALC,   /* このオプションのコメント(Helpで表示)                         */
    VALF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };


/*----------------------------------------------------------------------------*/
/* 参照キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* オプションタイプ                                             */
    "K",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    MKYT,   /* このオプションのタイトル(Helpで表示)                         */
    MKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照範囲項目(二項目)                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRNG={
    OFLD,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    2,      /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "en",   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    RNGT,   /* このオプションのタイトル(Helpで表示)                         */
    RNGC,   /* このオプションのコメント(Helpで表示)                         */
    RNGF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 参照ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    MSTT,   /* このオプションのタイトル(Helpで表示)                         */
    MSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* アンマッチ出力ファイル                                                     */
/*----------------------------------------------------------------------------*/
  MssOptOTF optNOF={
    OOTF,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NOFT,   /* このオプションのタイトル(Helpで表示)                         */
    NOFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 条件反転転フラグ(アンマッチを出力)                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optVAL,&optMKY,&optMST,&optRNG,&optNOF,&optREV,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdM; /*参照ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fprT;/*入力ファイル構造体                */
  struct mssFPR       *fprM;/*参照ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFPW       *fpw2;/*unmatch出力ファイル構造体         */
  struct mssFields    *sfT; /*ソート項目構造体                  */
  struct mssFields    *sfM; /*ソート項目構造体                  */
  int sortedT;              /*ソート済チェック用                */
  int sortedM;              /*ソート済チェック用                */

  /*key break joinにて*/
  struct mssFldRecKey *frkT=NULL;
  struct mssFldRecKey *frkM=NULL;

  int kc;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  
  /*-Kが指定されていなければ-kをコピーする*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }
  
  fprT=mssOpenFPR(optINF.str,4);    /*ファイルオープン*/
  fprM=mssOpenFPR(optMST.str,128);  /*マスターファイルオープン*/
  hdT=mssReadHeader(fprT);          /*項目名情報の読み込み*/
  hdM=mssReadHeader(fprM);          /*項目名情報の読み込み*/
  
  mssSetOptKey(&optTKY, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optVAL, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptKey(&optMKY, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optRNG, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  
  /*traソート項目の作成*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sfT,optVAL.flds);/* -r 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfT);        /* ソート優先順位番号を登録順にふる   */
  sortedT=mssChkSorted(sfT,hdT);        /* ソート済かチェック                 */
  
  /*mstソート項目の作成*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfM);        /* ソート優先順位番号を登録順にふる   */
  sortedM=mssChkSorted(sfM,hdM);        /* ソート済かチェック                 */
  
/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdT);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!sortedT){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

  /*条件不一致出力オープン+ヘッダーの出力*/
  if(optNOF.set){
    fpw2=mssOpenFPW(optNOF.str,optZIP.set,0);
    mssWriteHeader(hdo, fpw2);
  }else{
    fpw2=NULL;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*グローバル変数セット*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTVAL=&optVAL;
  OPTRNG=&optRNG;
  OPTNOF=&optNOF;
  OPTREV=&optREV;
  op=fpw;
  op2=fpw2;

  StFldNo=MssFlds2num(OPTRNG->flds,0);
  EdFldNo=MssFlds2num(OPTRNG->flds,1);

  /*数値範囲か文字列範囲かをセットする(デフォルトは数値範囲)*/
  NSflg=0;
  if(mssIsFldOptOn(&optVAL,0,'n') ){
    NSflg=1;
  }

 /*範囲のイコール含むかフラグ*/
  EQflg0=1;
  EQflg1=0;
  if(mssIsFldOptOn(&optRNG,0,'n') ) EQflg0=0;
  if(mssIsFldOptOn(&optRNG,1,'e') ) EQflg1=1;
  if(!sortedT){
    fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
  }
  if(!sortedM){
    fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
  } 


  frkT=mssInitFRK(fcT,&optTKY,optTMP.str);
  frkM=mssInitFRK(fcM,&optMKY,optTMP.str);

  statT=mssReadFRK(fprT,frkT);
  statM=mssReadFRK(fprM,frkM);
  mssGV.inCnt += frkT->keyRecCnt;

  while(1){

    /*TraがEndの時*/
    if(statT==EOF) break;

    /*MstがEndの時*/
    if(statM==EOF){
      if(!OPTNOF->set) break;
    }


    /* Tra,Mstの最初の一行をキーの値の比較のために読み込む*/
    mssReadFldRecFRK(frkT);
    mssReadFldRecFRK(frkM);
    kc=keyCmp(frkT,frkM);
    if(kc == 1){       /*T>M*/
      statM=mssReadFRK(fprM,frkM);
    }else if(kc ==-1){ /*T<M*/
      if(OPTREV->set){
        if(OPTNOF->set) writeUnmatchTra(frkT,op);
      }else{
        if(OPTNOF->set) writeUnmatchTra(frkT,op2);
      }
      statT=mssReadFRK(fprT,frkT);
      if(statT!=EOF)mssGV.inCnt += frkT->keyRecCnt;
    }else{             /*T==M*/
      writeTM(frkT,frkM);
      statT=mssReadFRK(fprT,frkT);
      if(statT!=EOF)mssGV.inCnt += frkT->keyRecCnt;
      statM=mssReadFRK(fprM,frkM);
    }
  }
  mssFreeFRK(frkT);
  mssFreeFRK(frkM);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssWriteFooter(fpw2);   /*フッターの出力              */
  mssCloseFPR(fprT);      /*入力ファイルのクローズ      */
  mssCloseFPR(fprM);      /*入力ファイルのクローズ      */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssCloseFPW(fpw2);      /*条件不一致ファイルのクローズ*/
  mssFreeFields(sfT);     /*ソート項目構造体の領域開放  */
  mssFreeFields(sfM);     /*ソート項目構造体の領域開放  */
  mssFreeHeader(hdT);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdM);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
