/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : デリミタの汎用化対応 2003/09/26                                      */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>

#include <xtproductHelp.h>
struct mssComHelp comHelp={
  "xtproduct",    /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

void writeMstFld(struct mssFields *fld, char **str,struct mssFPW *fp){
  int i;
  for(i=0; i<fld->cnt-1; i++){
    mssWriteStr(*(str+MssFlds2num(fld,i)),fp);
    mssWriteDlm(fp);
  }
  mssWriteStr(*(str+MssFlds2num(fld,i)),fp);
  mssWriteRet(fp);
}

int main(int argc, char *argv[]){
/*----------------------------------------------------------------------------*/
/* 参照ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    MSTT,   /* このオプションのタイトル(Helpで表示)                         */
    MSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 結合項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optMST,&optFLD,&optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdM; /*参照ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fprT;/*入力ファイル構造体                */
  struct mssFPR       *fprM;/*参照ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRec    *frT =NULL;
  struct mssFldRec    *frM =NULL;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化             */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                               */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定             */

  fprT=mssOpenFPR(optINF.str,4);    /*ファイルオープン                       */
  fprM=mssOpenFPR(optMST.str,128);  /*マスターファイルオープン               */
  hdT=mssReadHeader(fprT);          /*項目名情報の読み込み                   */
  hdM=mssReadHeader(fprM);          /*項目名情報の読み込み                   */

  mssSetOptFld(&optFLD, hdM);       /* オプション項目をヘッダー項目に関連づけ*/

/*prnOption(opt);*/
/*prnHeader(hdT);*/
/*prnHeader(hdM);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdT);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);
  
  /*新項目名を追加する*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);
  
/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  frT=mssInitFldRec(hdT->flds->cnt);
  frM=mssInitFldRec(hdM->flds->cnt);

  while(EOF!=mssReadFldRec(fprT,frT)){
    mssGV.inCnt++;

    mssSeekTopFPR(fprM);
    while(EOF!=mssReadFldRec(fprM,frM)){
      mssWriteFld(frT->pnt, frT->fldCnt, MssFieldDelimStr, fpw);
      writeMstFld(optFLD.flds, frM->pnt, fpw);
      mssGV.outCnt++;
    }
  }
  mssFreeFldRec(frT);
  mssFreeFldRec(frM);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssCloseFPR(fprT);      /*入力ファイルのクローズ      */
  mssCloseFPR(fprM);      /*入力ファイルのクローズ      */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssFreeHeader(hdT);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdM);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
