/*============================================================================*/
/* xtrjoin -k -r%s|n -m -K -R field1%e|n,field2%e|n -f  -n -z -t              */
/*----------------------------------------------------------------------------*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新規作成 2004/08/01                                                  */
/* 1.1 : 文字列の大小比較のバグ修正 2004/10/05                                */
/*       キーの指定なしの場合のバグ修正                                       */
/* 1.2 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtrjoinHelp.h>
struct mssComHelp comHelp={
  "xtrjoin",      /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */ 
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--グローバル変数*/
static struct mssFPW *op;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTFLD;
static MssOptFLD *OPTVAL;
static MssOptFLD *OPTRNG;
static int NSflg; /*数値範囲(1)か文字範囲(0) */

struct KeyInfo {
  int keyCmp;
  int rngCmp;
  int rngFlg; /* 0: 以上〜未満 1:より大きい〜以下 */
};

/**
 * # FUNCTION #
 * 現在読み込まれているTraとMstのキーの値を比較する
 */
void setKeyInfo(
  struct KeyInfo *keyInfo,
  struct mssFldRec    *frT,
  struct mssFldRecDbl *frdM){
  int cmp;
  int i;
  int fnT;
  int fnM;
  int kb;
  char *rsT,*rsMst,*rsMed;
  double  rnT,rnMst,rnMed;

  if(frT->eof){
    keyInfo->keyCmp=1; /*T>M*/
    keyInfo->rngCmp=9; /*T>M*/
  }
  if(frdM->eof){
    keyInfo->keyCmp=-1; /*T<M*/
    keyInfo->rngCmp= 9; /*T<M*/
  }

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp(*(frT->pnt+fnT),
                 *(frdM->pnt[frdM->old]+fnM));
    if(cmp>0){
      keyInfo->keyCmp=1; /*T>M*/
      keyInfo->rngCmp=9; /*T>M*/
      return;
    }else if(cmp<0){
      keyInfo->keyCmp=-1; /*T<M*/
      keyInfo->rngCmp= 9; /*T<M*/
      return;
    }
  }

  keyInfo->keyCmp=0; /*T=M*/

  kb=mssKeyBreak( frdM, OPTMKY);
  rsT   = *(frT->pnt+MssFlds2num(OPTVAL->flds,0));
  rsMst = *(frdM->pnt[frdM->old]+MssFlds2num(OPTRNG->flds,0));
  if(kb) rsMed = "\xFF\xFF\xFF\xFF";
  else   rsMed = *(frdM->pnt[frdM->new]+MssFlds2num(OPTRNG->flds,0));

  if( NSflg==1 ){ /*数値範囲の場合*/
    rnT  =atof(rsT  );
    rnMst=atof(rsMst);
    if(kb) rnMed = DBL_MAX;
    else   rnMed = atof(rsMed);

    if(keyInfo->rngFlg){     /* より大きい〜以下の比較 */
//printf("st,ed=%g,%g\n",rnMst,rnMed);
           if(rnT> rnMed) keyInfo->rngCmp= 1;
      else if(rnT<=rnMst) keyInfo->rngCmp=-1;
      else                keyInfo->rngCmp= 0;
    }else{                   /* 以上〜未満の比較 */
           if(rnT>=rnMed) keyInfo->rngCmp= 1;
      else if(rnT< rnMst) keyInfo->rngCmp=-1;
      else                keyInfo->rngCmp= 0;
    }
  }else{          /*文字列範囲の場合*/
    if(keyInfo->rngFlg){     /* より大きい〜以下の比較 */
           if( strcmp(rsT, rsMed) > 0 ) keyInfo->rngCmp= 1;
      else if( strcmp(rsT, rsMst) <=0 ) keyInfo->rngCmp=-1;
      else                              keyInfo->rngCmp= 0;
    }else{                   /* 以上〜未満の比較 */
           if( strcmp(rsT, rsMed) >=0 ) keyInfo->rngCmp= 1;
      else if( strcmp(rsT, rsMst) < 0 ) keyInfo->rngCmp=-1;
      else                              keyInfo->rngCmp= 0;
    }
  }
}

/**
 * # FUNCTION #
 * マスター項目として、cnt個のNULL値として書き出す。
 * 行末の改行を出力する。
 */
static void writeMstNul(int cnt){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteNull(op); mssWriteDlm(op);
  }
  mssWriteNull(op); mssWriteRet(op);
}

/**
 * # FUNCTION #
 * トランザクション項目としてstr配列のcnt個の要素を書き出す。
 * 行末はスペースを出力する。
 */
static void writeTraFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt; i++){
    mssWriteStr(*(str+i),op);
    mssWriteDlm(op);
  }
}

/**
 * # FUNCTION #
 * マスター項目としてstr配列のcnt個の要素を書き出す。
 * 行末の改行を出力する。
 */
void writeMstFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
    mssWriteDlm(op);
  }
  mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
  mssWriteRet(op);
}

/**
 * # FUNCTION #
 * 現在のトランザクションとマスターを自然結合し、その結果を出力する。
 * frkTもしくはfrkMのいずれかにNULLを与えることにより、outerJOINを行い、
 * その結果を出力する。
 */
static void writeTM(struct mssFldRec *frT,struct mssFldRecDbl *frdM){

  /*マスターがEOFの時*/
  if(frdM==NULL){
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*トラ、マスターの両方ある場合*/
  }else{
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstFld(OPTFLD->flds->cnt,frdM->pnt[frdM->old]);
    mssGV.outCnt++;
  }
}

int readT(struct mssFPR *fprT, struct mssFldRec *frT){
  int statT;

  statT=mssReadFldRec(fprT,frT);
  if(statT!=EOF) mssGV.inCnt ++;
  return(statT);
}

/*============================================================================*/
/* version 1.00 2000/07/07 初期作成 hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    TKYT,   /* このオプションのタイトル(Helpで表示)                         */
    TKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 範囲比較される項目(一項目)                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optVAL={
    OFLD,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    VALT,   /* このオプションのタイトル(Helpで表示)                         */
    VALC,   /* このオプションのコメント(Helpで表示)                         */
    VALF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };


/*----------------------------------------------------------------------------*/
/* 参照キー項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* オプションタイプ                                             */
    "K",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
            /* 0:その他(上記の意味解釈がない)                               */
    MKYT,   /* このオプションのタイトル(Helpで表示)                         */
    MKYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 参照範囲項目(一項目)                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRNG={
    OFLD,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    RNGT,   /* このオプションのタイトル(Helpで表示)                         */
    RNGC,   /* このオプションのコメント(Helpで表示)                         */
    RNGF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 参照ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    MSTT,   /* このオプションのタイトル(Helpで表示)                         */
    MSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 結合項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "m",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 範囲を「より大きい〜以下」とするフラグ                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };


/*----------------------------------------------------------------------------*/
/* 入力outerJoin                                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTNL={
    OFLG,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TNLT,   /* このオプションのタイトル(Helpで表示)                         */
    TNLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/*マスター上のrangeマッチしない時も出力するフラグ                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optRNL={
    OFLG,   /* オプションタイプ                                             */
    "N",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    RNLT,   /* このオプションのタイトル(Helpで表示)                         */
    RNLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optVAL,&optMKY,&optMST,&optRNG,&optFLD,&optTNL,&optRNL,
               &optREV,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdM; /*参照ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fprT;/*入力ファイル構造体                */
  struct mssFPR       *fprM;/*参照ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFields    *sfT; /*ソート項目構造体                  */
  struct mssFields    *sfM; /*ソート項目構造体                  */
  int sortedT;              /*ソート済チェック用                */
  int sortedM;              /*ソート済チェック用                */
  struct KeyInfo       keyInfo;
  int statT;                /*mssReadFRK(Tra)のステータス*/
  int statM;                /*mssReadFRK(Mst)のステータス*/
  int fcT;                  /*入力データの項目数*/
  int fcM;                  /*参照データの項目数*/

  /*key break joinにて*/
  struct mssFldRec    *frT=NULL;
  struct mssFldRecDbl *frdM=NULL;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

  /*-Kが指定されていなければ-kをコピーする*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }

  /*-Rが指定されていなければ-vをコピーする*/
  if(!optRNG.set){
    mssCpyOptFld(&optRNG,&optVAL);
  }else{

    /*-vと-Rのオプション(%n等)が異っていれば-vに合わせる*/
    if(*optVAL.fldOpt != NULL){
      if( *optRNG.fldOpt == NULL){       /* -v のみオプションあり */
        *optRNG.fldOpt = *optVAL.fldOpt; /* 変更 2004/10/31 */
	           /* mssSetOptFldはoptRNGを先に呼び出さなければならない*/
      }
    }else{
      if( *optRNG.fldOpt != NULL){       /* -R のみオプションあり */
        *optRNG.fldOpt=NULL;
      }
    }
  }

  fprT=mssOpenFPR(optINF.str,4);    /*ファイルオープン*/
  fprM=mssOpenFPR(optMST.str,128);  /*マスターファイルオープン*/
  hdT=mssReadHeader(fprT);          /*項目名情報の読み込み*/
  hdM=mssReadHeader(fprM);          /*項目名情報の読み込み*/
 
  mssSetOptKey(&optTKY, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optRNG, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optVAL, hdT);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptKey(&optMKY, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  mssSetOptFld(&optFLD, hdM);       /* オプション項目をヘッダー項目に関連づけ*/
  
  /*traソート項目の作成*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sfT,optVAL.flds);/* -r 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfT);        /* ソート優先順位番号を登録順にふる   */
  sortedT=mssChkSorted(sfT,hdT);        /* ソート済かチェック                 */
  
  /*mstソート項目の作成*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sfM,optRNG.flds);/* -R 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sfM);        /* ソート優先順位番号を登録順にふる   */
  sortedM=mssChkSorted(sfM,hdM);        /* ソート済かチェック                 */
  
/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdT);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*新項目名を追加する*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!sortedT){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*グローバル変数セット*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTFLD=&optFLD;
  OPTVAL=&optVAL;
  OPTRNG=&optRNG;
  op=fpw;

  /*数値範囲か文字列範囲かをセットする(デフォルトは数値範囲)*/
  NSflg=0;
  if(mssIsFldOptOn(&optVAL,0,'n') ){
    NSflg=1;
  }

  if(!sortedT){
    fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
  }
  if(!sortedM){
    fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
  } 


  frT=mssInitFldRec(fcT);
  frdM=mssInitFRD(fcM);

  /*参照ファイルは、最初に2行読みこむ*/
  statM=mssReadFRD(fprM,frdM);
  if(statM!=EOF) statM=mssReadFRD(fprM,frdM);

  statT=readT(fprT,frT);

  keyInfo.keyCmp=0;
  keyInfo.rngCmp=0;
  keyInfo.rngFlg=optREV.set;
  while(1){

    /*TraだけEndの時*/
    if(statT==EOF){
      break;
    }

    /*MstだけEndの時*/
    if(statM==EOF){
      if(optTNL.set){
        writeTM(frT, NULL);
        statT=readT(fprT,frT);
        continue;
      }else{
        break;
      }
    }

    /* キー情報の設定 */
    setKeyInfo(&keyInfo,frT,frdM);

    if(keyInfo.keyCmp == 1){       /*-k,-Kにおいて T>M*/
      statM=mssReadFRD(fprM,frdM);
    }else if(keyInfo.keyCmp ==-1){ /*-k,-Kにおいて T<M*/
      if(optTNL.set){
        writeTM(frT, NULL);
      }
      statT=readT(fprT,frT);
    }else{                         /*-k,-Kにおいて T==M*/

      /*-k,-Kキーが同じ時、範囲を較べる*/
      while(1){
        if( keyInfo.rngCmp==9 ){        /* キーが同じでない */
          break;
        } else if( keyInfo.rngCmp== 1){ /* Tr>Mr */
          statM=mssReadFRD(fprM,frdM);
          if(statM==EOF) break;
        } else if( keyInfo.rngCmp==-1){ /* Tr<Mr */
          if(optRNL.set){
            writeTM(frT, NULL);
          }
          statT=readT(fprT,frT);
          if(statT==EOF) break;
        }else{            /* Tr=Mr Mrの現在の範囲内に入っている*/
          writeTM(frT,frdM);
          statT=readT(fprT,frT);
          if(statT==EOF) break;
        }
        setKeyInfo(&keyInfo,frT,frdM);
      }
    }
  }
  mssFreeFldRec(frT);
  mssFreeFRD(frdM);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssCloseFPR(fprT);      /*入力ファイルのクローズ      */
  mssCloseFPR(fprM);      /*入力ファイルのクローズ      */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssFreeFields(sfT);     /*ソート項目構造体の領域開放  */
  mssFreeFields(sfM);     /*ソート項目構造体の領域開放  */
  mssFreeHeader(hdT);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdM);     /*入力ヘッダ領域開放          */
  mssFreeHeader(hdo);     /*出力ヘッダ領域開放          */
  mssFreeOption(opt);     /*オプション領域開放          */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
