/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include <xtsedHelp.h>
struct mssComHelp comHelp={
  "xtsed",        /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};  
            
extern struct mssGlobalVariables mssGV;

/*置換文字(-v)を"&"でトークン分割した文字列リストを格納する構造体*/
/*"&"の意味は、マッチした文字列に置き換えられる、ということ*/
struct {
  int cnt;
  char **strList;
} REP;

int   GLB; /*グローバル置換フラグ*/
struct mssStrings *RepStr;
static regex_t *regex; /* 修正 2004/10/31 */

static void repCat(char *str, regmatch_t *mp){
  int i;

  mssCatStrings(RepStr,*(REP.strList+0));
  for(i=1; i<REP.cnt; i++){
    mssCatnStrings(RepStr,str+mp->rm_so,mp->rm_eo-mp->rm_so);
    mssCatStrings(RepStr,*(REP.strList+i));
  }
}

/*文字列strのマッチした箇所を-vの文字で置き換え、RepStrにセット*/
/*ex) str="abcde" reg="cd" v="###" -> RepStr="ab###" */
static char *setRepStr(char *str){
  regmatch_t mp;

  if( 0!=regexec(regex, str, 1, &mp,0) ){
    mssCatStrings(RepStr,str);           /*マッチしなければstrをcat*/
    return(NULL);
  }else{
    mssCatnStrings(RepStr,str,mp.rm_so); /*マッチ位置までの文字列をcat*/
    repCat(str,&mp);                  /*置換文字列をcatする*/
    str=str+mp.rm_eo;                 /*次の文字列の先頭をセット*/
    return(str);
  }
}

static char *getRepStr(char *str){
  
  if(MssIsNull(str)) return(MssNullStr);
  mssFreeStrings(RepStr);
  RepStr=mssInitStrings();

  if(GLB){
    while(1) {
      if( NULL == (str=setRepStr(str)) ){
        break;
      }
    }
  }else{
    str=setRepStr(str);
    if(NULL!=str) mssCatStrings(RepStr,str);
  }
  if(RepStr->cnt >= MssFieldMaxLen){
    return(MssNullStr);
  }else if(mssIsValidStr(RepStr->str)){
    return(RepStr->str);
  }else{
    return(MssNullStr);
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*//*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 正規表現                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optREG={
    OSTR,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    100,    /* 文字列の最大長                                               */
    REGT,   /* このオプションのタイトル(Helpで表示)                         */
    REGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 置換文字列                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optREP={
    OSTR,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    0,      /* 文字列の最小長                                               */
    100,    /* 文字列の最大長                                               */
    REPT,   /* このオプションのタイトル(Helpで表示)                         */
    REPC    /* このオプションのコメント(Helpで表示)                         */
  };
     
/*----------------------------------------------------------------------------*/
/* 新しい項目として出力するフラグ                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNEW={
    OFLG,   /* オプションタイプ                                             */
    "A",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    NEWT,   /* このオプションのタイトル(Helpで表示)                         */
    NEWC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* グローバル置換フラグ                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLG optGLB={
    OFLG,   /* オプションタイプ                                             */
    "g",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    GLBT,   /* このオプションのタイトル(Helpで表示)                         */
    GLBC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };
  
/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optREG,&optREP,&optNEW,&optGLB,
               &optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRec    *fr;  /*項目-行バッファ構造体             */

  int i;
  char *pos;
  char tmp[MssFieldMaxLen];

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

  if( strchr(optREP.str,'*') != NULL ){
    mssShowErrMsg("-v can not have NULL character");
    mssEnd(mssErrorNoDefault);
  }

  /*置換文字列の"&"によるトークン分割*/
  /*ただし、\&のようなエスケープを処理するために、一旦&を*に変換して作成*/
  /* "*"は指定できない文字なのでOK*/
  /* また無意味な"\"は除外*/
  i=0;
  pos=optREP.str;
  while(*pos!='\0'){
    if(*pos=='\\'){
      if( *(pos+1) == '&' ){
        tmp[i]='&';
        i++;
        pos++;
      }
    }else if(*pos=='&'){
      tmp[i]='*'; i++;
    }else{
      tmp[i]=*pos; i++;
    }
    pos++;
  }
  tmp[i]='\0';

  REP.strList=mssTokByChr(tmp,'*',&REP.cnt,1);

  GLB =optGLB.set; /*グローバル置換*/

  /*正規表現のコンパイル*/
  regex=mssMalloc(sizeof(regex_t),"xtsed"); /* 追加 2004/10/31 */
  if(regcomp(regex,optREG.str,REG_EXTENDED) ){
    mssShowErrMsg("error in compiling regex");
    mssEnd(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/

  /*新項目名を追加する*/
  if(optNEW.set){
    mssAddFieldsByFields(hdo->flds,hdi->flds);
    mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*-fで指定された項目は-fから、その他は入力ヘッダから項目を追加する*/
  }else{
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  fr=mssInitFldRec(hdi->flds->cnt);
  RepStr=mssInitStrings();
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    /*新項目追加の場合*/
    if(optNEW.set){
      mssWriteFld(fr->pnt,fr->fldCnt,"",fpw);
      for(i=0; i<optFLD.flds->cnt; i++){
        mssWriteDlm(fpw);
        mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(optFLD.flds,i))),fpw);
      }
      mssWriteRet(fpw);

    /*新項目置換の場合*/
    }else{
      for(i=0; i<hdi->flds->cnt; i++){
        if( *(optFLD.fldNo2optNo+i)==-1){
          mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
        }else{
          mssWriteStr(getRepStr(*(fr->pnt+MssFlds2num(hdi->flds,i))),fpw);
        }
        if(i==hdi->flds->cnt-1) mssWriteRet(fpw);
        else                    mssWriteDlm(fpw);
      }
    }
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);
  mssFreeStrings(RepStr);
  mssFree(*REP.strList);
  mssFree(REP.strList);

  regfree(regex); /* 追加 2004/10/31 */
  mssFree(regex); /* 追加 2004/10/31 */

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);     /* フッターの出力             */
  mssCloseFPR(fpr);        /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);        /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);      /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);      /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);      /* オプション領域開放         */
  mssShowEndMsg();         /* 完了メッセージ             */
  mssEnd(mssExitSuccess);  /* 終了                       */                   
  return(0);               /* to avoid warning message   */
}
