/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応                                                      */
/*============================================================================*/
  
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtselHelp.h>
struct mssComHelp comHelp={
  "xtsel",        /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */                                      
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

extern int keyNo;
extern int keyCnt;
extern int keyLine;
extern int line;
extern struct StrList *rslList;

int Rev;      /*リバースフラグ*/

int sel(MssValue rsl){
  if( Rev ){
    if( rsl.nul      ) return(0);
    if( (int)rsl.v.d ) return(0);
    else          return(1);
  }else{
    if( rsl.nul      ) return(0);
    if( (int)rsl.v.d ) return(1);
    else          return(0);
  }
}

/*============================================================================*/
/*メインルーチン                                                              */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ソート項目                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optSRT={
    OFLD,   /* オプションタイプ                                             */
    "s",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n,r",  /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    SRTT,   /* このオプションのタイトル(Helpで表示)                         */
    SRTC,   /* このオプションのコメント(Helpで表示)                         */
    SRTF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 計算式                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCAL={
    OSTR,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,    /* 文字列の最大長                                               */
    CALT,   /* このオプションのタイトル(Helpで表示)                         */
    CALC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* -k指定時の行毎に処理するフラグ                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSGL={
    OFLG,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SGLT,   /* このオプションのタイトル(Helpで表示)                         */
    SGLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* レコード間ANDフラグ                                                        */
/*----------------------------------------------------------------------------*/
  MssOptFLG optARC={
    OFLG,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ARCT,   /* このオプションのタイトル(Helpで表示)                         */
    ARCC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 選択反転フラグ                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 範囲外出力ファイル                                                         */
/*----------------------------------------------------------------------------*/
  MssOptOTF optNOF={
    OOTF,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NOFT,   /* このオプションのタイトル(Helpで表示)                         */
    NOFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optSRT,&optCAL,&optSGL,&optARC,&optREV,&optNOF,
               &optSEQ,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;  /* 入力ファイル用<head>タグ格納構造体 */
  struct mssHeader    *hdo;  /* 出力ファイル用<head>タグ格納構造体 */
  struct mssFPR       *fpr;  /* 入力ファイル構造体                 */
  struct mssFPW       *fpw;  /* 出力ファイル構造体                 */
  struct mssFPW       *fpw2; /* 条件不一致ファイル構造体           */
  struct mssFldRecKey *frk;  /* 項目-行キーバッファ構造体          */
  struct mssFldRec    *fr;   /* 項目-行バッファ構造体              */
  struct mssFields    *sf;   /* ソート項目構造体                   */
  int sorted;                /* ソート済チェック用                 */

  struct mssCal *cal=NULL;  /*計算式をパースする構造体     */
  int         lineSel;
  MssValue    rsl;
  int         finalSel=0;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optSRT, hdi);        /* -s 項目をヘッダー項目に関連づける     */
    
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sf,optSRT.flds); /* -s 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/                                                       

  Rev=optREV.set; /*リバースフラグのグローバル化*/

/*----------------------------------------------------------------------------*/
/*計算式の評価                                                                */
/*----------------------------------------------------------------------------*/
  cal=mssCalCompile(optCAL.str,hdi);

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);
  
  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!optSEQ.set && !sorted && optKEY.set){
    mssSetFieldsSort(hdo->flds,sf);
  } 
  
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

  /*条件不一致出力オープン+ヘッダーの出力*/
  if(optNOF.set){
    fpw2=mssOpenFPW(optNOF.str,optZIP.set,0);
    mssWriteHeader(hdo, fpw2);
  }else{
    fpw2=NULL;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if( !optSEQ.set && !sorted && (optKEY.set || optSRT.set) )
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*キー単位撰択でない場合*/
  if(optKEY.diffSame==1){

    /*FldRec構造体の初期化*/
    fr=mssInitFldRec(hdi->flds->cnt);

    /*calculationで利用する読込関数を登録*/
    mssCalReadFuncIsFldRec(cal,fr);

    /*データ読み込み*/
    mssGV.keyCnt=1;
    mssGV.keyNo =0;
    mssGV.keyLine=0;

    while( EOF != mssReadFldRec(fpr,fr) ){
      mssGV.inCnt++;

      /*計算実行*/
      rsl = mssCalculate(cal, fr->pnt);

      if(rsl.nul){
        lineSel=sel(rsl);
      }else if(rsl.vType==DBL){
        lineSel=sel(rsl);
      }else{
        lineSel=sel(mssVs2d(rsl));
      }

      if(lineSel){
        mssWriteFld(fr->pnt, fr->fldCnt, "\n", fpw);
        mssGV.outCnt++;
      }else{
        if(optNOF.set){
          mssWriteFld(fr->pnt, fr->fldCnt, "\n", fpw2);
        }
      }
    }
    mssFreeFldRec(fr);

  /*キー単位撰択の場合*/
  }else{

    /*FRK構造体の初期化*/
    frk=mssInitFRK(hdi->flds->cnt, &optKEY, optTMP.str);

    /*calculationで利用する読込関数を登録*/
    mssCalReadFuncIsFRK(cal,frk);

    while(1){
      /*データ読み込み*/
      if(EOF==mssReadFRK(fpr,frk)) break;
      mssGV.keyCnt=frk->keyRecCnt;
      mssGV.keyNo =frk->keyNo;
      mssGV.keyLine=0;
      while(1){
        if(EOF==mssReadFldRecFRK(frk)) break;
        mssGV.inCnt++;
        mssGV.keyLine++; /*キー内での現在処理中行番号*/

        /*計算実行*/
        rsl = mssCalculate(cal, frk->pnt);

        if(rsl.nul){
          lineSel=sel(rsl);
        }else if(rsl.vType==DBL){
          lineSel=sel(rsl);
        }else{
          lineSel=sel(mssVs2d(rsl));
        }

        /*キー毎撰択の場合*/
        if(!optSGL.set){
          /*and条件*/
          if( optARC.set ){
            if(lineSel){finalSel=1; continue;}
            else       {finalSel=0; break   ;}

          /*or条件*/
          }else{
            if(lineSel){finalSel=1; break   ;}
            else       {finalSel=0; continue;}
          }

        /*行毎撰択の場合*/
        }else{
          if(lineSel){
            mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw);
            mssGV.outCnt++;
          }else{
            if(optNOF.set){
              mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw2);
            }
          }
        }
      }

      /*キー毎撰択の場合*/
      if(!optSGL.set){
        if(finalSel){
          mssSeekTopFRK(frk);
          while( EOF != mssReadFldRecFRK(frk) ){
            mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw);
            mssGV.outCnt++;
          }
        }else{
          if(optNOF.set){
            mssSeekTopFRK(frk);
            while( EOF != mssReadFldRecFRK(frk) ){
              mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw2);
            }
          }
        }
      }
    }
    mssFreeFRK(frk);
  }
  mssCalFree(cal);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());                */
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssWriteFooter(fpw2);   /* フッターの出力             */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssCloseFPW(fpw2);      /* 出力ファイルのクローズ     */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
