/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : 新しい乱数APIに対応 2004/01/26                                     */
/*============================================================================*/
  
#include <musashi.h>
#include <stdlib.h>
#include <limits.h>

#include <xtselrandHelp.h>
struct mssComHelp comHelp={
  "xtselrand",    /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
}; 

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 選択件数                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optCNT={
    OINT,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    CNTT,   /* このオプションのタイトル(Helpで表示)                         */
    CNTC    /* このオプションのコメント(Helpで表示)                         */
  };        
    
/*----------------------------------------------------------------------------*/
/* 選択件数(割合)                                                             */
/*----------------------------------------------------------------------------*/
  MssOptDBL optPCT={
    ODBL,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    100,    /* 最大値                                                       */
    PCTT,   /* このオプションのタイトル(Helpで表示)                         */
    PCTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 乱数の種                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optSED={
    OINT,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    -1,     /* デフォルト(数値として指定)                                   */
    -1,     /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    SEDT,   /* このオプションのタイトル(Helpで表示)                         */
    SEDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 条件不一致出力ファイル                                                     */
/*----------------------------------------------------------------------------*/
  MssOptOTF optNOF={
    OOTF,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NOFT,   /* このオプションのタイトル(Helpで表示)                         */
    NOFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };


/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optCNT,&optPCT,&optSED,&optNOF,&optSEQ,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;      /* 入力ファイル用<head>タグ格納構造体       */
  struct mssHeader    *hdo;      /* 出力ファイル用<head>タグ格納構造体       */
  struct mssFPR       *fpr;      /* 入力ファイル構造体                       */
  struct mssFPW       *fpw;      /* 出力ファイル構造体                       */
  struct mssFPW       *fpw2;     /* 条件不一致出力ファイル構造体             */
  struct mssFldRecKey *frk=NULL; /* 項目-キーバッファ構造体                  */
  struct mssFields    *sf;       /* ソート項目構造体                         */
  int sorted;                    /* ソート済チェック用                       */

  int select;
  int remaining;
  int r;                   /*元データのwhile内行数カウンタ*/

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* オプション項目をヘッダー項目に関連づけ*/
    
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

  if(optCNT.set + optPCT.set != 1){
    mssShowErrMsg("must specify either -c or -p");
    mssEnd(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!optSEQ.set && !sorted){
    mssSetFieldsSort(hdo->flds,sf);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);


  /*条件不一致出力オープン+ヘッダーの出力*/
  if(optNOF.set){
    fpw2=mssOpenFPW(optNOF.str,optZIP.set,0);
    mssWriteHeader(hdo, fpw2);
  }else{
    fpw2=NULL;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if(!optSEQ.set && !sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  mssInitRand(optSED.val); /*乱数初期化*/

  /*FRK構造体の初期化*/
  frk=mssInitFRK(hdi->flds->cnt, &optKEY, optTMP.str);

  while(1){
    /*データ読み込み*/
    if(EOF==mssReadFRK(fpr,frk)) break;
    
    /*サンプリング*/
    remaining=frk->keyRecCnt;
    if(optCNT.set)select=optCNT.val;
    else          select=(int)((optPCT.val/(double)100)*(double)frk->keyRecCnt);
    if(select>frk->keyRecCnt) select=frk->keyRecCnt;
    r=0;
    while( EOF != mssReadFldRecFRK(frk) ){
      mssGV.inCnt++;
      if( (mssIRand(0,mssRandMax-1)%remaining) < select ){
        mssWriteFld(frk->pnt,frk->fldCnt,"\n",fpw);
        mssGV.outCnt++;
        select--;
      }else{
        if(optNOF.set){
          mssWriteFld(frk->pnt,frk->fldCnt,"\n",fpw2);
        }
      }
      r++;
      remaining--;
    }
  }
  mssFreeFRK(frk);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssWriteFooter(fpw2);   /*フッターの出力              */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssCloseFPW(fpw2);      /*出力ファイルのクローズ      */
  mssCloseFPR(fpr);       /*入力ファイルのクローズ      */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
