/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>

#include <xtselstrHelp.h>
struct mssComHelp comHelp={
  "xtselstr",     /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int REV; /*条件反転フラグ*/
int AND; /*項目間andフラグ*/

int sel(char **pnt, struct mssFields *fld, struct mssHash *hash){
  int  sel=0;
  char *str;
  int  i;

  for(i=0; i<fld->cnt; i++){
    str=*(pnt+MssFlds2num(fld,i));
    if( REV ){
      if( AND ){
        if( mssHashMember(hash,str) ){sel=0; continue;}
        else                         {sel=1; break   ;}
      }else{
        if( mssHashMember(hash,str) ){sel=0; break   ;}
        else                         {sel=1; continue;}
      }
    }else{
      if( AND ){
        if( mssHashMember(hash,str) ){sel=1; continue;}
        else                         {sel=0; break   ;}
      }else{
        if( mssHashMember(hash,str) ){sel=1; break   ;}
        else                         {sel=0; continue;}
      }
    }
  }
  return(sel);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };
            
/*----------------------------------------------------------------------------*/
/* 検索文字列リスト                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSLS optVAL={
    OSLS,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    50,     /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldMaxLen,/* 各要素の文字列長の最大値                              */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    VALT,   /* このオプションのタイトル(Helpで表示)                         */
    VALC    /* このオプションのコメント(Helpで表示)                         */
  }; 
  
/*----------------------------------------------------------------------------*/
/* 項目間ANDフラグ                                                            */
/*----------------------------------------------------------------------------*/
  MssOptFLG optAND={
    OFLG,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ANDT,   /* このオプションのタイトル(Helpで表示)                         */
    ANDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* レコード間ANDフラグ                                                        */
/*----------------------------------------------------------------------------*/
  MssOptFLG optARC={
    OFLG,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ARCT,   /* このオプションのタイトル(Helpで表示)                         */
    ARCC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 選択反転フラグ                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    REVT,   /* このオプションのタイトル(Helpで表示)                         */
    REVC    /* このオプションのコメント(Helpで表示)                         */
  };
            
/*----------------------------------------------------------------------------*/
/* 範囲外出力ファイル                                                         */
/*----------------------------------------------------------------------------*/
  MssOptOTF optNOF={
    OOTF,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NOFT,   /* このオプションのタイトル(Helpで表示)                         */
    NOFC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optVAL,&optAND,&optARC,&optREV,&optNOF,
               &optSEQ,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;     /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo;     /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr;     /*入力ファイル構造体                */
  struct mssFPW       *fpw;     /*出力ファイル構造体                */
  struct mssFPW       *fpw2;    /*条件不一致ファイル構造体          */
  struct mssFldRecKey *frk;     /*項目-行キーバッファ構造体         */
  struct mssFldRec    *fr=NULL; /*項目-行バッファ構造体             */
  struct mssFields    *sf;      /*ソート項目構造体                  */
  int sorted;                   /*ソート済チェック用                */

  struct mssHash *hash;
  int lineSel;
  int finalSel=0;
  MssValue v;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */
    
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/
    
  REV=optREV.set;               /*リバースフラグのグローバル化*/
  AND=optAND.set;               /*項目間andフラグのグローバル化*/

  /*ハッシュテーブルの作成*/
  mssVinit(&v,STR); /*dummy*/
  hash=mssInitHash(101);
  for(i=0; i<optVAL.cnt; i++){
    mssHashInsert(hash,*(optVAL.strList+i),v);
  }
  /*mssShowHash(hash);*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*ソートする必要があるならばsfのソート情報を反映*/
  if(!optSEQ.set && !sorted){
    mssSetFieldsSort(hdo->flds,sf);
  }

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

  /*条件不一致出力オープン+ヘッダーの出力*/
  if(optNOF.set){
    fpw2=mssOpenFPW(optNOF.str,optZIP.set,0);
    mssWriteHeader(hdo, fpw2);
  }else{
    fpw2=NULL;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*キー単位撰択でない場合*/
  if(optKEY.diffSame==1){

    fr =mssInitFldRec(hdi->flds->cnt);
    while( EOF != mssReadFldRec(fpr,fr) ){
      mssGV.inCnt++;

      lineSel=sel(fr->pnt, optFLD.flds, hash);
      if(lineSel){
        mssWriteFld(fr->pnt, fr->fldCnt, "\n", fpw);
        mssGV.outCnt++;
      }else{
        if(optNOF.set){
          mssWriteFld(fr->pnt, fr->fldCnt, "\n", fpw2);
        }
      }
    }
    mssFreeFldRec(fr);

  /*キー単位撰択の場合*/
  }else{
    /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
    if(!optSEQ.set && !sorted && optKEY.set)
      fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);      

    /*FRK構造体の初期化*/
    frk=mssInitFRK(hdi->flds->cnt, &optKEY,optTMP.str);

    while(1){
      /*データ読み込み*/
      if(EOF==mssReadFRK(fpr,frk)) break;
      mssGV.inCnt+=frk->keyRecCnt;

      while( EOF != mssReadFldRecFRK(frk) ){
        lineSel=sel(frk->pnt, optFLD.flds, hash);

        if( REV ){
          /*and条件*/
          if( optARC.set ){
            if(lineSel){finalSel=0; continue;}
            else       {finalSel=1; break   ;}

          /*or条件*/
          }else{
            if(lineSel){finalSel=0; break   ;}
            else       {finalSel=1; continue;}
          }

        }else{

          /*and条件*/
          if( optARC.set ){
            if(lineSel){finalSel=1; continue;}
            else       {finalSel=0; break   ;}

          /*or条件*/
          }else{
            if(lineSel){finalSel=1; break   ;}
            else       {finalSel=0; continue;}
          }
        }
      }

      if(finalSel){
        mssSeekTopFRK(frk);
        while( EOF != mssReadFldRecFRK(frk) ){
          mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw);
          mssGV.outCnt++;
        }
      }else{
        if(optNOF.set){
          mssSeekTopFRK(frk);
          while( EOF != mssReadFldRecFRK(frk) ){
            mssWriteFld(frk->pnt, frk->fldCnt, "\n", fpw2);
          }
        }
      }
    }
    mssFreeFRK(frk);
  }
  mssFreeHash(hash);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);    /*フッターの出力              */
  mssWriteFooter(fpw2);   /*フッターの出力              */
  mssCloseFPW(fpw);       /*出力ファイルのクローズ      */
  mssCloseFPW(fpw2);      /*出力ファイルのクローズ      */
  mssCloseFPR(fpr);       /*入力ファイルのクローズ      */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
