/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/* 1.1 : -d $a$bのように連続する項目名の指定での不具合修正 2003/08/07         */
/* 1.2 : setFLdNameの無限ループ修正  2003/08/07                               */
/* 1.3 : NULLを含む行は出力しないように変更  2004/01/29                       */
/* 1.4 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtsepHelp.h>
struct mssComHelp comHelp={
  "xtsep",        /* コマンド名       */
  "1.4",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

/*パス内容構造体*/
struct Path {
  char *str[50];
  struct mssFields *flds;
  char *endStr;
  int cnt;
  char *optStr; /*オプションの指定形式に変換したもの*/
};

/*------------------------------------------------------------------------------
項目名をbufに設定し、項目名の次のポインタを返す
$は\0に変換
ex)
str=$Customer/aaa/$(Date).gz
buf="Customer"
end="/aaa/$(Date).gz"
------------------------------------------------------------------------------*/
char *setFldName(char *buf,char *str){
  char *end;
  int i=0;

  *str='\0'; /* $は\0に変換 */

  str++;
  if(*str=='('){
    end=mssSkipStrBlock(str,'(',')');
    *(end-1)='\0';
    strcpy(buf,str+1);
  }else{
    end=str;
    while(*end!='/' && *end!='\0' && *end!='$'){
      if(i>=MssFieldNameMaxLen){
        mssShowErrMsg("too long field name on -d");
        mssEnd(mssErrorNoDefault);
      }
      *(buf+i)=*end;
      end++; i++;
    }
    *(buf+i)='\0';
  }
  return(end);
}

/*------------------------------------------------------------------------------
-dオプションからPath構造体にセットする。
ex)
-d /tmp/$Customer/aaa/$(Date).gz
p->str[0]="/tmp/"   ,   p->fld[0]=$Cusotmer
p->str[1]="/aaa/"   ,   p->fld[1]=$Date
p->endStr=".gz"
p->cnt=2
p->optStr="Customer,Date"
------------------------------------------------------------------------------*/
struct Path *setPath(char *path, struct mssHeader *hd){
  struct Path *p;
  char buf[MssFieldNameMaxLen];
  char opt[1024];
  char *str;

  p=mssCalloc(sizeof(struct Path),"setOptFld");
  p->flds=mssInitFields();
  p->cnt=0;
  opt[0]='\0';

  str=path;
  while(*path!='\0'){
    if(*path=='$'){
      if(p->cnt>=50){
        mssShowErrMsg("too many field names on -d");
        mssEnd(mssErrorNoDefault);
      }

      /*項目のセット*/
      path=setFldName(buf,path);
      strcat(opt,buf); strcat(opt,",");
      mssAddFieldsByFldInfo(p->flds,mssFldNam2Add(hd->flds,buf));

      /*項目の前の文字のセット*/
      p->str[p->cnt]=str;
      str=path;

      /*カウントアップ*/
      p->cnt++;
    }else{
      path++;
    }
  }
  if(p->cnt==0){
    mssShowErrMsg("no field name on -d");
    mssEnd(mssErrorNoDefault);
  }
  p->endStr=str;

  opt[strlen(opt)-1]='\0';
  p->optStr=mssStrdup(opt);

  return(p);
}

/*------------------------------------------------------------------------------
Path構造体と実際のデータレコードから、実ファイル名を設定する
ファイル名にNULL値を含むと-1を返す。
------------------------------------------------------------------------------*/
int setPathName(
  char *pathName,
  struct Path *path,
  struct mssFldRecDbl *frd,
  MssOptKEY *optKey){

  int i;
  int len=1; /*1は末尾文字'\0'のため*/

  *pathName='\0';
  for(i=0; i<path->cnt; i++){
    /*ファイル名長のチェック*/
    len+=strlen(path->str[i])+strlen(*frd->pnt[frd->new]);
    if(len>=MssFileNameMaxLen) {
      mssShowErrMsg("path name exceed 1024 charactors");
      mssEnd(mssErrorNoDefault);
    }

    /*項目の値がNULLならば-1を返す*/
    if(MssIsNull(*(frd->pnt[frd->new]+MssFlds2num(path->flds,i))) ){
      return(-1);
    }

    /*文字列とデータ値を連結していく*/
    strcat(pathName,path->str[i]);
    strcat(pathName,*(frd->pnt[frd->new]+MssFlds2num(path->flds,i)));
  }
  /*最後の末尾の文字列を連結*/
  len+=strlen(path->endStr);
  if(len>=MssFileNameMaxLen){
    mssShowErrMsg("path name exceed 1024 charactors");
    mssEnd(mssErrorNoDefault);
  }
  strcat(pathName,path->endStr);
  return(0);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目(内部的に利用、パラメータでは指定できない                          */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル名                                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDIR={
    OSTR,   /* オプションタイプ                                             */
    "d",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL  , /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    DIRT,   /* このオプションのタイトル(Helpで表示)                         */
    DIRC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 強制ディレクトリ作成                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLG optFRC={
    OFLG,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    FRCT,   /* このオプションのタイトル(Helpで表示)                         */
    FRCC    /* このオプションのコメント(Helpで表示)                         */
  };


/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optDIR,&optFRC,&optINF,&optZIP,&optTXT,&optTMP,NULL};
  void *optInside[]={&optKEY,NULL}; /* 追加 2004/10/31 */

    
/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw=NULL; /*出力ファイル構造体                */
  struct mssFldRecDbl *frd; /*項目-二行バッファ構造体           */
  struct mssFields    *sf;  /*ソート項目構造体                  */
  int sorted;               /*ソート済チェック用                */

  struct Path *path;
  char pathName[MssFileNameMaxLen];
  int count;
  int nulStat=0;
/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */

  path=setPath(optDIR.str,hdi);   /*path情報をセット*/

  /* optKeyをここで強制定義する*/
  optKEY.type=OKEY; /* 追加 2004/10/31 */
  optKEY.set=1;
  optKEY.str=mssStrdup(path->optStr);
  optKEY.cnt=0;
  optKEY.nam=mssTokByChr(optKEY.str,',',&optKEY.cnt,1); /*,によるトークン分割*/
  optKEY.diffSame=0;
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */

  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);                                
    
  /*ソートする必要があるならばsfのソート情報を反映*/                        
  if(!sorted){
    mssSetFieldsSort(hdo->flds,sf);
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if(!sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  frd=mssInitFRD(hdi->flds->cnt);
  while( EOF!=mssReadFRD(fpr,frd) ){

    if(mssGV.inCnt==0){
      nulStat=setPathName(pathName,path,frd,&optKEY);
      if(nulStat==0){
        fpw=mssOpenFPW(pathName,optZIP.set,optFRC.set);
        mssWriteHeader(hdo, fpw);
      }
    }

    /*キーブレイク時の処理*/
    if(mssKeyBreak(frd, &optKEY)){
      if(nulStat==0){
        mssWriteFooter(fpw);    /*フッターの出力*/
        mssCloseFPW(fpw);                /*出力ファイルのクローズ*/
      }
      if(frd->eof) break;
      nulStat=setPathName(pathName,path,frd,&optKEY);
      if(nulStat==0){
        fpw=mssOpenFPW(pathName,optZIP.set,optFRC.set);
        mssWriteHeader(hdo, fpw);
      }
    }

    mssGV.inCnt++;
    count++;

    /*通常行の処理*/
    if(nulStat==0){
      mssWriteFld(frd->pnt[frd->new],frd->fldCnt,"\n",fpw);
      mssGV.outCnt++;
    }
  }
  mssFreeFRD(frd);
  mssFreeFields(path->flds);
  mssFree(path->optStr);
  mssFree(path);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);       /*入力ファイルのクローズ      */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssFreeOption(optInside); /*オプション領域開放*/
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
