/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/06/20                                           */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtsubstrHelp.h>
struct mssComHelp comHelp={
  "xtsubstr",     /* コマンド名       */
  "1.0",          /* バージョン       */                                    
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */                                    
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */ 
};  

extern struct mssGlobalVariables mssGV;

MssOptRNG *RNG;

/*----------------------------------------------------------------------------*/
/* substrを作成し書き出す                                                     */
/*----------------------------------------------------------------------------*/
void writeSubStr(char *str, struct mssFPW *fpw){
  struct mssStrings *subStr;
  int i;
  int from,to;
  int len;

  if(MssIsNull(str)){
    mssWriteNull(fpw);
    return;
  }

  len=strlen(str);
  subStr=mssInitStrings();
  for(i=0; i<RNG->cnt; i++){
    from=*(RNG->from+i);
    to  =*(RNG->to  +i);
    if( from>len ) continue;
    if( from>to  ) continue;
    mssCatnStrings(subStr,str+from-1,to-from+1);
  }

  if(subStr->str==NULL) mssWriteNull(fpw);
  else                  mssWriteStr(subStr->str,fpw);
  mssFreeStrings(subStr);
}


int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 選択範囲                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptRNG optRNG={
    ORNG,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列として指定する)                             */
    50,     /* カンマで区切られる要素数の最大値                             */
    1,      /* 値の最小値                                                   */
    MssFieldMaxLen,/* 値の最大値                                            */
    RNGT,   /* このオプションのタイトル(Helpで表示)                         */
    RNGC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新しい項目として出力する                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optNEW={
    OFLG,   /* オプションタイプ                                             */
    "A",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    NEWT,   /* このオプションのタイトル(Helpで表示)                         */
    NEWC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optFLD,&optRNG,&optNEW,
               &optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体                */
  struct mssFPW    *fpw; /*出力ファイル構造体                */
  struct mssFldRec *fr;  /*項目-行バッファ構造体             */

  int fldNo;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

  RNG=&optRNG;
  fldNo=MssFlds2num(optFLD.flds,0); /*-f項目の項目番号セット*/

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/

  /*新項目名を追加する*/
  if(optNEW.set){
    mssAddFieldsByFields(hdo->flds,hdi->flds);
    mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*-fで指定された項目は-fから、その他は入力ヘッダから項目を追加する*/
  }else{ 
    mssAddHeadOrOptFields(hdo->flds,hdi,&optFLD);
  }
  
  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    /*新項目として扱う場合*/
    if(optNEW.set){
      mssWriteFld(fr->pnt,fr->fldCnt,"",fpw);
      mssWriteDlm(fpw);
      writeSubStr(*(fr->pnt+fldNo),fpw);
      mssWriteRet(fpw);

    /*項目を置換する場合*/
    }else{
      /*writeFldで置き換えること*/
      for(i=0; i<hdi->flds->cnt; i++){
        if(fldNo==MssFlds2num(hdi->flds,i)){
          writeSubStr(*(fr->pnt+fldNo),fpw);
        }else{
          mssWriteStr(*(fr->pnt+MssFlds2num(hdi->flds,i)),fpw);
        }
        if(i==hdi->flds->cnt-1) mssWriteRet(fpw);
        else                    mssWriteDlm(fpw);

      }
    }
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);     /* フッターの出力             */
  mssCloseFPR(fpr);        /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);        /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);      /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);      /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);      /* オプション領域開放         */
  mssShowEndMsg();         /* 完了メッセージ             */
  mssEnd(mssExitSuccess);  /* 終了                       */
  return(0);               /* to avoid warning message   */
}
