// Original Source Code Copyrighted by Akihiro Inokuchi in 1999.
// Modified and Extended to Introduce PMML Interface,and the
// Extented Part Copyright by Yuki Mitsunaga and Takashi Washio in 2004
//  このプログラムがメインです。
//
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xmlmemory.h>
#include <libxml/tree.h>
#include <musashi.h>
#include <pmmlagmHelp.h>

struct mssComHelp comHelp={
  "agm",          /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};
extern struct mssGlobalVariables mssGV;



#define trie_size 1000000
#define entries_size 100000
#define Transaction_num 10000
#define ESFG 20 /*expected size of maximal frequent graphs*/
char g_type;/*type=1 => directed,type=2 => undirected*/
unsigned long ntypenum;
char ltypenum,encoding[40],copyright[256],modelname[256]="",description[256]="",wfp[256];

#include "matgen.c"
#include "gauss.c"
#include "defstruct.c"
#include "readdata2.c"
#include "apriori4.c"
#include "treesize.c"
#include "disppatn1_2.c"

unsigned long trie_pos;
unsigned long transaction_num=Transaction_num;

cmatrix Adj1,Adj2,Space,Tramat,Dummy0;

struct graph transaction[Transaction_num];
struct trie_node trie[trie_size];

int main(int argc, char *argv[])
{
	unsigned long size=200;
	double sup;
	char filename[256],opf[256];


/*----------------------------------------------------------------------------*/
/* 信頼度                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptDBL optSUP={
    ODBL,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    30,     /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    100,    /* 最大値                                                       */
    SUPT,   /* このオプションのタイトル(Helpで表示)                         */
    SUPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル名                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 結果出力ファイル                                                           */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOPF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* グラフ名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSTR optGRD={
    OSTR,   /* オプションタイプ                                             */
    "G",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "",     /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,      /* 文字列の最大長                                               */
    GRDT,   /* このオプションのタイトル(Helpで表示)                         */
    GRDC    /* このオプションのコメント(Helpで表示)                         */
  };

  
/*------------------------------------------------------------------------------*/
/* copyright                                                                  */
/*----------------------------------------------------------------------------*/
  MssOptSTR optCPR={
    OSTR,   /* オプションタイプ                                             */
    "R",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "",     /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    256,      /* 文字列の最大長                                              */
    CPRT,   /* このオプションのタイトル(Helpで表示)                         */
    CPRC    /* このオプションのコメント(Helpで表示)                         */
  }; 

/*------------------------------------------------------------------------------*/
/* ワークファイルパス                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optWFP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir,/* デフォルト(変更:hamuro 2004/08/21)                        */
    1,      /* 文字列の最小長                                               */
    256,      /* 文字列の最大長                                              */
    WFPT,   /* このオプションのタイトル(Helpで表示)                         */
    WFPC    /* このオプションのコメント(Helpで表示)                         */
  };                                                               

     
void *opt[]={&optSUP,&optINF,&optOPF,&optGRD,&optCPR,&optWFP, NULL};


	Adj1=cmat(size,size);
	Adj2=cmat(size,size);
	Space=cmat(size,size);
	Tramat=cmat(size,size);
	Dummy0=cmat(120,120);

  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  mssGV.usedTempFileFlg=1;
  mssGV.tmpPath=mssStrdup(optWFP.str);

  if(optINF.set == 0){
    strcpy(filename,"/dev/stdin");
  }
  else{
    strcpy(filename,optINF.str);
  }
  if(optOPF.set == 0){
    strcpy(opf,"/dev/stdout");
  }
  else{
    strcpy(opf,optOPF.str);
  }
  
  strcpy(wfp,optWFP.str);
	
	sup=optSUP.val/100;
	strcpy(copyright,optCPR.str);

	readdata2(filename);

	if(optCPR.set == 1){
	  strcpy(copyright,optCPR.str);
	}
	if(optGRD.set ==1){
	  strcpy(description,optGRD.str);
	}

	apriori4(sup,1);
	treesize();

	disppatn1_2(opf);

	decode2(Adj1,trie[127].item);

	/*printf("END");*/
	mssShowMsg("AGM END");


  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
	return 0;
}
