//  猪口さんが制作したプログラムです。
//  グラフ解析 Ver.4 用
//  '2000/10/03
//

void fromutf(char *filename); //UTF-8から元の文字コードに戻すための関数

extern char encoding[40],g_type,copyright[256],modelname[256],description[256];

void disppatn1_2(char *opf)
{
	unsigned long i,j,k=0,len,atm_num,bnd_num,e_id;
	double d;
	char fname[300],nwrd[20][20],lwrd[20][20],num[10];
	cmatrix adjmat;
	FILE *fp;
	xmlDocPtr doc;
	xmlNodePtr cur,curtmp,curtmp2,curtmp3;

	sprintf(fname,"%s/xt##%d-nwrd",wfp,(int)getpid());
	fp=fopen(fname,"r");
	i=0;

	while(fgets(nwrd[i],20,fp)!=NULL){
		len=strlen(nwrd[i]);
		nwrd[i][len-1]='\0';
		i++;
	}
	atm_num = i;
	fclose(fp);

	sprintf(fname,"%s/xt##%d-lwrd",wfp,(int)getpid());
	fp=fopen(fname,"r");
	j=0;
	while(fgets(lwrd[j],20,fp)!=NULL){
		len=strlen(lwrd[j]);
		lwrd[j][len-1]='\0';
		j++;
	}
	bnd_num = j;
	fclose(fp);

	//PMMLタグの生成
	doc = xmlNewDoc("1.0");
	cur = xmlNewNode(NULL,"PMML");
	xmlDocSetRootElement(doc,cur);
	xmlNewProp(cur,"version","2.1");

	//Headerタグの生成
	curtmp = xmlNewTextChild(cur,NULL,"Header",NULL);

	if(strcmp(copyright,"")){
	  xmlNewProp(curtmp,"copyright",copyright);
	}
	if(strcmp(description,"")!=0){
	  xmlNewProp(curtmp,"description",description);
	}
	//DataDictionaryタグの生成
	curtmp = xmlNewTextChild(cur,NULL,"DataDictionary",NULL);	
	xmlNewProp(curtmp,"numberOfFields","2");

	//DataFieldタグの生成
	curtmp2 = xmlNewTextChild(curtmp,NULL,"DataField",NULL);
	xmlNewProp(curtmp2,"name","atomy");
	xmlNewProp(curtmp2,"optype","categorical");
	for(i=0;i<atm_num;i++){
	  curtmp3 = xmlNewTextChild(curtmp2,NULL,"Value",NULL);
	  xmlNewProp(curtmp3,"value",nwrd[i]);
	}
	curtmp2 = xmlNewTextChild(curtmp,NULL,"DataField",NULL);
	xmlNewProp(curtmp2,"name","bondtype");
	xmlNewProp(curtmp2,"optype","categorical");
	for(i=0;i<bnd_num;i++){
	  curtmp3 = xmlNewTextChild(curtmp2,NULL,"Value",NULL);
	  xmlNewProp(curtmp3,"value",lwrd[i]);
	}

	cur = xmlNewTextChild(cur,NULL,"GraphModel",NULL);

	if(strcmp(modelname,"")){
	  xmlNewProp(cur,"modelName",modelname);
	}
	
	xmlNewProp(cur,"functionName","associationRules");	

	curtmp = xmlNewTextChild(cur,NULL,"MiningScema",NULL);
	curtmp2 = xmlNewTextChild(curtmp,NULL,"MiningField",NULL);
	xmlNewProp(curtmp2,"name","atomy");
	curtmp2 = xmlNewTextChild(curtmp,NULL,"MiningField",NULL);
	xmlNewProp(curtmp2,"name","bondtype");

	adjmat=cmat(ESFG,ESFG);

	d=transaction_num;
	for(i=2;i<trie_pos;i++){
		if(trie[i].item.size!=0 && trie[i].canoni.poin==i){
		  
		  mssGV.outCnt++;

		  curtmp = xmlNewTextChild(cur,NULL,"Graph",NULL);
		  sprintf(num,"%ld",i);

		  xmlNewProp(curtmp,"graphId",num);
		  xmlNewProp(curtmp,"miningStatus","induced");
		  sprintf(num,"%0.3f",trie[i].count/d);
		  xmlNewProp(curtmp,"support",num);

		  for(j=0;j<trie[i].item.size;j++){

		    curtmp2 = xmlNewTextChild(curtmp,NULL,"Vertex",NULL);
		    sprintf(num,"%ld",j+1);
		    xmlNewProp(curtmp2,"vertexId",num);
		    xmlNewProp(curtmp2,"dimension","1");

		    curtmp3 = xmlNewTextChild(curtmp2,NULL,"VertexLabel",NULL);
		    xmlNewProp(curtmp3,"field","atomy");
		    xmlNewProp(curtmp3,"value",nwrd[trie[i].item.nodetypes[j]-1]);

		  }
 
			decode2(adjmat,trie[i].item);
			
			e_id = 0;

			if(g_type == 2){

			  for(j=0;j<trie[i].item.size;j++){

			    for(k=j;k<trie[i].item.size;k++){

			      if(adjmat[j][k]!=0){

				e_id++;
				curtmp2 = xmlNewTextChild(curtmp,NULL,"Edge",NULL);
				sprintf(num,"%ld",e_id);
				xmlNewProp(curtmp2,"edgeId",num);
				xmlNewProp(curtmp2,"edgeType","undirected");
				xmlNewProp(curtmp2,"dimension","1");
				sprintf(num,"%ld",j+1);
				xmlNewProp(curtmp2,"bgnVertexId",num);
				sprintf(num,"%ld",k+1);
				xmlNewProp(curtmp2,"endVertexId",num);
				
				curtmp3 = xmlNewTextChild(curtmp2,NULL,"EdgeLabel",NULL);
				xmlNewProp(curtmp3,"field","bondtype");
				xmlNewProp(curtmp3,"value",lwrd[adjmat[j][k]-1]);

			      }
			      
			    }
			  }
			}
			else{

			  for(j=0;j<trie[i].item.size;j++){

			    for(k=0;k<trie[i].item.size;k++){

			      if(adjmat[j][k]!=0){

				e_id++;
				curtmp2 = xmlNewTextChild(curtmp,NULL,"Edge",NULL);
				sprintf(num,"%ld",e_id);
				xmlNewProp(curtmp2,"edgeId",num);
				xmlNewProp(curtmp2,"edgeType","undirected");
				xmlNewProp(curtmp2,"dimension","1");
				sprintf(num,"%ld",j+1);
				xmlNewProp(curtmp2,"bgnVertexId",num);
				sprintf(num,"%ld",k+1);
				xmlNewProp(curtmp2,"endVertexId",num);
				
				curtmp3 = xmlNewTextChild(curtmp2,NULL,"EdgeLabel",NULL);
				xmlNewProp(curtmp3,"field","bondtype");
				xmlNewProp(curtmp3,"value",lwrd[adjmat[j][k]-1]);

			      }
			      
			    }
			  }
			}
		}
	}
	/*sprintf(fname,"%s/xt##%d-utf",wfp,(int)getpid());*/
	xmlSaveFormatFileEnc(opf,doc,encoding,1);
	xmlFreeDoc(doc);

	/*encodingをdoc->encodingの利用によりfromutfは利用しない by Ham */
	/*fromutf(opf);*/
}

void fromutf(char* filename){

  char fname[300],enci[256],enco[512];
  size_t encilen,encolen;

#ifdef MssNeedLibiconv
    const char *encip;     /*iconv用 入力文字列を示すポインタ */
#else
    char *encip;
#endif
  char *encop;

  iconv_t *icid;

  FILE *fp1;
  FILE *fp2;

  sprintf(fname,"%s/xt##%d-utf",wfp,(int)getpid());
  fp1 = fopen(fname,"r");
  
  strcpy(fname,filename);
  fp2 = fopen(fname,"w");


	if(fp1==NULL || fp2==NULL){
    mssShowErrMsg("ファイルのオープンに失敗しました");
    mssEnd(mssErrorNoDefault);
  }


  icid = iconv_open(encoding,"UTF-8");

  while(fgets(enci,256,fp1)!=NULL){
    
    encip = enci;
    encop = enco;   
    
    encilen = strlen(enci)+1;
    encolen = encilen * 2;

    if(-1==iconv(icid,&encip,&encilen,&encop,&encolen)){
		mssShowErrMsg("character code convert error");
    mssEnd(mssErrorNoDefault);
    }
    
    fprintf(fp2,"%s",enco);
  }

  fclose(fp1);
  fclose(fp2);
}   
 

  

  


