/**
 * # CHAPTER #
 * ============================================================================
 * BONSAI関連のヘッダーファイル
 * ============================================================================
 */

#ifndef _BONSAI_H
#define _BONSAI_H

#include <usint.h>
#include <readData.h>

/**
 * # STRUCT #
 * 正規パターン関連の構造体
 */
struct Regexp {
  usint str[MaxRegLen+1]; /* マッチさせる文字列 */
  int   type;    /* 0:substring 1:subsequence 9:regular expression(for future)*/
  int   bgnRng;  /* 先頭マッチの範囲 0:先頭一致なし */
  int   endRng;  /* 末尾マッチの範囲 0:末尾一致なし */
  double objVal; /*この正規パターンの目的関数値(Gini)*/
};

/**
 * # STRUCT #
 * 正規パターンリスト
 */
struct RegTbl{
  struct Regexp *reg;
  int            cnt;
};

/**
 * # STRUCT #
 * アルファベット−インデックス構造体
 */
struct Map {
  struct mssHash *alpOrg; /*alphabetをキーとしたhash*/
                          /*値としてalphabetの内部番号を保持している*/
  char  **numAlp;         /*alphabetの内部番号→alphabetの変換の為の配列*/
                          /*alpOrgの文字列へのポインタ配列*/
  usint *alp;             /*alphabetの内部番号の配列*/
  usint *idx;             /*index番号の配列*/
  int  alpSiz;
  int  idxSiz;
};

/**
 * # STRUCT #
 * 探索するインデックス
 * usint **     *(Idxs->idx+i)       : インデックスの種類
 * usint *    *(*(Idxs->idx+i)+j)    : パターン項目の種類(-pで指定された項目数)
 * usint    *(*(*(Idxs->idx+i)+j)+k) : k番目のインデックス
 * ex)  *(*(Idxs->idx+i)+j) = "11010011\0"
 */
struct Idxs {
  usint ***idx;
  int cnt;
  int patCnt;
};

/**
 * # PROTOTYPE #
 */
struct Idxs *	initIdxs(struct Data *dat);
struct Idxs *	initIdxs0(struct Data *dat);
void		printIdxs(struct Idxs *idxs);
void		freeIdxs(struct Idxs *idxs);
void		cpyIdx(struct Data *dat, usint **idx);
void		datIndexing( struct Data *dat );
void		setRegTbl( struct Data *dat, struct Cost *cost);
void		freeRegTbl(struct Data *dat);
void		mkAtt( struct Data *dat );
void		freeAtt( struct Data *dat );
double		Log2(double x);
char		alp2idx(struct Map *map, usint alpha);
void		alpStr2idxStr(usint index[],usint *alpha, struct Map *map);
int		regCmp(usint *str,struct Regexp *reg);
struct Idxs *	setNextIdxs(struct Data *dat);
void		showMap(struct Map *map);
void		showAlphabet(struct Data *dat);
void		showIndex(struct Data *dat);
void		prnRegexp(struct Regexp *reg,struct mssFPW *fpw);
void		cpReg(struct Regexp *to, struct Regexp *from);
void		freeReg(struct Regexp *reg);

#endif
