/**
 * # CHAPTER #
 * ============================================================================
 * 分類表関連の処理関数
 * ============================================================================
 */

#include <musashi.h>
#include <classTable.h>
#include <readData.h>

/* ############ グローバル変数 ##############*/
extern int ClassSize; /*クラスのサイズ*/

/**
 * # FUNCTION #
 * ０割算時の値を指定できる割算
 */
static double divDef(double d1, double d2, double def){
  if(d2==0) return(def);
  return(d1/d2);
}

/**
 * # FUNCTION #
 * Classification Tableの初期化
 */
struct ClsTbl *initClsTbl(void){

  struct ClsTbl *ct;

  ct=mssCalloc(sizeof(struct ClsTbl),"initClsTbl");

  return(ct);

}

/**
 * # FUNCTION #
 * Classification Tableの各種指標の計算
 */
void calClsTbl(struct ClsTbl *ct, struct Cost *cost){

  int i,j;
  /*コスト計算*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->cst[i][j] = (double)ct->cnt[i][j]*cost->tbl[i][j];
    }
  }

  /*actualClass,predictedClassの合計をとる*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->atCnt[i] += ct->cnt[i][j];
      ct->ptCnt[i] += ct->cnt[j][i];
      ct->tCnt     += ct->cnt[i][j];
      ct->atCst[i] += ct->cst[i][j];
      ct->ptCst[i] += ct->cst[j][i];
      ct->tCst     += ct->cst[i][j];
    }
  }

  /*各種シェアの合計*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      ct->aShr[i][j]=divDef((double)ct->cnt[i][j],(double)ct->atCnt[i],0);
      ct->pShr[i][j]=divDef((double)ct->cnt[i][j],(double)ct->ptCnt[j],0);
    }
    ct->atShr[i]=divDef((double)ct->atCnt[i],(double)ct->tCnt,0);
    ct->ptShr[i]=divDef((double)ct->ptCnt[i],(double)ct->tCnt,0);
  }

  /*正解件数、エラー件数の計算*/
  for(i=0; i<ClassSize; i++){
    for(j=0; j<ClassSize; j++){
      if(i==j) ct->accCnt += ct->cnt[i][j];
      else     ct->errCnt += ct->cnt[i][j];
    }
  }

  /*正解率、エラー率の計算*/
  ct->accRate=divDef((double)ct->accCnt,(double)ct->tCnt,0);
  ct->errRate=divDef((double)ct->errCnt,(double)ct->tCnt,0);

  /*幾何平均の計算*/
  ct->geoMean=1;
  for(i=0; i<ClassSize; i++){
    ct->geoMean*=ct->aShr[i][i];
  }
}

/**
 * # FUNCTION #
 * Classification Tableの表示
 */
void showClsTbl(struct ClsTbl *ct,struct Data *dat, struct mssFPW *fpw){

  int i,j;

  mssWriteStr("## By count\n",fpw);
  mssWriteStr("         Predicted As ...\n",fpw);
  mssWriteStr("       ",fpw);
  for(j=0; j<ClassSize; j++){
    mssWriteStr("\t",fpw);
    mssWriteStr(dat->cls->str[j],fpw);
  }
  mssWriteStr("\tTotal\n",fpw);

  for(i=0; i<ClassSize; i++){
    mssWriteStr(dat->cls->str[i],fpw);
    for(j=0; j<ClassSize; j++){
      mssWriteStr("\t",fpw);
      mssWriteInt(ct->cnt[i][j],fpw);
    }
    mssWriteStr("\t",fpw);
    mssWriteInt(ct->atCnt[i],fpw);
    mssWriteRet(fpw);
  }
  mssWriteStr("Total",fpw);
  for(i=0; i<ClassSize; i++){
    mssWriteStr("\t",fpw);
    mssWriteInt(ct->ptCnt[i],fpw);
  }
  mssWriteStr("\t",fpw);
  mssWriteInt(ct->tCnt,fpw);
  mssWriteRet(fpw);
  mssWriteRet(fpw);

  mssWriteStr("## By cost\n",fpw);
  mssWriteStr("         Predicted As ...\n",fpw);
  mssWriteStr("       ",fpw);
  for(j=0; j<ClassSize; j++){
    mssWriteStr("\t",fpw);
    mssWriteStr(dat->cls->str[j],fpw);
  }
  mssWriteStr("\tTotal\n",fpw);

  for(i=0; i<ClassSize; i++){
    mssWriteStr(dat->cls->str[i],fpw);
    for(j=0; j<ClassSize; j++){
      mssWriteStr("\t",fpw);
      mssWriteDbl(ct->cst[i][j],fpw);
    }
    mssWriteStr("\t",fpw);
    mssWriteDbl(ct->atCst[i],fpw);
    mssWriteRet(fpw);
  }
  mssWriteStr("Total",fpw);
  for(i=0; i<ClassSize; i++){
    mssWriteStr("\t",fpw);
    mssWriteDbl(ct->ptCst[i],fpw);
  }
  mssWriteStr("\t",fpw);
  mssWriteDbl(ct->tCst,fpw);
  mssWriteRet(fpw);
  mssWriteRet(fpw);

  mssWriteStr("## Summary\n",fpw);
  mssWriteStr("accuracy=",fpw);
  mssWriteDbl(ct->accRate,fpw);
  mssWriteRet(fpw);
  mssWriteStr("totalCost=",fpw);
  mssWriteDbl(ct->tCst,fpw);
  mssWriteRet(fpw);
}
