/**
 * # CHAPTER #
 * ============================================================================
 * 分類表関連のヘッダーファイル
 * ============================================================================
 */

#ifndef _CLASSTABLE_H
#define _CLASSTABLE_H

#include <readData.h>

/**
 * # STRUCT #
 * 分類表構造体
 * +--------+------------------------------------------+
 * |        |  Predicted as                            +
 * |        +---------+---------+---+---------+--------+
 * |        |  cls0   |  cls1   |...|  clsN   | Total  |
 * +---+----+---------+---------+---+---------+--------+
 * |   |    | cnt[0,0]| cnt[0,1]|   | cnt[0,N]|atCnt[0]|
 * | A |cls0|aShr[0,0]|aShr[0,1]|   |aShr[0,N]|atShr[0]|
 * | c |    |pShr[0,0]|pShr[0,1]|   |pShr[0,N]|        |
 * | t |    | cst[0,0]| cst[0,1]|   | cst[0,N]|atCst[0]|
 * | u +----+---------+---------+---+---------+--------+
 * | a |    | cnt[1,0]| cnt[1,1]|   | cnt[1,N]|atCnt[1]|
 * | l |cls1|aShr[1,0]|aShr[1,1]|   |aShr[1,N]|atShr[1]|
 * |   |    |pShr[1,0]|pShr[1,1]|   |pShr[1,N]|        |
 * |   |    | cst[1,0]| cst[1,1]|   | cst[1,N]|atCst[1]|
 * |   +----+---------+---------+---+---------+--------+
 * |   |    |         |         | : |         |        |
 * |   +----+---------+---------+---+---------+--------+
 * |   |    | cnt[N,0]| cnt[N,1]|   | cnt[N,N]|atCnt[N]|
 * |   |clsN|aShr[N,0]|aShr[N,1]|   |aShr[N,N]|atShr[N]|
 * |   |    |pShr[N,0]|pShr[N,1]|   |pShr[N,N]|        |
 * |   |    | cst[N,0]| cst[N,1]|   | cst[N,N]|atCst[N]|
 * |   +----+---------+---------+---+---------+--------+
 * |   |    | ptCnt[0]| ptCnt[1]|   | ptCnt[N]|   tCnt |
 * |   |Ttl | ptShr[0]| ptShr[1]|   | ptShr[N]|        |
 * |   |    | ptCst[0]| ptCst[1]|   | ptCst[N]|   tCst |
 * +---+----+---------+---------+---+---------+--------+
 * aShr[x,y]=cnt[x,y]/atCnt[x]
 * pShr[x,y]=cnt[x,y]/ptCnt[y]
 * atShr[x]=atCnt[x]/tCnt
 * ptShr[x]=ptCnt[x]/tCnt
 */
struct ClsTbl {
  int      cnt[MaxClsLen][MaxClsLen]; /*各セルの件数*/
  double  aShr[MaxClsLen][MaxClsLen]; /*actualTotalに対するシェア*/
  double  pShr[MaxClsLen][MaxClsLen]; /*predictedTotalに対するシェア*/
  double   cst[MaxClsLen][MaxClsLen]; /*各セルのコスト*/
  int    atCnt[MaxClsLen];            /*actualTotal件数*/
  double atShr[MaxClsLen];            /*actualTotalのtotalに対するシェア*/
  double atCst[MaxClsLen];            /*actualTotalコスト*/
  int    ptCnt[MaxClsLen];            /*predictedTotal件数*/
  double ptShr[MaxClsLen];            /*predictedTotalのtotalに対するシェア*/
  double ptCst[MaxClsLen];            /*predictedTotalコスト*/
  int    tCnt;                       /*total件数*/
  double tCst;                       /*totalコスト*/

  int    accCnt;                     /*正解件数*/
  int    errCnt;                     /*エラー件数*/
  double accRate;                    /*正解率 accCnt/tCnt*/
  double errRate;                    /*エラー率 errCnt/tCnt*/
  double geoMean;                    /*各クラス正解率の幾何平均(実際は二乗和)*/
};

/**
 * # PROTOTYPE #
 */
struct ClsTbl *initClsTbl(void);
void calClsTbl(struct ClsTbl *ct, struct Cost *cost);
void showClsTbl(struct ClsTbl *ct,struct Data *dat,struct mssFPW *fpw);

#endif
